/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.workspace;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.CRC32;
import net.lax1dude.eaglercraft.v1_8.buildtools.workspace.MakeOfflineDownload;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZOutputStream;

public class MakeWASMClientBundle {
    public static void main(String[] stringArray) throws IOException {
        FileOutputStream fileOutputStream;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object62;
        Object object7;
        Object object8;
        String string;
        Object object9;
        if (stringArray.length != 3) {
            System.err.println("Usage: java -jar CompilePackageWASM.jar <epw_src.txt> <epw_meta.txt> <output folder>");
            return;
        }
        ArrayList<EPKStruct> arrayList = new ArrayList<EPKStruct>();
        File file = new File(stringArray[0]);
        System.out.println();
        System.out.println("Parsing: " + file.getAbsolutePath());
        Properties properties = new Properties();
        Object object10 = null;
        String string2 = null;
        try {
            object9 = new FileInputStream(file);
            try {
                properties.load((InputStream)object9);
            }
            finally {
                if (object9 != null) {
                    ((InputStream)object9).close();
                }
            }
        }
        catch (Throwable throwable) {
            if (object10 == null) {
                object10 = throwable;
            } else if (object10 != throwable) {
                ((Throwable)object10).addSuppressed(throwable);
            }
            throw object10;
        }
        object10 = MakeWASMClientBundle.getRequired(properties, "offline-download-template");
        string2 = MakeWASMClientBundle.getRequired(properties, "offline-download-script");
        object9 = MakeWASMClientBundle.getRequired(properties, "offline-download-name");
        File file2 = new File(MakeWASMClientBundle.getRequired(properties, "loader-js-file"));
        File file3 = new File(MakeWASMClientBundle.getRequired(properties, "loader-wasm-file"));
        File file4 = new File(MakeWASMClientBundle.getRequired(properties, "eagruntime-js-file"));
        File file5 = new File(MakeWASMClientBundle.getRequired(properties, "classes-wasm-file"));
        File file6 = null;
        File file7 = null;
        if (properties.getProperty("classes-deobf-wasm-file") != null) {
            file6 = new File(MakeWASMClientBundle.getRequired(properties, "classes-deobf-teadbg-file"));
            file7 = new File(MakeWASMClientBundle.getRequired(properties, "classes-deobf-wasm-file"));
        }
        int n = 0;
        while (true) {
            if ((string = properties.getProperty("assets-epk-" + n + "-file")) == null) {
                if (n != 0) break;
                throw new IllegalArgumentException("At least 1 EPK file must be specified!");
            }
            object8 = properties.getProperty("assets-epk-" + n + "-path");
            if (object8 == null) {
                object8 = "";
            } else {
                if (((String)object8).startsWith("/")) {
                    object8 = ((String)object8).substring(1);
                }
                if (((String)object8).endsWith("/")) {
                    object8 = ((String)object8).substring(0, ((String)object8).length() - 1);
                }
            }
            arrayList.add(new EPKStruct((String)object8, string));
            ++n;
        }
        File file8 = new File(MakeWASMClientBundle.getRequired(properties, "splash-logo-image-file"));
        string = MakeWASMClientBundle.getRequired(properties, "splash-logo-image-mime");
        object8 = new File(MakeWASMClientBundle.getRequired(properties, "press-any-key-image-file"));
        String string3 = MakeWASMClientBundle.getRequired(properties, "press-any-key-image-mime");
        File file9 = new File(MakeWASMClientBundle.getRequired(properties, "crash-logo-image-file"));
        String string4 = MakeWASMClientBundle.getRequired(properties, "crash-logo-image-mime");
        File file10 = new File(MakeWASMClientBundle.getRequired(properties, "favicon-image-file"));
        String string5 = MakeWASMClientBundle.getRequired(properties, "favicon-image-mime");
        File file11 = new File(MakeWASMClientBundle.getRequired(properties, "jspi-unavailable-file"));
        file = new File(stringArray[1]);
        System.out.println("Parsing: " + file.getAbsolutePath());
        Properties properties2 = new Properties();
        Throwable throwable = null;
        String string6 = null;
        try {
            object7 = new FileInputStream(file);
            try {
                properties2.load((InputStream)object7);
            }
            finally {
                if (object7 != null) {
                    ((InputStream)object7).close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        int n2 = Integer.parseInt(MakeWASMClientBundle.getRequired(properties2, "client-version-integer"));
        string6 = MakeWASMClientBundle.getRequired(properties2, "client-package-name");
        object7 = MakeWASMClientBundle.getRequired(properties2, "client-origin-name");
        String string7 = MakeWASMClientBundle.getRequired(properties2, "client-origin-version");
        String string8 = MakeWASMClientBundle.getRequired(properties2, "client-origin-vendor");
        String string9 = MakeWASMClientBundle.getRequired(properties2, "client-fork-name");
        String string10 = MakeWASMClientBundle.getRequired(properties2, "client-fork-version");
        String string11 = MakeWASMClientBundle.getRequired(properties2, "client-fork-vendor");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Object object62 : properties2.keySet()) {
            object5 = object62.toString();
            if (!((String)object5).startsWith("metadata-")) continue;
            hashMap.put(((String)object5).substring(9), properties2.getProperty((String)object5));
        }
        System.out.println();
        System.out.println("Reading: " + file2.getAbsolutePath());
        object62 = MakeWASMClientBundle.getFileBytes(file2);
        System.out.println("Reading: " + file3.getAbsolutePath());
        Object object11 = MakeWASMClientBundle.getFileBytes(file3);
        System.out.println("Reading: " + file4.getAbsolutePath());
        object5 = MakeWASMClientBundle.getFileBytes(file4);
        System.out.println("Reading: " + file5.getAbsolutePath());
        byte[] byArray = MakeWASMClientBundle.getFileBytes(file5);
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (file7 != null) {
            System.out.println("Reading: " + file6.getAbsolutePath());
            byArray2 = MakeWASMClientBundle.getFileBytes(file6);
            System.out.println("Reading: " + file7.getAbsolutePath());
            byArray3 = MakeWASMClientBundle.getFileBytes(file7);
        }
        int n3 = 0;
        int n4 = arrayList.size();
        while (n3 < n4) {
            object4 = (EPKStruct)arrayList.get(n3);
            if (((EPKStruct)object4).epkFile.isFile()) {
                System.out.println("Reading: " + ((EPKStruct)object4).epkFile.getAbsolutePath());
                ((EPKStruct)object4).epkData = MakeWASMClientBundle.getFileBytes(((EPKStruct)object4).epkFile);
            } else {
                System.out.println("Generating EPK: " + ((EPKStruct)object4).epkFile.getAbsolutePath());
                ((EPKStruct)object4).epkData = MakeWASMClientBundle.makeEPK(((EPKStruct)object4).epkFile, new File("._assets." + n3 + ".0.tmp"));
            }
            ++n3;
        }
        System.out.println("Reading: " + file8.getAbsolutePath());
        byte[] byArray4 = MakeWASMClientBundle.getFileBytes(file8);
        System.out.println("Reading: " + ((File)object8).getAbsolutePath());
        byte[] byArray5 = MakeWASMClientBundle.getFileBytes((File)object8);
        System.out.println("Reading: " + file9.getAbsolutePath());
        object4 = MakeWASMClientBundle.getFileBytes(file9);
        System.out.println("Reading: " + file10.getAbsolutePath());
        byte[] byArray6 = MakeWASMClientBundle.getFileBytes(file10);
        System.out.println("Reading: " + file11.getAbsolutePath());
        byte[] byArray7 = MakeWASMClientBundle.getFileBytes(file11);
        System.out.println();
        System.out.println("Compressing eagruntime.js");
        byte[] byArray8 = MakeWASMClientBundle.compressFileBytes((byte[])object5);
        System.out.println("Compressing classes.wasm");
        byte[] byArray9 = MakeWASMClientBundle.compressFileBytes(byArray);
        byte[] byArray10 = null;
        byte[] byArray11 = null;
        if (byArray3 != null) {
            System.out.println("Compressing classes.wasm teadbg");
            byArray10 = MakeWASMClientBundle.compressFileBytes(byArray2);
            System.out.println("Compressing classes.wasm deobfuscator");
            byArray11 = MakeWASMClientBundle.compressFileBytes(byArray3);
        }
        int n5 = 0;
        int n6 = arrayList.size();
        while (n5 < n6) {
            object3 = (EPKStruct)arrayList.get(n5);
            System.out.println("Compressing EPK #" + n5 + ": " + ((EPKStruct)object3).epkFilePathStr);
            ((EPKStruct)object3).epkDataCompressed = MakeWASMClientBundle.compressFileBytes(((EPKStruct)object3).epkData);
            ++n5;
        }
        System.out.println("Compressing JSPI unavailable screen");
        byte[] byArray12 = MakeWASMClientBundle.compressFileBytes(byArray7);
        System.out.println();
        System.out.println("Generating EPW...");
        n6 = 276 + 32 * arrayList.size() + 127 & 0xFFFFFF80;
        object3 = new HashMap();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataSegment dataSegment = MakeWASMClientBundle.poolString(string6, (Map<String, DataSegment>)object3, byteArrayOutputStream);
        DataSegment dataSegment2 = MakeWASMClientBundle.poolString((String)object7, (Map<String, DataSegment>)object3, byteArrayOutputStream);
        DataSegment dataSegment3 = MakeWASMClientBundle.poolString(string7, (Map<String, DataSegment>)object3, byteArrayOutputStream);
        DataSegment dataSegment4 = MakeWASMClientBundle.poolString(string8, (Map<String, DataSegment>)object3, byteArrayOutputStream);
        DataSegment dataSegment5 = MakeWASMClientBundle.poolString(string9, (Map<String, DataSegment>)object3, byteArrayOutputStream);
        DataSegment dataSegment6 = MakeWASMClientBundle.poolString(string10, (Map<String, DataSegment>)object3, byteArrayOutputStream);
        DataSegment dataSegment7 = MakeWASMClientBundle.poolString(string11, (Map<String, DataSegment>)object3, byteArrayOutputStream);
        DataSegment dataSegment8 = MakeWASMClientBundle.poolString(string, (Map<String, DataSegment>)object3, byteArrayOutputStream);
        DataSegment dataSegment9 = MakeWASMClientBundle.poolString(string3, (Map<String, DataSegment>)object3, byteArrayOutputStream);
        DataSegment dataSegment10 = MakeWASMClientBundle.poolString(string4, (Map<String, DataSegment>)object3, byteArrayOutputStream);
        DataSegment dataSegment11 = MakeWASMClientBundle.poolString(string5, (Map<String, DataSegment>)object3, byteArrayOutputStream);
        int n7 = 0;
        int n8 = arrayList.size();
        while (n7 < n8) {
            EPKStruct ePKStruct = (EPKStruct)arrayList.get(n7);
            ePKStruct.epkFilePath = MakeWASMClientBundle.poolString(ePKStruct.epkFilePathStr, (Map<String, DataSegment>)object3, byteArrayOutputStream);
            ePKStruct.epkLoadPath = MakeWASMClientBundle.poolString(ePKStruct.epkLoadPathStr, (Map<String, DataSegment>)object3, byteArrayOutputStream);
            ++n7;
        }
        n7 = 0;
        n8 = 0;
        if (!hashMap.isEmpty()) {
            int n9 = hashMap.size();
            n8 = 4 + n9 * 8;
            byte[] byArray13 = new byte[n8];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray13).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putInt(n9);
            for (Map.Entry entry : hashMap.entrySet()) {
                DataSegment dataSegment12 = MakeWASMClientBundle.poolString((String)entry.getKey(), (Map<String, DataSegment>)object3, byteArrayOutputStream);
                DataSegment dataSegment13 = MakeWASMClientBundle.poolString((String)entry.getValue(), (Map<String, DataSegment>)object3, byteArrayOutputStream);
                byteBuffer.putInt(dataSegment12.offset + n6);
                byteBuffer.putInt(dataSegment12.length);
                byteBuffer.putInt(dataSegment13.offset + n6);
                byteBuffer.putInt(dataSegment13.length);
            }
            n7 = byteArrayOutputStream.size();
            byteArrayOutputStream.write(byArray13);
        }
        int n10 = byteArrayOutputStream.size();
        byteArrayOutputStream.write(byArray4);
        int n11 = byteArrayOutputStream.size();
        byteArrayOutputStream.write(byArray5);
        int n12 = byteArrayOutputStream.size();
        byteArrayOutputStream.write((byte[])object4);
        int n13 = byteArrayOutputStream.size();
        byteArrayOutputStream.write(byArray6);
        int n14 = byteArrayOutputStream.size();
        byteArrayOutputStream.write((byte[])object62);
        int n15 = byteArrayOutputStream.size();
        byteArrayOutputStream.write((byte[])object11);
        int n16 = byteArrayOutputStream.size();
        byteArrayOutputStream.write(byArray12);
        int n17 = byteArrayOutputStream.size();
        byteArrayOutputStream.write(byArray8);
        int n18 = byteArrayOutputStream.size();
        byteArrayOutputStream.write(byArray9);
        int n19 = 0;
        if (byArray10 != null) {
            n19 = byteArrayOutputStream.size();
            byteArrayOutputStream.write(byArray10);
        }
        int n20 = 0;
        if (byArray11 != null) {
            n20 = byteArrayOutputStream.size();
            byteArrayOutputStream.write(byArray11);
        }
        int n21 = 0;
        int n22 = arrayList.size();
        while (n21 < n22) {
            object2 = (EPKStruct)arrayList.get(n21);
            ((EPKStruct)object2).epkDataOffset = byteArrayOutputStream.size();
            byteArrayOutputStream.write(((EPKStruct)object2).epkDataCompressed);
            ++n21;
        }
        byte[] byArray14 = byteArrayOutputStream.toByteArray();
        byte[] byArray15 = new byte[n6];
        object2 = ByteBuffer.wrap(byArray15).order(ByteOrder.LITTLE_ENDIAN);
        ((ByteBuffer)object2).put(new byte[]{69, 65, 71, 36, 87, 65, 83, 77});
        ((ByteBuffer)object2).putInt(8, 0);
        ((ByteBuffer)object2).putInt(12, 0);
        ((ByteBuffer)object2).putShort(16, (short)1);
        ((ByteBuffer)object2).putShort(18, (short)1);
        ((ByteBuffer)object2).putInt(20, n2);
        ((ByteBuffer)object2).putInt(24, dataSegment.offset + n6);
        ((ByteBuffer)object2).putInt(28, dataSegment.length);
        ((ByteBuffer)object2).putInt(32, dataSegment2.offset + n6);
        ((ByteBuffer)object2).putInt(36, dataSegment2.length);
        ((ByteBuffer)object2).putInt(40, dataSegment3.offset + n6);
        ((ByteBuffer)object2).putInt(44, dataSegment3.length);
        ((ByteBuffer)object2).putInt(48, dataSegment4.offset + n6);
        ((ByteBuffer)object2).putInt(52, dataSegment4.length);
        ((ByteBuffer)object2).putInt(56, dataSegment5.offset + n6);
        ((ByteBuffer)object2).putInt(60, dataSegment5.length);
        ((ByteBuffer)object2).putInt(64, dataSegment6.offset + n6);
        ((ByteBuffer)object2).putInt(68, dataSegment6.length);
        ((ByteBuffer)object2).putInt(72, dataSegment7.offset + n6);
        ((ByteBuffer)object2).putInt(76, dataSegment7.length);
        ((ByteBuffer)object2).putInt(80, n7 + n6);
        ((ByteBuffer)object2).putInt(84, n8);
        ((ByteBuffer)object2).putLong(88, System.currentTimeMillis());
        ((ByteBuffer)object2).putInt(96, arrayList.size());
        ((ByteBuffer)object2).putInt(100, n10 + n6);
        ((ByteBuffer)object2).putInt(104, byArray4.length);
        ((ByteBuffer)object2).putInt(108, dataSegment8.offset + n6);
        ((ByteBuffer)object2).putInt(112, dataSegment8.length);
        ((ByteBuffer)object2).putInt(116, n11 + n6);
        ((ByteBuffer)object2).putInt(120, byArray5.length);
        ((ByteBuffer)object2).putInt(124, dataSegment9.offset + n6);
        ((ByteBuffer)object2).putInt(128, dataSegment9.length);
        ((ByteBuffer)object2).putInt(132, n12 + n6);
        ((ByteBuffer)object2).putInt(136, ((Object)object4).length);
        ((ByteBuffer)object2).putInt(140, dataSegment10.offset + n6);
        ((ByteBuffer)object2).putInt(144, dataSegment10.length);
        ((ByteBuffer)object2).putInt(148, n13 + n6);
        ((ByteBuffer)object2).putInt(152, byArray6.length);
        ((ByteBuffer)object2).putInt(156, dataSegment11.offset + n6);
        ((ByteBuffer)object2).putInt(160, dataSegment11.length);
        ((ByteBuffer)object2).putInt(164, n14 + n6);
        ((ByteBuffer)object2).putInt(168, ((Object)object62).length);
        ((ByteBuffer)object2).putInt(172, 0);
        ((ByteBuffer)object2).putInt(176, 0);
        ((ByteBuffer)object2).putInt(180, n15 + n6);
        ((ByteBuffer)object2).putInt(184, ((Object)object11).length);
        ((ByteBuffer)object2).putInt(188, 0);
        ((ByteBuffer)object2).putInt(192, 0);
        ((ByteBuffer)object2).putInt(196, n16 + n6);
        ((ByteBuffer)object2).putInt(200, byArray12.length);
        ((ByteBuffer)object2).putInt(204, byArray7.length);
        ((ByteBuffer)object2).putInt(208, 0);
        ((ByteBuffer)object2).putInt(212, n17 + n6);
        ((ByteBuffer)object2).putInt(216, byArray8.length);
        ((ByteBuffer)object2).putInt(220, ((Object)object5).length);
        ((ByteBuffer)object2).putInt(224, 0);
        ((ByteBuffer)object2).putInt(228, n18 + n6);
        ((ByteBuffer)object2).putInt(232, byArray9.length);
        ((ByteBuffer)object2).putInt(236, byArray.length);
        ((ByteBuffer)object2).putInt(240, 0);
        ((ByteBuffer)object2).putInt(244, n19 != 0 ? n19 + n6 : 0);
        ((ByteBuffer)object2).putInt(248, byArray10 != null ? byArray10.length : 0);
        ((ByteBuffer)object2).putInt(252, byArray2 != null ? byArray2.length : 0);
        ((ByteBuffer)object2).putInt(256, 0);
        ((ByteBuffer)object2).putInt(260, n20 != 0 ? n20 + n6 : 0);
        ((ByteBuffer)object2).putInt(264, byArray11 != null ? byArray11.length : 0);
        ((ByteBuffer)object2).putInt(268, byArray3 != null ? byArray3.length : 0);
        ((ByteBuffer)object2).putInt(272, 0);
        int n23 = 0;
        int n24 = arrayList.size();
        while (n23 < n24) {
            object = (EPKStruct)arrayList.get(n23);
            int n25 = 276 + n23 * 32;
            ((ByteBuffer)object2).putInt(n25, ((EPKStruct)object).epkFilePath.offset + n6);
            ((ByteBuffer)object2).putInt(n25 + 4, ((EPKStruct)object).epkFilePath.length);
            ((ByteBuffer)object2).putInt(n25 + 8, ((EPKStruct)object).epkLoadPath.length > 0 ? ((EPKStruct)object).epkLoadPath.offset + n6 : 0);
            ((ByteBuffer)object2).putInt(n25 + 12, ((EPKStruct)object).epkLoadPath.length);
            ((ByteBuffer)object2).putInt(n25 + 16, ((EPKStruct)object).epkDataOffset + n6);
            ((ByteBuffer)object2).putInt(n25 + 20, ((EPKStruct)object).epkDataCompressed.length);
            ((ByteBuffer)object2).putInt(n25 + 24, ((EPKStruct)object).epkData.length);
            ((ByteBuffer)object2).putInt(n25 + 28, 0);
            ++n23;
        }
        System.out.println();
        System.out.println("Calculating final CRC32...");
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray15, 16, n6 - 16);
        cRC32.update(byArray14);
        ((ByteBuffer)object2).putInt(8, n6 + byArray14.length);
        ((ByteBuffer)object2).putInt(12, (int)cRC32.getValue());
        File file12 = new File(stringArray[stringArray.length - 1]);
        System.out.println();
        System.out.println("Writing destination file...");
        object = new File(file12, "assets.epw");
        Throwable throwable3 = null;
        Object var82_106 = null;
        try {
            fileOutputStream = new FileOutputStream((File)object);
            try {
                ((OutputStream)fileOutputStream).write(byArray15);
                ((OutputStream)fileOutputStream).write(byArray14);
            }
            finally {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
        System.out.println();
        System.out.println("Copying favicon.png...");
        throwable3 = null;
        var82_106 = null;
        try {
            fileOutputStream = new FileOutputStream(new File(file12, "favicon.png"));
            try {
                ((OutputStream)fileOutputStream).write(byArray6);
            }
            finally {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable3 == null) {
                throwable3 = throwable5;
            } else if (throwable3 != throwable5) {
                throwable3.addSuppressed(throwable5);
            }
            throw throwable3;
        }
        System.out.println();
        MakeOfflineDownload.main((String[])new String[]{object10, string2, ((File)object).getAbsolutePath(), new File(file12, (String)object9).getAbsolutePath()});
        System.out.println();
        System.out.println("Done!");
        System.out.println();
    }

    private static String getRequired(Properties properties, String string) throws IOException {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            throw new IOException("Required option is missing from EPW properties: " + string);
        }
        return string2.toString();
    }

    private static DataSegment poolString(String string, Map<String, DataSegment> map, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        if (string == null || string.length() == 0) {
            return new DataSegment(0, 0);
        }
        DataSegment dataSegment = map.get(string);
        if (dataSegment == null) {
            int n = byteArrayOutputStream.size();
            byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
            dataSegment = new DataSegment(n, byArray.length);
            map.put(string, dataSegment);
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(0);
            return dataSegment;
        }
        return dataSegment;
    }

    private static byte[] getFileBytes(File file) throws IOException {
        byte[] byArray = new byte[(int)file.length()];
        int n = 0;
        Throwable throwable = null;
        Object var5_5 = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int n2;
            while (n < byArray.length && (n2 = ((InputStream)fileInputStream).read(byArray, n, byArray.length - n)) != -1) {
                n += n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return byArray;
    }

    private static byte[] compressFileBytes(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        LZMA2Options lZMA2Options = new LZMA2Options(9);
        lZMA2Options.setDictSize(0x2000000);
        Throwable throwable = null;
        Object var4_5 = null;
        try (XZOutputStream xZOutputStream = new XZOutputStream((OutputStream)byteArrayOutputStream, (FilterOptions)lZMA2Options, 1);){
            xZOutputStream.write(byArray);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] makeEPK(File file, File file2) throws IOException {
        Object object;
        try {
            object = Class.forName("CompilePackage").getDeclaredMethod("main", String[].class);
            ((Method)object).invoke(null, new Object[]{new String[]{file.getAbsolutePath(), file2.getAbsolutePath(), "none"}});
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException("Failed to run EPKCompiler!", throwable);
        }
        catch (Throwable throwable) {
            throw new IOException("Failed to run EPKCompiler!", throwable);
        }
        object = MakeWASMClientBundle.getFileBytes(file2);
        file2.delete();
        return object;
    }

    private static class DataSegment {
        private final int offset;
        private final int length;

        private DataSegment(int n, int n2) {
            this.offset = n;
            this.length = n2;
        }
    }

    private static class EPKStruct {
        private final String epkLoadPathStr;
        private DataSegment epkLoadPath;
        private final File epkFile;
        private final String epkFilePathStr;
        private DataSegment epkFilePath;
        private byte[] epkData;
        private byte[] epkDataCompressed;
        private int epkDataOffset;

        private EPKStruct(String string, String string2) {
            this.epkLoadPathStr = string;
            this.epkFile = new File(string2);
            this.epkFilePathStr = this.epkFile.getName();
        }
    }
}

