/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.media.video;

import dev.onvoid.webrtc.internal.RefCounted;
import dev.onvoid.webrtc.media.video.VideoFrameBuffer;

public class VideoFrame
implements RefCounted {
    public final VideoFrameBuffer buffer;
    public final int rotation;
    public final long timestampNs;

    private VideoFrame(VideoFrameBuffer buffer, int rotation, long timestampNs) {
        if (buffer == null) {
            throw new IllegalArgumentException("VideoFrameBuffer must not be null");
        }
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("Rotation must be a multiple of 90");
        }
        this.buffer = buffer;
        this.rotation = rotation;
        this.timestampNs = timestampNs;
    }

    @Override
    public void retain() {
        this.buffer.retain();
    }

    @Override
    public void release() {
        this.buffer.release();
    }

    public String toString() {
        return String.format("%s@%d [buffer=%s, rotation=%s, timestampNs=%s]", VideoFrame.class.getSimpleName(), this.hashCode(), this.buffer, this.rotation, this.timestampNs);
    }
}

