/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.workspace;

import com.jcraft.jzlib.GZIPOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import net.lax1dude.eaglercraft.v1_8.buildtools.workspace.Base64;
import net.lax1dude.eaglercraft.v1_8.buildtools.workspace.GeneralDigest;
import net.lax1dude.eaglercraft.v1_8.buildtools.workspace.SHA256Digest;

public class MakeSignedClient {
    private static final String USE_STRICT = "\"use strict\";";
    public static final int torrentBlockSize = 65280;

    public static void main(String[] stringArray) throws IOException {
        FileOutputStream fileOutputStream;
        Object object7;
        byte[] byArray;
        String string;
        ByteArrayOutputStream byteArrayOutputStream;
        Object object2;
        Object object3;
        Object object4;
        Object[] objectArray;
        Object object5;
        if (stringArray.length != 6 && stringArray.length != 7) {
            System.err.println("Usage: MakeSignedClient.jar <template.txt> <classes.js> <assets.epk> [languages dir] <template.html> <downloadSources.txt> <output.html>");
        }
        System.out.println();
        System.out.println("Generating signed client...");
        System.out.println();
        System.out.println("Loading file: " + stringArray[0]);
        String string2 = new String(MakeSignedClient.loadFile(new File(stringArray[0])), StandardCharsets.UTF_8);
        System.out.println("Loading file: " + stringArray[stringArray.length - 3]);
        String string3 = new String(MakeSignedClient.loadFile(new File(stringArray[stringArray.length - 3])), StandardCharsets.UTF_8);
        System.out.println("Loading file: " + stringArray[stringArray.length - 2]);
        String string4 = new String(MakeSignedClient.loadFile(new File(stringArray[stringArray.length - 2])), StandardCharsets.UTF_8);
        String string5 = new SimpleDateFormat("MM/dd/yyyy").format(new Date());
        System.out.println();
        System.out.println("Using date: " + string5);
        System.out.println();
        File file = new File(String.valueOf(stringArray[stringArray.length - 1]) + ".dat");
        if (!file.isFile()) {
            object5 = new StringBuilder();
            objectArray = stringArray[1].split("\\" + System.getProperty("path.separator"));
            int n = 0;
            while (n < objectArray.length) {
                System.out.println("Loading file: " + objectArray[n]);
                object4 = new String(MakeSignedClient.loadFile(new File(objectArray[n])), StandardCharsets.UTF_8);
                if (((String)object4).startsWith(USE_STRICT)) {
                    object4 = ((String)object4).substring(USE_STRICT.length());
                }
                if (n > 0) {
                    ((StringBuilder)object5).append("\n\n");
                }
                ((StringBuilder)object5).append((String)object4);
                ++n;
            }
            System.out.println("Loading file: " + stringArray[2]);
            object3 = Base64.encodeBase64String(MakeSignedClient.loadFile(new File(stringArray[2])));
            object4 = null;
            if (stringArray.length == 7) {
                if (stringArray[3].endsWith(".epk")) {
                    System.out.println("Loading file: " + stringArray[3]);
                    object4 = Base64.encodeBase64String(MakeSignedClient.loadFile(new File(stringArray[5])));
                } else {
                    System.out.println();
                    System.out.println("Building EPK: " + stringArray[3]);
                    object2 = new File(stringArray[3]);
                    object4 = Base64.encodeBase64String(MakeSignedClient.makeEPK((File)object2, new File(((File)object2).getParentFile(), "languages.tmp.epk")));
                }
            }
            System.out.println();
            string2 = object4 != null ? string2.replace("${assets_epk}", "[ { url: \"data:application/octet-stream;base64," + (String)object3 + "\" }, { url: \"data:application/octet-stream;base64," + (String)object4 + "\", path: \"assets/minecraft/lang/\" } ]") : string2.replace("${assets_epk}", "\"data:application/octet-stream;base64," + (String)object3 + "\"");
            string2 = string2.replace("${classes_js}", ((StringBuilder)object5).toString());
            System.out.println();
            System.out.println("Compressing bundle...");
            System.out.println();
            byteArrayOutputStream = new ByteArrayOutputStream();
            object2 = null;
            string = null;
            try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)byteArrayOutputStream);){
                gZIPOutputStream.write(string2.getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable) {
                if (object2 == null) {
                    object2 = throwable;
                } else if (object2 != throwable) {
                    ((Throwable)object2).addSuppressed(throwable);
                }
                throw object2;
            }
            byArray = byteArrayOutputStream.toByteArray();
        } else {
            System.out.println();
            System.out.println("File \"" + file.getAbsolutePath() + "\" already exists!");
            System.out.println("Delete it to fully recompile client!");
            System.out.println();
            System.out.println("Loading file: " + file.getName());
            byArray = MakeSignedClient.loadFile(file);
        }
        System.out.println();
        System.out.println("Generating signature...");
        System.out.println();
        object5 = new SHA256Digest();
        ((GeneralDigest)object5).update(byArray, 0, byArray.length);
        objectArray = new byte[32];
        ((SHA256Digest)object5).doFinal((byte[])objectArray, 0);
        byteArrayOutputStream = new ByteArrayOutputStream();
        object3 = new DataOutputStream((OutputStream)new GZIPOutputStream((OutputStream)byteArrayOutputStream));
        ((DataOutputStream)object3).writeLong(System.currentTimeMillis());
        ((DataOutputStream)object3).writeInt(byArray.length);
        ((FilterOutputStream)object3).write((byte[])objectArray);
        object4 = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        object2 = "net.lax1dude.eaglercraft.v1_8.client";
        System.out.print("Enter package name string [" + (String)object2 + "]: ");
        string = ((BufferedReader)object4).readLine().trim();
        ((DataOutputStream)object3).writeUTF((String)(string.length() == 0 ? object2 : string));
        object2 = "EaglercraftX 1.8";
        System.out.print("Enter display name string [" + (String)object2 + "]: ");
        string = ((BufferedReader)object4).readLine().trim();
        ((DataOutputStream)object3).writeUTF((String)(string.length() == 0 ? object2 : string));
        System.out.print("Enter author string: ");
        ((DataOutputStream)object3).writeUTF(((BufferedReader)object4).readLine().trim());
        System.out.print("Enter version integer: ");
        int n = Integer.parseInt(((BufferedReader)object4).readLine().trim());
        ((DataOutputStream)object3).writeInt(n);
        object2 = "u" + n;
        System.out.print("Enter display version string [" + (String)object2 + "]: ");
        string = ((BufferedReader)object4).readLine().trim();
        ((DataOutputStream)object3).writeUTF((String)(string.length() == 0 ? object2 : string));
        System.out.print("Enter version comment: ");
        ((DataOutputStream)object3).writeUTF(((BufferedReader)object4).readLine().trim().replace("\\n", "\n"));
        SecureRandom secureRandom = new SecureRandom();
        int n2 = secureRandom.nextInt(128) + 64;
        ((DataOutputStream)object3).write(n2);
        byte[] byArray2 = new byte[n2];
        secureRandom.nextBytes(byArray2);
        ((FilterOutputStream)object3).write(byArray2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object6 = string4.split("(\\r\\n|\\r|\\n)+");
        int n3 = ((String[])object6).length;
        int n4 = 0;
        while (n4 < n3) {
            object7 = object6[n4];
            if (((String)(object7 = ((String)object7).trim())).length() > 0 && ((String)object7).charAt(0) != '#') {
                arrayList.add(object7);
            }
            ++n4;
        }
        ((DataOutputStream)object3).writeInt(arrayList.size());
        for (Object object7 : arrayList) {
            ((DataOutputStream)object3).writeInt(secureRandom.nextInt());
            String[] stringArray2 = ((String)object7).split(":", 2);
            ((DataOutputStream)object3).writeUTF(stringArray2[0].trim());
            ((DataOutputStream)object3).writeUTF(stringArray2[1].trim());
        }
        ((FilterOutputStream)object3).close();
        object7 = byteArrayOutputStream.toByteArray();
        if (((Object)object7).length > Short.MAX_VALUE) {
            throw new IOException("Digital signature is too large! (" + ((Object)object7).length + ")");
        }
        ((SHA256Digest)object5).reset();
        ((GeneralDigest)object5).update(new byte[]{-86, -65, -53, -68, 47, 37, 17, -69, -87, -31, -9, -63, 100, 101, -23, 106, 80, -52, -64, -116, 19, 18, -91, -4, -118, -69, -27, -108, 118, -48, -77, -23}, 0, 32);
        ((GeneralDigest)object5).update((byte[])object7, 0, ((Object)object7).length);
        Object object8 = new byte[256];
        ((SHA256Digest)object5).doFinal((byte[])object8, 0);
        ((SHA256Digest)object5).reset();
        ((GeneralDigest)object5).update(new byte[]{95, -34, -48, -103, -85, -123, 7, 88, 111, 87, 37, 104, 98, 115, -71, -103, -50, -68, -113, 18, -9, 28, -126, 87, 56, -33, 45, -64, 108, -90, -2, 19}, 0, 32);
        ((GeneralDigest)object5).update((byte[])object7, 0, ((Object)object7).length);
        ((SHA256Digest)object5).doFinal((byte[])object8, 32);
        ((SHA256Digest)object5).reset();
        byte[] byArray3 = new byte[32];
        byArray3[0] = 101;
        byArray3[1] = -11;
        byArray3[2] = 91;
        byArray3[3] = 125;
        byArray3[4] = 50;
        byArray3[5] = 79;
        byArray3[6] = 71;
        byArray3[7] = 52;
        byArray3[8] = -12;
        byArray3[9] = -7;
        byArray3[10] = 84;
        byArray3[11] = 5;
        byArray3[12] = -117;
        byArray3[13] = 21;
        byArray3[14] = 13;
        byArray3[15] = -56;
        byArray3[16] = 75;
        byArray3[18] = 103;
        byArray3[19] = 1;
        byArray3[20] = 14;
        byArray3[21] = -97;
        byArray3[22] = -57;
        byArray3[23] = -62;
        byArray3[24] = 56;
        byArray3[25] = -95;
        byArray3[26] = 63;
        byArray3[27] = -8;
        byArray3[28] = 90;
        byArray3[29] = -122;
        byArray3[30] = 96;
        byArray3[31] = -96;
        ((GeneralDigest)object5).update(byArray3, 0, 32);
        ((GeneralDigest)object5).update((byte[])object7, 0, ((Object)object7).length);
        ((SHA256Digest)object5).doFinal((byte[])object8, 64);
        ((SHA256Digest)object5).reset();
        ((GeneralDigest)object5).update(new byte[]{84, -48, 74, 114, -5, 86, -61, -34, 90, 18, -62, -30, 20, 56, -65, -21, -69, 93, 18, 122, -95, 40, -96, 88, -105, 88, -41, -40, -3, -21, 7, 60}, 0, 32);
        ((GeneralDigest)object5).update((byte[])object7, 0, ((Object)object7).length);
        ((SHA256Digest)object5).doFinal((byte[])object8, 96);
        object8[0] = (byte)(((Object)object7).length >> 8 & 0xFF);
        object8[1] = (byte)(((Object)object7).length & 0xFF);
        System.out.println();
        System.out.print("Enter 2048 bit modulus: ");
        BigInteger bigInteger = new BigInteger(((BufferedReader)object4).readLine().trim());
        System.out.print("Enter 2048 bit secret: ");
        object6 = new BigInteger(((BufferedReader)object4).readLine().trim());
        byte[] byArray4 = new BigInteger((byte[])object8).modPow((BigInteger)object6, bigInteger).toByteArray();
        if (byArray4.length != 256) {
            throw new IOException("BigInteger was " + byArray4.length + " bytes long! should be 256, try again");
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray5 = new byte[8];
        byArray5[0] = 69;
        byArray5[1] = 65;
        byArray5[2] = 71;
        byArray5[3] = 83;
        byArray5[4] = 73;
        byArray5[5] = 71;
        byArray5[7] = 1;
        byteArrayOutputStream.write(byArray5);
        byteArrayOutputStream.write(byArray4);
        byteArrayOutputStream.write(((Object)object7).length >> 8 & 0xFF);
        byteArrayOutputStream.write(((Object)object7).length & 0xFF);
        byteArrayOutputStream.write((byte[])object7);
        byte[] byArray6 = byteArrayOutputStream.toByteArray();
        string3 = string3.replace("${client_signature}", Base64.encodeBase64String(byArray6));
        string3 = string3.replace("${client_bundle}", Base64.encodeBase64String(byArray));
        string3 = string3.replace("${date}", string5);
        System.out.println();
        System.out.println("Writing cert to: " + stringArray[stringArray.length - 1] + ".cert");
        Throwable throwable = null;
        Object var26_36 = null;
        try {
            fileOutputStream = new FileOutputStream(new File(String.valueOf(stringArray[stringArray.length - 1]) + ".cert"));
            try {
                fileOutputStream.write(byArray6);
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!new File(String.valueOf(stringArray[stringArray.length - 1]) + ".dat").isFile()) {
            System.out.println("Writing data to: " + stringArray[stringArray.length - 1] + ".dat");
            throwable = null;
            var26_36 = null;
            try {
                fileOutputStream = new FileOutputStream(new File(String.valueOf(stringArray[stringArray.length - 1]) + ".dat"));
                try {
                    fileOutputStream.write(byArray);
                }
                finally {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        System.out.println();
        System.out.println("Writing html to: " + stringArray[stringArray.length - 1]);
        System.out.println();
        throwable = null;
        var26_36 = null;
        try {
            fileOutputStream = new FileOutputStream(new File(stringArray[stringArray.length - 1]));
            try {
                fileOutputStream.write(string3.getBytes(StandardCharsets.UTF_8));
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        System.out.println("Finished.");
        System.out.println();
    }

    private static byte[] loadFile(File file) throws IOException {
        byte[] byArray = new byte[(int)file.length()];
        int n = 0;
        Throwable throwable = null;
        Object var5_5 = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int n2;
            while (n < byArray.length && (n2 = fileInputStream.read(byArray, n, byArray.length - n)) != -1) {
                n += n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return byArray;
    }

    private static byte[] makeEPK(File file, File file2) throws IOException {
        Object object;
        try {
            object = Class.forName("CompilePackage").getDeclaredMethod("main", String[].class);
            ((Method)object).invoke(null, new Object[]{new String[]{file.getAbsolutePath(), file2.getAbsolutePath()}});
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException("Failed to run EPKCompiler!", throwable);
        }
        catch (Throwable throwable) {
            throw new IOException("Failed to run EPKCompiler!", throwable);
        }
        object = MakeSignedClient.loadFile(file2);
        file2.delete();
        return object;
    }
}

