/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class GLES20 {
    public static final int GL_DEPTH_BUFFER_BIT = 256;
    public static final int GL_STENCIL_BUFFER_BIT = 1024;
    public static final int GL_COLOR_BUFFER_BIT = 16384;
    public static final int GL_FALSE = 0;
    public static final int GL_TRUE = 1;
    public static final int GL_POINTS = 0;
    public static final int GL_LINES = 1;
    public static final int GL_LINE_LOOP = 2;
    public static final int GL_LINE_STRIP = 3;
    public static final int GL_TRIANGLES = 4;
    public static final int GL_TRIANGLE_STRIP = 5;
    public static final int GL_TRIANGLE_FAN = 6;
    public static final int GL_ZERO = 0;
    public static final int GL_ONE = 1;
    public static final int GL_SRC_COLOR = 768;
    public static final int GL_ONE_MINUS_SRC_COLOR = 769;
    public static final int GL_SRC_ALPHA = 770;
    public static final int GL_ONE_MINUS_SRC_ALPHA = 771;
    public static final int GL_DST_ALPHA = 772;
    public static final int GL_ONE_MINUS_DST_ALPHA = 773;
    public static final int GL_DST_COLOR = 774;
    public static final int GL_ONE_MINUS_DST_COLOR = 775;
    public static final int GL_SRC_ALPHA_SATURATE = 776;
    public static final int GL_FUNC_ADD = 32774;
    public static final int GL_BLEND_EQUATION = 32777;
    public static final int GL_BLEND_EQUATION_RGB = 32777;
    public static final int GL_BLEND_EQUATION_ALPHA = 34877;
    public static final int GL_FUNC_SUBTRACT = 32778;
    public static final int GL_FUNC_REVERSE_SUBTRACT = 32779;
    public static final int GL_BLEND_DST_RGB = 32968;
    public static final int GL_BLEND_SRC_RGB = 32969;
    public static final int GL_BLEND_DST_ALPHA = 32970;
    public static final int GL_BLEND_SRC_ALPHA = 32971;
    public static final int GL_CONSTANT_COLOR = 32769;
    public static final int GL_ONE_MINUS_CONSTANT_COLOR = 32770;
    public static final int GL_CONSTANT_ALPHA = 32771;
    public static final int GL_ONE_MINUS_CONSTANT_ALPHA = 32772;
    public static final int GL_BLEND_COLOR = 32773;
    public static final int GL_ARRAY_BUFFER = 34962;
    public static final int GL_ELEMENT_ARRAY_BUFFER = 34963;
    public static final int GL_ARRAY_BUFFER_BINDING = 34964;
    public static final int GL_ELEMENT_ARRAY_BUFFER_BINDING = 34965;
    public static final int GL_STREAM_DRAW = 35040;
    public static final int GL_STATIC_DRAW = 35044;
    public static final int GL_DYNAMIC_DRAW = 35048;
    public static final int GL_BUFFER_SIZE = 34660;
    public static final int GL_BUFFER_USAGE = 34661;
    public static final int GL_CURRENT_VERTEX_ATTRIB = 34342;
    public static final int GL_FRONT = 1028;
    public static final int GL_BACK = 1029;
    public static final int GL_FRONT_AND_BACK = 1032;
    public static final int GL_TEXTURE_2D = 3553;
    public static final int GL_CULL_FACE = 2884;
    public static final int GL_BLEND = 3042;
    public static final int GL_DITHER = 3024;
    public static final int GL_STENCIL_TEST = 2960;
    public static final int GL_DEPTH_TEST = 2929;
    public static final int GL_SCISSOR_TEST = 3089;
    public static final int GL_POLYGON_OFFSET_FILL = 32823;
    public static final int GL_SAMPLE_ALPHA_TO_COVERAGE = 32926;
    public static final int GL_SAMPLE_COVERAGE = 32928;
    public static final int GL_NO_ERROR = 0;
    public static final int GL_INVALID_ENUM = 1280;
    public static final int GL_INVALID_VALUE = 1281;
    public static final int GL_INVALID_OPERATION = 1282;
    public static final int GL_OUT_OF_MEMORY = 1285;
    public static final int GL_CW = 2304;
    public static final int GL_CCW = 2305;
    public static final int GL_LINE_WIDTH = 2849;
    public static final int GL_ALIASED_POINT_SIZE_RANGE = 33901;
    public static final int GL_ALIASED_LINE_WIDTH_RANGE = 33902;
    public static final int GL_CULL_FACE_MODE = 2885;
    public static final int GL_FRONT_FACE = 2886;
    public static final int GL_DEPTH_RANGE = 2928;
    public static final int GL_DEPTH_WRITEMASK = 2930;
    public static final int GL_DEPTH_CLEAR_VALUE = 2931;
    public static final int GL_DEPTH_FUNC = 2932;
    public static final int GL_STENCIL_CLEAR_VALUE = 2961;
    public static final int GL_STENCIL_FUNC = 2962;
    public static final int GL_STENCIL_FAIL = 2964;
    public static final int GL_STENCIL_PASS_DEPTH_FAIL = 2965;
    public static final int GL_STENCIL_PASS_DEPTH_PASS = 2966;
    public static final int GL_STENCIL_REF = 2967;
    public static final int GL_STENCIL_VALUE_MASK = 2963;
    public static final int GL_STENCIL_WRITEMASK = 2968;
    public static final int GL_STENCIL_BACK_FUNC = 34816;
    public static final int GL_STENCIL_BACK_FAIL = 34817;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_FAIL = 34818;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_PASS = 34819;
    public static final int GL_STENCIL_BACK_REF = 36003;
    public static final int GL_STENCIL_BACK_VALUE_MASK = 36004;
    public static final int GL_STENCIL_BACK_WRITEMASK = 36005;
    public static final int GL_VIEWPORT = 2978;
    public static final int GL_SCISSOR_BOX = 3088;
    public static final int GL_COLOR_CLEAR_VALUE = 3106;
    public static final int GL_COLOR_WRITEMASK = 3107;
    public static final int GL_UNPACK_ALIGNMENT = 3317;
    public static final int GL_PACK_ALIGNMENT = 3333;
    public static final int GL_MAX_TEXTURE_SIZE = 3379;
    public static final int GL_MAX_VIEWPORT_DIMS = 3386;
    public static final int GL_SUBPIXEL_BITS = 3408;
    public static final int GL_RED_BITS = 3410;
    public static final int GL_GREEN_BITS = 3411;
    public static final int GL_BLUE_BITS = 3412;
    public static final int GL_ALPHA_BITS = 3413;
    public static final int GL_DEPTH_BITS = 3414;
    public static final int GL_STENCIL_BITS = 3415;
    public static final int GL_POLYGON_OFFSET_UNITS = 10752;
    public static final int GL_POLYGON_OFFSET_FACTOR = 32824;
    public static final int GL_TEXTURE_BINDING_2D = 32873;
    public static final int GL_SAMPLE_BUFFERS = 32936;
    public static final int GL_SAMPLES = 32937;
    public static final int GL_SAMPLE_COVERAGE_VALUE = 32938;
    public static final int GL_SAMPLE_COVERAGE_INVERT = 32939;
    public static final int GL_NUM_COMPRESSED_TEXTURE_FORMATS = 34466;
    public static final int GL_COMPRESSED_TEXTURE_FORMATS = 34467;
    public static final int GL_DONT_CARE = 4352;
    public static final int GL_FASTEST = 4353;
    public static final int GL_NICEST = 4354;
    public static final int GL_GENERATE_MIPMAP_HINT = 33170;
    public static final int GL_BYTE = 5120;
    public static final int GL_UNSIGNED_BYTE = 5121;
    public static final int GL_SHORT = 5122;
    public static final int GL_UNSIGNED_SHORT = 5123;
    public static final int GL_INT = 5124;
    public static final int GL_UNSIGNED_INT = 5125;
    public static final int GL_FLOAT = 5126;
    public static final int GL_FIXED = 5132;
    public static final int GL_DEPTH_COMPONENT = 6402;
    public static final int GL_ALPHA = 6406;
    public static final int GL_RGB = 6407;
    public static final int GL_RGBA = 6408;
    public static final int GL_LUMINANCE = 6409;
    public static final int GL_LUMINANCE_ALPHA = 6410;
    public static final int GL_UNSIGNED_SHORT_4_4_4_4 = 32819;
    public static final int GL_UNSIGNED_SHORT_5_5_5_1 = 32820;
    public static final int GL_UNSIGNED_SHORT_5_6_5 = 33635;
    public static final int GL_FRAGMENT_SHADER = 35632;
    public static final int GL_VERTEX_SHADER = 35633;
    public static final int GL_MAX_VERTEX_ATTRIBS = 34921;
    public static final int GL_MAX_VERTEX_UNIFORM_VECTORS = 36347;
    public static final int GL_MAX_VARYING_VECTORS = 36348;
    public static final int GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;
    public static final int GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 35660;
    public static final int GL_MAX_TEXTURE_IMAGE_UNITS = 34930;
    public static final int GL_MAX_FRAGMENT_UNIFORM_VECTORS = 36349;
    public static final int GL_SHADER_TYPE = 35663;
    public static final int GL_DELETE_STATUS = 35712;
    public static final int GL_LINK_STATUS = 35714;
    public static final int GL_VALIDATE_STATUS = 35715;
    public static final int GL_ATTACHED_SHADERS = 35717;
    public static final int GL_ACTIVE_UNIFORMS = 35718;
    public static final int GL_ACTIVE_UNIFORM_MAX_LENGTH = 35719;
    public static final int GL_ACTIVE_ATTRIBUTES = 35721;
    public static final int GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 35722;
    public static final int GL_SHADING_LANGUAGE_VERSION = 35724;
    public static final int GL_CURRENT_PROGRAM = 35725;
    public static final int GL_NEVER = 512;
    public static final int GL_LESS = 513;
    public static final int GL_EQUAL = 514;
    public static final int GL_LEQUAL = 515;
    public static final int GL_GREATER = 516;
    public static final int GL_NOTEQUAL = 517;
    public static final int GL_GEQUAL = 518;
    public static final int GL_ALWAYS = 519;
    public static final int GL_KEEP = 7680;
    public static final int GL_REPLACE = 7681;
    public static final int GL_INCR = 7682;
    public static final int GL_DECR = 7683;
    public static final int GL_INVERT = 5386;
    public static final int GL_INCR_WRAP = 34055;
    public static final int GL_DECR_WRAP = 34056;
    public static final int GL_VENDOR = 7936;
    public static final int GL_RENDERER = 7937;
    public static final int GL_VERSION = 7938;
    public static final int GL_EXTENSIONS = 7939;
    public static final int GL_NEAREST = 9728;
    public static final int GL_LINEAR = 9729;
    public static final int GL_NEAREST_MIPMAP_NEAREST = 9984;
    public static final int GL_LINEAR_MIPMAP_NEAREST = 9985;
    public static final int GL_NEAREST_MIPMAP_LINEAR = 9986;
    public static final int GL_LINEAR_MIPMAP_LINEAR = 9987;
    public static final int GL_TEXTURE_MAG_FILTER = 10240;
    public static final int GL_TEXTURE_MIN_FILTER = 10241;
    public static final int GL_TEXTURE_WRAP_S = 10242;
    public static final int GL_TEXTURE_WRAP_T = 10243;
    public static final int GL_TEXTURE = 5890;
    public static final int GL_TEXTURE_CUBE_MAP = 34067;
    public static final int GL_TEXTURE_BINDING_CUBE_MAP = 34068;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_X = 34069;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 34070;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 34071;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 34072;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 34073;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 34074;
    public static final int GL_MAX_CUBE_MAP_TEXTURE_SIZE = 34076;
    public static final int GL_TEXTURE0 = 33984;
    public static final int GL_TEXTURE1 = 33985;
    public static final int GL_TEXTURE2 = 33986;
    public static final int GL_TEXTURE3 = 33987;
    public static final int GL_TEXTURE4 = 33988;
    public static final int GL_TEXTURE5 = 33989;
    public static final int GL_TEXTURE6 = 33990;
    public static final int GL_TEXTURE7 = 33991;
    public static final int GL_TEXTURE8 = 33992;
    public static final int GL_TEXTURE9 = 33993;
    public static final int GL_TEXTURE10 = 33994;
    public static final int GL_TEXTURE11 = 33995;
    public static final int GL_TEXTURE12 = 33996;
    public static final int GL_TEXTURE13 = 33997;
    public static final int GL_TEXTURE14 = 33998;
    public static final int GL_TEXTURE15 = 33999;
    public static final int GL_TEXTURE16 = 34000;
    public static final int GL_TEXTURE17 = 34001;
    public static final int GL_TEXTURE18 = 34002;
    public static final int GL_TEXTURE19 = 34003;
    public static final int GL_TEXTURE20 = 34004;
    public static final int GL_TEXTURE21 = 34005;
    public static final int GL_TEXTURE22 = 34006;
    public static final int GL_TEXTURE23 = 34007;
    public static final int GL_TEXTURE24 = 34008;
    public static final int GL_TEXTURE25 = 34009;
    public static final int GL_TEXTURE26 = 34010;
    public static final int GL_TEXTURE27 = 34011;
    public static final int GL_TEXTURE28 = 34012;
    public static final int GL_TEXTURE29 = 34013;
    public static final int GL_TEXTURE30 = 34014;
    public static final int GL_TEXTURE31 = 34015;
    public static final int GL_ACTIVE_TEXTURE = 34016;
    public static final int GL_REPEAT = 10497;
    public static final int GL_CLAMP_TO_EDGE = 33071;
    public static final int GL_MIRRORED_REPEAT = 33648;
    public static final int GL_FLOAT_VEC2 = 35664;
    public static final int GL_FLOAT_VEC3 = 35665;
    public static final int GL_FLOAT_VEC4 = 35666;
    public static final int GL_INT_VEC2 = 35667;
    public static final int GL_INT_VEC3 = 35668;
    public static final int GL_INT_VEC4 = 35669;
    public static final int GL_BOOL = 35670;
    public static final int GL_BOOL_VEC2 = 35671;
    public static final int GL_BOOL_VEC3 = 35672;
    public static final int GL_BOOL_VEC4 = 35673;
    public static final int GL_FLOAT_MAT2 = 35674;
    public static final int GL_FLOAT_MAT3 = 35675;
    public static final int GL_FLOAT_MAT4 = 35676;
    public static final int GL_SAMPLER_2D = 35678;
    public static final int GL_SAMPLER_CUBE = 35680;
    public static final int GL_VERTEX_ATTRIB_ARRAY_ENABLED = 34338;
    public static final int GL_VERTEX_ATTRIB_ARRAY_SIZE = 34339;
    public static final int GL_VERTEX_ATTRIB_ARRAY_STRIDE = 34340;
    public static final int GL_VERTEX_ATTRIB_ARRAY_TYPE = 34341;
    public static final int GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 34922;
    public static final int GL_VERTEX_ATTRIB_ARRAY_POINTER = 34373;
    public static final int GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 34975;
    public static final int GL_IMPLEMENTATION_COLOR_READ_TYPE = 35738;
    public static final int GL_IMPLEMENTATION_COLOR_READ_FORMAT = 35739;
    public static final int GL_COMPILE_STATUS = 35713;
    public static final int GL_INFO_LOG_LENGTH = 35716;
    public static final int GL_SHADER_SOURCE_LENGTH = 35720;
    public static final int GL_SHADER_COMPILER = 36346;
    public static final int GL_SHADER_BINARY_FORMATS = 36344;
    public static final int GL_NUM_SHADER_BINARY_FORMATS = 36345;
    public static final int GL_LOW_FLOAT = 36336;
    public static final int GL_MEDIUM_FLOAT = 36337;
    public static final int GL_HIGH_FLOAT = 36338;
    public static final int GL_LOW_INT = 36339;
    public static final int GL_MEDIUM_INT = 36340;
    public static final int GL_HIGH_INT = 36341;
    public static final int GL_FRAMEBUFFER = 36160;
    public static final int GL_RENDERBUFFER = 36161;
    public static final int GL_RGBA4 = 32854;
    public static final int GL_RGB5_A1 = 32855;
    public static final int GL_RGB565 = 36194;
    public static final int GL_DEPTH_COMPONENT16 = 33189;
    public static final int GL_STENCIL_INDEX8 = 36168;
    public static final int GL_RENDERBUFFER_WIDTH = 36162;
    public static final int GL_RENDERBUFFER_HEIGHT = 36163;
    public static final int GL_RENDERBUFFER_INTERNAL_FORMAT = 36164;
    public static final int GL_RENDERBUFFER_RED_SIZE = 36176;
    public static final int GL_RENDERBUFFER_GREEN_SIZE = 36177;
    public static final int GL_RENDERBUFFER_BLUE_SIZE = 36178;
    public static final int GL_RENDERBUFFER_ALPHA_SIZE = 36179;
    public static final int GL_RENDERBUFFER_DEPTH_SIZE = 36180;
    public static final int GL_RENDERBUFFER_STENCIL_SIZE = 36181;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 36048;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 36049;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 36050;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 36051;
    public static final int GL_COLOR_ATTACHMENT0 = 36064;
    public static final int GL_DEPTH_ATTACHMENT = 36096;
    public static final int GL_STENCIL_ATTACHMENT = 36128;
    public static final int GL_NONE = 0;
    public static final int GL_FRAMEBUFFER_COMPLETE = 36053;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 36057;
    public static final int GL_FRAMEBUFFER_UNSUPPORTED = 36061;
    public static final int GL_FRAMEBUFFER_BINDING = 36006;
    public static final int GL_RENDERBUFFER_BINDING = 36007;
    public static final int GL_MAX_RENDERBUFFER_SIZE = 34024;
    public static final int GL_INVALID_FRAMEBUFFER_OPERATION = 1286;

    protected GLES20() {
        throw new UnsupportedOperationException();
    }

    public static native void glActiveTexture(@NativeType(value="GLenum") int var0);

    public static native void glAttachShader(@NativeType(value="GLuint") int var0, @NativeType(value="GLuint") int var1);

    public static native void nglBindAttribLocation(int var0, int var1, long var2);

    public static void glBindAttribLocation(@NativeType(value="GLuint") int program, @NativeType(value="GLuint") int index, @NativeType(value="GLchar const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        GLES20.nglBindAttribLocation(program, index, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glBindAttribLocation(@NativeType(value="GLuint") int program, @NativeType(value="GLuint") int index, @NativeType(value="GLchar const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            GLES20.nglBindAttribLocation(program, index, nameEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glBindBuffer(@NativeType(value="GLenum") int var0, @NativeType(value="GLuint") int var1);

    public static native void glBindFramebuffer(@NativeType(value="GLenum") int var0, @NativeType(value="GLuint") int var1);

    public static native void glBindRenderbuffer(@NativeType(value="GLenum") int var0, @NativeType(value="GLuint") int var1);

    public static native void glBindTexture(@NativeType(value="GLenum") int var0, @NativeType(value="GLuint") int var1);

    public static native void glBlendColor(@NativeType(value="GLfloat") float var0, @NativeType(value="GLfloat") float var1, @NativeType(value="GLfloat") float var2, @NativeType(value="GLfloat") float var3);

    public static native void glBlendEquation(@NativeType(value="GLenum") int var0);

    public static native void glBlendEquationSeparate(@NativeType(value="GLenum") int var0, @NativeType(value="GLenum") int var1);

    public static native void glBlendFunc(@NativeType(value="GLenum") int var0, @NativeType(value="GLenum") int var1);

    public static native void glBlendFuncSeparate(@NativeType(value="GLenum") int var0, @NativeType(value="GLenum") int var1, @NativeType(value="GLenum") int var2, @NativeType(value="GLenum") int var3);

    public static native void nglBufferData(int var0, long var1, long var3, int var5);

    public static void glBufferData(@NativeType(value="GLenum") int target, @NativeType(value="GLsizeiptr") long size, @NativeType(value="GLenum") int usage) {
        GLES20.nglBufferData(target, size, 0L, usage);
    }

    public static void glBufferData(@NativeType(value="GLenum") int target, @NativeType(value="void const *") ByteBuffer data, @NativeType(value="GLenum") int usage) {
        GLES20.nglBufferData(target, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data), usage);
    }

    public static void glBufferData(@NativeType(value="GLenum") int target, @NativeType(value="void const *") ShortBuffer data, @NativeType(value="GLenum") int usage) {
        GLES20.nglBufferData(target, Integer.toUnsignedLong(data.remaining()) << 1, MemoryUtil.memAddress((ShortBuffer)data), usage);
    }

    public static void glBufferData(@NativeType(value="GLenum") int target, @NativeType(value="void const *") IntBuffer data, @NativeType(value="GLenum") int usage) {
        GLES20.nglBufferData(target, Integer.toUnsignedLong(data.remaining()) << 2, MemoryUtil.memAddress((IntBuffer)data), usage);
    }

    public static void glBufferData(@NativeType(value="GLenum") int target, @NativeType(value="void const *") FloatBuffer data, @NativeType(value="GLenum") int usage) {
        GLES20.nglBufferData(target, Integer.toUnsignedLong(data.remaining()) << 2, MemoryUtil.memAddress((FloatBuffer)data), usage);
    }

    public static native void nglBufferSubData(int var0, long var1, long var3, long var5);

    public static void glBufferSubData(@NativeType(value="GLenum") int target, @NativeType(value="GLintptr") long offset, @NativeType(value="void const *") ByteBuffer data) {
        GLES20.nglBufferSubData(target, offset, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static void glBufferSubData(@NativeType(value="GLenum") int target, @NativeType(value="GLintptr") long offset, @NativeType(value="void const *") ShortBuffer data) {
        GLES20.nglBufferSubData(target, offset, Integer.toUnsignedLong(data.remaining()) << 1, MemoryUtil.memAddress((ShortBuffer)data));
    }

    public static void glBufferSubData(@NativeType(value="GLenum") int target, @NativeType(value="GLintptr") long offset, @NativeType(value="void const *") IntBuffer data) {
        GLES20.nglBufferSubData(target, offset, Integer.toUnsignedLong(data.remaining()) << 2, MemoryUtil.memAddress((IntBuffer)data));
    }

    public static void glBufferSubData(@NativeType(value="GLenum") int target, @NativeType(value="GLintptr") long offset, @NativeType(value="void const *") FloatBuffer data) {
        GLES20.nglBufferSubData(target, offset, Integer.toUnsignedLong(data.remaining()) << 2, MemoryUtil.memAddress((FloatBuffer)data));
    }

    @NativeType(value="GLenum")
    public static native int glCheckFramebufferStatus(@NativeType(value="GLenum") int var0);

    public static native void glClear(@NativeType(value="GLbitfield") int var0);

    public static native void glClearColor(@NativeType(value="GLfloat") float var0, @NativeType(value="GLfloat") float var1, @NativeType(value="GLfloat") float var2, @NativeType(value="GLfloat") float var3);

    public static native void glClearDepthf(@NativeType(value="GLfloat") float var0);

    public static native void glClearStencil(@NativeType(value="GLint") int var0);

    public static native void glColorMask(@NativeType(value="GLboolean") boolean var0, @NativeType(value="GLboolean") boolean var1, @NativeType(value="GLboolean") boolean var2, @NativeType(value="GLboolean") boolean var3);

    public static native void glCompileShader(@NativeType(value="GLuint") int var0);

    public static native void nglCompressedTexImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glCompressedTexImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLenum") int internalformat, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLint") int border, @NativeType(value="GLsizei") int imageSize, @NativeType(value="void const *") long data) {
        GLES20.nglCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data);
    }

    public static void glCompressedTexImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLenum") int internalformat, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLint") int border, @Nullable @NativeType(value="void const *") ByteBuffer data) {
        GLES20.nglCompressedTexImage2D(target, level, internalformat, width, height, border, Checks.remainingSafe((Buffer)data), MemoryUtil.memAddressSafe((ByteBuffer)data));
    }

    public static native void nglCompressedTexSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glCompressedTexSubImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLint") int xoffset, @NativeType(value="GLint") int yoffset, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLenum") int format, @NativeType(value="GLsizei") int imageSize, @NativeType(value="void const *") long data) {
        GLES20.nglCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }

    public static void glCompressedTexSubImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLint") int xoffset, @NativeType(value="GLint") int yoffset, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLenum") int format, @NativeType(value="void const *") ByteBuffer data) {
        GLES20.nglCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static native void glCopyTexImage2D(@NativeType(value="GLenum") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLenum") int var2, @NativeType(value="GLint") int var3, @NativeType(value="GLint") int var4, @NativeType(value="GLsizei") int var5, @NativeType(value="GLsizei") int var6, @NativeType(value="GLint") int var7);

    public static native void glCopyTexSubImage2D(@NativeType(value="GLenum") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLint") int var2, @NativeType(value="GLint") int var3, @NativeType(value="GLint") int var4, @NativeType(value="GLint") int var5, @NativeType(value="GLsizei") int var6, @NativeType(value="GLsizei") int var7);

    @NativeType(value="GLuint")
    public static native int glCreateProgram();

    @NativeType(value="GLuint")
    public static native int glCreateShader(@NativeType(value="GLenum") int var0);

    public static native void glCullFace(@NativeType(value="GLenum") int var0);

    public static native void nglDeleteBuffers(int var0, long var1);

    public static void glDeleteBuffers(@NativeType(value="GLuint const *") IntBuffer buffers) {
        GLES20.nglDeleteBuffers(buffers.remaining(), MemoryUtil.memAddress((IntBuffer)buffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteBuffers(@NativeType(value="GLuint const *") int buffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer buffers = stack.ints(buffer);
            GLES20.nglDeleteBuffers(1, MemoryUtil.memAddress((IntBuffer)buffers));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDeleteFramebuffers(int var0, long var1);

    public static void glDeleteFramebuffers(@NativeType(value="GLuint const *") IntBuffer framebuffers) {
        GLES20.nglDeleteFramebuffers(framebuffers.remaining(), MemoryUtil.memAddress((IntBuffer)framebuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteFramebuffers(@NativeType(value="GLuint const *") int framebuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer framebuffers = stack.ints(framebuffer);
            GLES20.nglDeleteFramebuffers(1, MemoryUtil.memAddress((IntBuffer)framebuffers));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glDeleteProgram(@NativeType(value="GLuint") int var0);

    public static native void nglDeleteRenderbuffers(int var0, long var1);

    public static void glDeleteRenderbuffers(@NativeType(value="GLuint const *") IntBuffer renderbuffers) {
        GLES20.nglDeleteRenderbuffers(renderbuffers.remaining(), MemoryUtil.memAddress((IntBuffer)renderbuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteRenderbuffers(@NativeType(value="GLuint const *") int renderbuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer renderbuffers = stack.ints(renderbuffer);
            GLES20.nglDeleteRenderbuffers(1, MemoryUtil.memAddress((IntBuffer)renderbuffers));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glDeleteShader(@NativeType(value="GLuint") int var0);

    public static native void nglDeleteTextures(int var0, long var1);

    public static void glDeleteTextures(@NativeType(value="GLuint const *") IntBuffer textures) {
        GLES20.nglDeleteTextures(textures.remaining(), MemoryUtil.memAddress((IntBuffer)textures));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteTextures(@NativeType(value="GLuint const *") int texture) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer textures = stack.ints(texture);
            GLES20.nglDeleteTextures(1, MemoryUtil.memAddress((IntBuffer)textures));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glDepthFunc(@NativeType(value="GLenum") int var0);

    public static native void glDepthMask(@NativeType(value="GLboolean") boolean var0);

    public static native void glDepthRangef(@NativeType(value="GLfloat") float var0, @NativeType(value="GLfloat") float var1);

    public static native void glDetachShader(@NativeType(value="GLuint") int var0, @NativeType(value="GLuint") int var1);

    public static native void glDisable(@NativeType(value="GLenum") int var0);

    public static native void glDisableVertexAttribArray(@NativeType(value="GLuint") int var0);

    public static native void glDrawArrays(@NativeType(value="GLenum") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLsizei") int var2);

    public static native void nglDrawElements(int var0, int var1, int var2, long var3);

    public static void glDrawElements(@NativeType(value="GLenum") int mode, @NativeType(value="GLsizei") int count, @NativeType(value="GLenum") int type, @NativeType(value="void const *") long indices) {
        GLES20.nglDrawElements(mode, count, type, indices);
    }

    public static void glDrawElements(@NativeType(value="GLenum") int mode, @NativeType(value="GLenum") int type, @NativeType(value="void const *") ByteBuffer indices) {
        GLES20.nglDrawElements(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress((ByteBuffer)indices));
    }

    public static void glDrawElements(@NativeType(value="GLenum") int mode, @NativeType(value="void const *") ByteBuffer indices) {
        GLES20.nglDrawElements(mode, indices.remaining(), 5121, MemoryUtil.memAddress((ByteBuffer)indices));
    }

    public static void glDrawElements(@NativeType(value="GLenum") int mode, @NativeType(value="void const *") ShortBuffer indices) {
        GLES20.nglDrawElements(mode, indices.remaining(), 5123, MemoryUtil.memAddress((ShortBuffer)indices));
    }

    public static void glDrawElements(@NativeType(value="GLenum") int mode, @NativeType(value="void const *") IntBuffer indices) {
        GLES20.nglDrawElements(mode, indices.remaining(), 5125, MemoryUtil.memAddress((IntBuffer)indices));
    }

    public static native void glEnable(@NativeType(value="GLenum") int var0);

    public static native void glEnableVertexAttribArray(@NativeType(value="GLuint") int var0);

    public static native void glFinish();

    public static native void glFlush();

    public static native void glFramebufferRenderbuffer(@NativeType(value="GLenum") int var0, @NativeType(value="GLenum") int var1, @NativeType(value="GLenum") int var2, @NativeType(value="GLuint") int var3);

    public static native void glFramebufferTexture2D(@NativeType(value="GLenum") int var0, @NativeType(value="GLenum") int var1, @NativeType(value="GLenum") int var2, @NativeType(value="GLuint") int var3, @NativeType(value="GLint") int var4);

    public static native void glFrontFace(@NativeType(value="GLenum") int var0);

    public static native void nglGenBuffers(int var0, long var1);

    public static void glGenBuffers(@NativeType(value="GLuint *") IntBuffer buffers) {
        GLES20.nglGenBuffers(buffers.remaining(), MemoryUtil.memAddress((IntBuffer)buffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGenBuffers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer buffers = stack.callocInt(1);
            GLES20.nglGenBuffers(1, MemoryUtil.memAddress((IntBuffer)buffers));
            int n = buffers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glGenerateMipmap(@NativeType(value="GLenum") int var0);

    public static native void nglGenFramebuffers(int var0, long var1);

    public static void glGenFramebuffers(@NativeType(value="GLuint *") IntBuffer framebuffers) {
        GLES20.nglGenFramebuffers(framebuffers.remaining(), MemoryUtil.memAddress((IntBuffer)framebuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGenFramebuffers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer framebuffers = stack.callocInt(1);
            GLES20.nglGenFramebuffers(1, MemoryUtil.memAddress((IntBuffer)framebuffers));
            int n = framebuffers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGenRenderbuffers(int var0, long var1);

    public static void glGenRenderbuffers(@NativeType(value="GLuint *") IntBuffer renderbuffers) {
        GLES20.nglGenRenderbuffers(renderbuffers.remaining(), MemoryUtil.memAddress((IntBuffer)renderbuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGenRenderbuffers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer renderbuffers = stack.callocInt(1);
            GLES20.nglGenRenderbuffers(1, MemoryUtil.memAddress((IntBuffer)renderbuffers));
            int n = renderbuffers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGenTextures(int var0, long var1);

    public static void glGenTextures(@NativeType(value="GLuint *") IntBuffer textures) {
        GLES20.nglGenTextures(textures.remaining(), MemoryUtil.memAddress((IntBuffer)textures));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGenTextures() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer textures = stack.callocInt(1);
            GLES20.nglGenTextures(1, MemoryUtil.memAddress((IntBuffer)textures));
            int n = textures.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetActiveAttrib(int var0, int var1, int var2, long var3, long var5, long var7, long var9);

    public static void glGetActiveAttrib(@NativeType(value="GLuint") int program, @NativeType(value="GLuint") int index, @Nullable @NativeType(value="GLsizei *") IntBuffer length, @NativeType(value="GLint *") IntBuffer size, @NativeType(value="GLenum *") IntBuffer type, @NativeType(value="GLchar *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
            Checks.check((Buffer)size, (int)1);
            Checks.check((Buffer)type, (int)1);
        }
        GLES20.nglGetActiveAttrib(program, index, name.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)size), MemoryUtil.memAddress((IntBuffer)type), MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static String glGetActiveAttrib(@NativeType(value="GLuint") int program, @NativeType(value="GLuint") int index, @NativeType(value="GLsizei") int bufSize, @NativeType(value="GLint *") IntBuffer size, @NativeType(value="GLenum *") IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)size, (int)1);
            Checks.check((Buffer)type, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufSize);
            GLES20.nglGetActiveAttrib(program, index, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)size), MemoryUtil.memAddress((IntBuffer)type), MemoryUtil.memAddress((ByteBuffer)name));
            String string = MemoryUtil.memASCII((ByteBuffer)name, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="void")
    public static String glGetActiveAttrib(@NativeType(value="GLuint") int program, @NativeType(value="GLuint") int index, @NativeType(value="GLint *") IntBuffer size, @NativeType(value="GLenum *") IntBuffer type) {
        return GLES20.glGetActiveAttrib(program, index, GLES20.glGetProgrami(program, 35722), size, type);
    }

    public static native void nglGetActiveUniform(int var0, int var1, int var2, long var3, long var5, long var7, long var9);

    public static void glGetActiveUniform(@NativeType(value="GLuint") int program, @NativeType(value="GLuint") int index, @Nullable @NativeType(value="GLsizei *") IntBuffer length, @NativeType(value="GLint *") IntBuffer size, @NativeType(value="GLenum *") IntBuffer type, @NativeType(value="GLchar *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
            Checks.check((Buffer)size, (int)1);
            Checks.check((Buffer)type, (int)1);
        }
        GLES20.nglGetActiveUniform(program, index, name.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)size), MemoryUtil.memAddress((IntBuffer)type), MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static String glGetActiveUniform(@NativeType(value="GLuint") int program, @NativeType(value="GLuint") int index, @NativeType(value="GLsizei") int bufSize, @NativeType(value="GLint *") IntBuffer size, @NativeType(value="GLenum *") IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)size, (int)1);
            Checks.check((Buffer)type, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufSize);
            GLES20.nglGetActiveUniform(program, index, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)size), MemoryUtil.memAddress((IntBuffer)type), MemoryUtil.memAddress((ByteBuffer)name));
            String string = MemoryUtil.memASCII((ByteBuffer)name, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="void")
    public static String glGetActiveUniform(@NativeType(value="GLuint") int program, @NativeType(value="GLuint") int index, @NativeType(value="GLint *") IntBuffer size, @NativeType(value="GLenum *") IntBuffer type) {
        return GLES20.glGetActiveUniform(program, index, GLES20.glGetProgrami(program, 35719), size, type);
    }

    public static native void nglGetAttachedShaders(int var0, int var1, long var2, long var4);

    public static void glGetAttachedShaders(@NativeType(value="GLuint") int program, @Nullable @NativeType(value="GLsizei *") IntBuffer count, @NativeType(value="GLuint *") IntBuffer shaders) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)count, (int)1);
        }
        GLES20.nglGetAttachedShaders(program, shaders.remaining(), MemoryUtil.memAddressSafe((IntBuffer)count), MemoryUtil.memAddress((IntBuffer)shaders));
    }

    public static native int nglGetAttribLocation(int var0, long var1);

    @NativeType(value="GLint")
    public static int glGetAttribLocation(@NativeType(value="GLuint") int program, @NativeType(value="GLchar const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return GLES20.nglGetAttribLocation(program, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="GLint")
    public static int glGetAttribLocation(@NativeType(value="GLuint") int program, @NativeType(value="GLchar const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = GLES20.nglGetAttribLocation(program, nameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetBooleanv(int var0, long var1);

    public static void glGetBooleanv(@NativeType(value="GLenum") int pname, @NativeType(value="GLboolean *") ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, (int)1);
        }
        GLES20.nglGetBooleanv(pname, MemoryUtil.memAddress((ByteBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static boolean glGetBoolean(@NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer data = stack.calloc(1);
            GLES20.nglGetBooleanv(pname, MemoryUtil.memAddress((ByteBuffer)data));
            boolean bl = data.get(0) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetBufferParameteriv(int var0, int var1, long var2);

    public static void glGetBufferParameteriv(@NativeType(value="GLenum") int target, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglGetBufferParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetBufferParameteri(@NativeType(value="GLenum") int target, @NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetBufferParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="GLenum")
    public static native int glGetError();

    public static native void nglGetFloatv(int var0, long var1);

    public static void glGetFloatv(@NativeType(value="GLenum") int pname, @NativeType(value="GLfloat *") FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, (int)1);
        }
        GLES20.nglGetFloatv(pname, MemoryUtil.memAddress((FloatBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static float glGetFloat(@NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer data = stack.callocFloat(1);
            GLES20.nglGetFloatv(pname, MemoryUtil.memAddress((FloatBuffer)data));
            float f = data.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetFramebufferAttachmentParameteriv(int var0, int var1, int var2, long var3);

    public static void glGetFramebufferAttachmentParameteriv(@NativeType(value="GLenum") int target, @NativeType(value="GLenum") int attachment, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglGetFramebufferAttachmentParameteriv(target, attachment, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetFramebufferAttachmentParameteri(@NativeType(value="GLenum") int target, @NativeType(value="GLenum") int attachment, @NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetFramebufferAttachmentParameteriv(target, attachment, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetIntegerv(int var0, long var1);

    public static void glGetIntegerv(@NativeType(value="GLenum") int pname, @NativeType(value="GLint *") IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, (int)1);
        }
        GLES20.nglGetIntegerv(pname, MemoryUtil.memAddress((IntBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetInteger(@NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer data = stack.callocInt(1);
            GLES20.nglGetIntegerv(pname, MemoryUtil.memAddress((IntBuffer)data));
            int n = data.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetProgramiv(int var0, int var1, long var2);

    public static void glGetProgramiv(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglGetProgramiv(program, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetProgrami(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetProgramiv(program, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetProgramInfoLog(int var0, int var1, long var2, long var4);

    public static void glGetProgramInfoLog(@NativeType(value="GLuint") int program, @Nullable @NativeType(value="GLsizei *") IntBuffer length, @NativeType(value="GLchar *") ByteBuffer infoLog) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
        }
        GLES20.nglGetProgramInfoLog(program, infoLog.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)infoLog));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static String glGetProgramInfoLog(@NativeType(value="GLuint") int program, @NativeType(value="GLsizei") int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc((int)bufSize);
        try {
            IntBuffer length = stack.ints(0);
            GLES20.nglGetProgramInfoLog(program, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)infoLog));
            String string = MemoryUtil.memUTF8((ByteBuffer)infoLog, (int)length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree((Buffer)infoLog);
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="void")
    public static String glGetProgramInfoLog(@NativeType(value="GLuint") int program) {
        return GLES20.glGetProgramInfoLog(program, GLES20.glGetProgrami(program, 35716));
    }

    public static native void nglGetRenderbufferParameteriv(int var0, int var1, long var2);

    public static void glGetRenderbufferParameteriv(@NativeType(value="GLenum") int target, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglGetRenderbufferParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetRenderbufferParameteri(@NativeType(value="GLenum") int target, @NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetRenderbufferParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetShaderiv(int var0, int var1, long var2);

    public static void glGetShaderiv(@NativeType(value="GLuint") int shader, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglGetShaderiv(shader, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetShaderi(@NativeType(value="GLuint") int shader, @NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetShaderiv(shader, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetShaderInfoLog(int var0, int var1, long var2, long var4);

    public static void glGetShaderInfoLog(@NativeType(value="GLuint") int shader, @Nullable @NativeType(value="GLsizei *") IntBuffer length, @NativeType(value="GLchar *") ByteBuffer infoLog) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
        }
        GLES20.nglGetShaderInfoLog(shader, infoLog.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)infoLog));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static String glGetShaderInfoLog(@NativeType(value="GLuint") int shader, @NativeType(value="GLsizei") int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc((int)bufSize);
        try {
            IntBuffer length = stack.ints(0);
            GLES20.nglGetShaderInfoLog(shader, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)infoLog));
            String string = MemoryUtil.memUTF8((ByteBuffer)infoLog, (int)length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree((Buffer)infoLog);
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="void")
    public static String glGetShaderInfoLog(@NativeType(value="GLuint") int shader) {
        return GLES20.glGetShaderInfoLog(shader, GLES20.glGetShaderi(shader, 35716));
    }

    public static native void nglGetShaderPrecisionFormat(int var0, int var1, long var2, long var4);

    public static void glGetShaderPrecisionFormat(@NativeType(value="GLenum") int shadertype, @NativeType(value="GLenum") int precisiontype, @NativeType(value="GLint *") IntBuffer range, @NativeType(value="GLint *") IntBuffer precision) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)range, (int)2);
            Checks.check((Buffer)precision, (int)2);
        }
        GLES20.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress((IntBuffer)range), MemoryUtil.memAddress((IntBuffer)precision));
    }

    public static native void nglGetShaderSource(int var0, int var1, long var2, long var4);

    public static void glGetShaderSource(@NativeType(value="GLuint") int shader, @Nullable @NativeType(value="GLsizei *") IntBuffer length, @NativeType(value="GLchar *") ByteBuffer source) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
        }
        GLES20.nglGetShaderSource(shader, source.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static String glGetShaderSource(@NativeType(value="GLuint") int shader, @NativeType(value="GLsizei") int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer source = MemoryUtil.memAlloc((int)bufSize);
        try {
            IntBuffer length = stack.ints(0);
            GLES20.nglGetShaderSource(shader, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)source));
            String string = MemoryUtil.memUTF8((ByteBuffer)source, (int)length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree((Buffer)source);
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="void")
    public static String glGetShaderSource(@NativeType(value="GLuint") int shader) {
        return GLES20.glGetShaderSource(shader, GLES20.glGetShaderi(shader, 35720));
    }

    public static native long nglGetString(int var0);

    @Nullable
    @NativeType(value="GLubyte const *")
    public static String glGetString(@NativeType(value="GLenum") int name) {
        long __result = GLES20.nglGetString(name);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static native void nglGetTexParameterfv(int var0, int var1, long var2);

    public static void glGetTexParameterfv(@NativeType(value="GLenum") int target, @NativeType(value="GLenum") int pname, @NativeType(value="GLfloat *") FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglGetTexParameterfv(target, pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static float glGetTexParameterf(@NativeType(value="GLenum") int target, @NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GLES20.nglGetTexParameterfv(target, pname, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetTexParameteriv(int var0, int var1, long var2);

    public static void glGetTexParameteriv(@NativeType(value="GLenum") int target, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglGetTexParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetTexParameteri(@NativeType(value="GLenum") int target, @NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetTexParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetUniformfv(int var0, int var1, long var2);

    public static void glGetUniformfv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLfloat *") FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglGetUniformfv(program, location, MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static float glGetUniformf(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GLES20.nglGetUniformfv(program, location, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetUniformiv(int var0, int var1, long var2);

    public static void glGetUniformiv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLint *") IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglGetUniformiv(program, location, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetUniformi(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetUniformiv(program, location, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nglGetUniformLocation(int var0, long var1);

    @NativeType(value="GLint")
    public static int glGetUniformLocation(@NativeType(value="GLuint") int program, @NativeType(value="GLchar const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return GLES20.nglGetUniformLocation(program, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="GLint")
    public static int glGetUniformLocation(@NativeType(value="GLuint") int program, @NativeType(value="GLchar const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = GLES20.nglGetUniformLocation(program, nameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetVertexAttribfv(int var0, int var1, long var2);

    public static void glGetVertexAttribfv(@NativeType(value="GLuint") int index, @NativeType(value="GLenum") int pname, @NativeType(value="GLfloat *") FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)4);
        }
        GLES20.nglGetVertexAttribfv(index, pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    public static native void nglGetVertexAttribiv(int var0, int var1, long var2);

    public static void glGetVertexAttribiv(@NativeType(value="GLuint") int index, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)4);
        }
        GLES20.nglGetVertexAttribiv(index, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    public static native void nglGetVertexAttribPointerv(int var0, int var1, long var2);

    public static void glGetVertexAttribPointerv(@NativeType(value="GLuint") int index, @NativeType(value="GLenum") int pname, @NativeType(value="void **") PointerBuffer pointer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointer, (int)1);
        }
        GLES20.nglGetVertexAttribPointerv(index, pname, MemoryUtil.memAddress((CustomBuffer)pointer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static long glGetVertexAttribPointer(@NativeType(value="GLuint") int index, @NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer pointer = stack.callocPointer(1);
            GLES20.nglGetVertexAttribPointerv(index, pname, MemoryUtil.memAddress((CustomBuffer)pointer));
            long l = pointer.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glHint(@NativeType(value="GLenum") int var0, @NativeType(value="GLenum") int var1);

    @NativeType(value="GLboolean")
    public static native boolean glIsBuffer(@NativeType(value="GLuint") int var0);

    @NativeType(value="GLboolean")
    public static native boolean glIsEnabled(@NativeType(value="GLenum") int var0);

    @NativeType(value="GLboolean")
    public static native boolean glIsFramebuffer(@NativeType(value="GLuint") int var0);

    @NativeType(value="GLboolean")
    public static native boolean glIsProgram(@NativeType(value="GLuint") int var0);

    @NativeType(value="GLboolean")
    public static native boolean glIsRenderbuffer(@NativeType(value="GLuint") int var0);

    @NativeType(value="GLboolean")
    public static native boolean glIsShader(@NativeType(value="GLuint") int var0);

    @NativeType(value="GLboolean")
    public static native boolean glIsTexture(@NativeType(value="GLuint") int var0);

    public static native void glLineWidth(@NativeType(value="GLfloat") float var0);

    public static native void glLinkProgram(@NativeType(value="GLuint") int var0);

    public static native void glPixelStorei(@NativeType(value="GLenum") int var0, @NativeType(value="GLint") int var1);

    public static native void glPolygonOffset(@NativeType(value="GLfloat") float var0, @NativeType(value="GLfloat") float var1);

    public static native void nglReadPixels(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glReadPixels(@NativeType(value="GLint") int x, @NativeType(value="GLint") int y, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @NativeType(value="void *") ByteBuffer pixels) {
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress((ByteBuffer)pixels));
    }

    public static void glReadPixels(@NativeType(value="GLint") int x, @NativeType(value="GLint") int y, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @NativeType(value="void *") long pixels) {
        GLES20.nglReadPixels(x, y, width, height, format, type, pixels);
    }

    public static void glReadPixels(@NativeType(value="GLint") int x, @NativeType(value="GLint") int y, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @NativeType(value="void *") ShortBuffer pixels) {
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress((ShortBuffer)pixels));
    }

    public static void glReadPixels(@NativeType(value="GLint") int x, @NativeType(value="GLint") int y, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @NativeType(value="void *") IntBuffer pixels) {
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress((IntBuffer)pixels));
    }

    public static void glReadPixels(@NativeType(value="GLint") int x, @NativeType(value="GLint") int y, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @NativeType(value="void *") FloatBuffer pixels) {
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress((FloatBuffer)pixels));
    }

    public static native void glReleaseShaderCompiler();

    public static native void glRenderbufferStorage(@NativeType(value="GLenum") int var0, @NativeType(value="GLenum") int var1, @NativeType(value="GLsizei") int var2, @NativeType(value="GLsizei") int var3);

    public static native void glSampleCoverage(@NativeType(value="GLfloat") float var0, @NativeType(value="GLboolean") boolean var1);

    public static native void glScissor(@NativeType(value="GLint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLsizei") int var2, @NativeType(value="GLsizei") int var3);

    public static native void nglShaderBinary(int var0, long var1, int var3, long var4, int var6);

    public static void glShaderBinary(@NativeType(value="GLuint const *") IntBuffer shaders, @NativeType(value="GLenum") int binaryformat, @NativeType(value="void const *") ByteBuffer binary) {
        GLES20.nglShaderBinary(shaders.remaining(), MemoryUtil.memAddress((IntBuffer)shaders), binaryformat, MemoryUtil.memAddress((ByteBuffer)binary), binary.remaining());
    }

    public static native void nglShaderSource(int var0, int var1, long var2, long var4);

    public static void glShaderSource(@NativeType(value="GLuint") int shader, @NativeType(value="GLchar const * const *") PointerBuffer string, @Nullable @NativeType(value="GLint const *") IntBuffer length) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)string.remaining());
        }
        GLES20.nglShaderSource(shader, string.remaining(), MemoryUtil.memAddress((CustomBuffer)string), MemoryUtil.memAddressSafe((IntBuffer)length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSource(@NativeType(value="GLuint") int shader, CharSequence ... string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringAddress = APIUtil.apiArrayi((MemoryStack)stack, MemoryUtil::memUTF8, (CharSequence[])string);
            GLES20.nglShaderSource(shader, string.length, stringAddress, stringAddress - (long)(string.length << 2));
            APIUtil.apiArrayFree((long)stringAddress, (int)string.length);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSource(@NativeType(value="GLuint") int shader, @NativeType(value="GLchar const * const *") CharSequence string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringAddress = APIUtil.apiArrayi((MemoryStack)stack, MemoryUtil::memUTF8, (CharSequence[])new CharSequence[]{string});
            GLES20.nglShaderSource(shader, 1, stringAddress, stringAddress - 4L);
            APIUtil.apiArrayFree((long)stringAddress, (int)1);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glStencilFunc(@NativeType(value="GLenum") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLuint") int var2);

    public static native void glStencilFuncSeparate(@NativeType(value="GLenum") int var0, @NativeType(value="GLenum") int var1, @NativeType(value="GLint") int var2, @NativeType(value="GLuint") int var3);

    public static native void glStencilMask(@NativeType(value="GLuint") int var0);

    public static native void glStencilMaskSeparate(@NativeType(value="GLenum") int var0, @NativeType(value="GLuint") int var1);

    public static native void glStencilOp(@NativeType(value="GLenum") int var0, @NativeType(value="GLenum") int var1, @NativeType(value="GLenum") int var2);

    public static native void glStencilOpSeparate(@NativeType(value="GLenum") int var0, @NativeType(value="GLenum") int var1, @NativeType(value="GLenum") int var2, @NativeType(value="GLenum") int var3);

    public static native void nglTexImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glTexImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLint") int internalformat, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLint") int border, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @Nullable @NativeType(value="void const *") ByteBuffer pixels) {
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe((ByteBuffer)pixels));
    }

    public static void glTexImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLint") int internalformat, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLint") int border, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @NativeType(value="void const *") long pixels) {
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glTexImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLint") int internalformat, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLint") int border, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @Nullable @NativeType(value="void const *") ShortBuffer pixels) {
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe((ShortBuffer)pixels));
    }

    public static void glTexImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLint") int internalformat, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLint") int border, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @Nullable @NativeType(value="void const *") IntBuffer pixels) {
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe((IntBuffer)pixels));
    }

    public static void glTexImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLint") int internalformat, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLint") int border, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @Nullable @NativeType(value="void const *") FloatBuffer pixels) {
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe((FloatBuffer)pixels));
    }

    public static native void glTexParameterf(@NativeType(value="GLenum") int var0, @NativeType(value="GLenum") int var1, @NativeType(value="GLfloat") float var2);

    public static native void nglTexParameterfv(int var0, int var1, long var2);

    public static void glTexParameterfv(@NativeType(value="GLenum") int target, @NativeType(value="GLenum") int pname, @NativeType(value="GLfloat const *") FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglTexParameterfv(target, pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    public static native void glTexParameteri(@NativeType(value="GLenum") int var0, @NativeType(value="GLenum") int var1, @NativeType(value="GLint") int var2);

    public static native void nglTexParameteriv(int var0, int var1, long var2);

    public static void glTexParameteriv(@NativeType(value="GLenum") int target, @NativeType(value="GLenum") int pname, @NativeType(value="GLint const *") IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GLES20.nglTexParameteriv(target, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    public static native void nglTexSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glTexSubImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLint") int xoffset, @NativeType(value="GLint") int yoffset, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @NativeType(value="void const *") ByteBuffer pixels) {
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress((ByteBuffer)pixels));
    }

    public static void glTexSubImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLint") int xoffset, @NativeType(value="GLint") int yoffset, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @NativeType(value="void const *") long pixels) {
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glTexSubImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLint") int xoffset, @NativeType(value="GLint") int yoffset, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @NativeType(value="void const *") ShortBuffer pixels) {
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress((ShortBuffer)pixels));
    }

    public static void glTexSubImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLint") int xoffset, @NativeType(value="GLint") int yoffset, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @NativeType(value="void const *") IntBuffer pixels) {
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress((IntBuffer)pixels));
    }

    public static void glTexSubImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLint") int xoffset, @NativeType(value="GLint") int yoffset, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @NativeType(value="void const *") FloatBuffer pixels) {
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress((FloatBuffer)pixels));
    }

    public static native void glUniform1f(@NativeType(value="GLint") int var0, @NativeType(value="GLfloat") float var1);

    public static native void nglUniform1fv(int var0, int var1, long var2);

    public static void glUniform1fv(@NativeType(value="GLint") int location, @NativeType(value="GLfloat const *") FloatBuffer value) {
        GLES20.nglUniform1fv(location, value.remaining(), MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void glUniform1i(@NativeType(value="GLint") int var0, @NativeType(value="GLint") int var1);

    public static native void nglUniform1iv(int var0, int var1, long var2);

    public static void glUniform1iv(@NativeType(value="GLint") int location, @NativeType(value="GLint const *") IntBuffer value) {
        GLES20.nglUniform1iv(location, value.remaining(), MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void glUniform2f(@NativeType(value="GLint") int var0, @NativeType(value="GLfloat") float var1, @NativeType(value="GLfloat") float var2);

    public static native void nglUniform2fv(int var0, int var1, long var2);

    public static void glUniform2fv(@NativeType(value="GLint") int location, @NativeType(value="GLfloat const *") FloatBuffer value) {
        GLES20.nglUniform2fv(location, value.remaining() >> 1, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void glUniform2i(@NativeType(value="GLint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLint") int var2);

    public static native void nglUniform2iv(int var0, int var1, long var2);

    public static void glUniform2iv(@NativeType(value="GLint") int location, @NativeType(value="GLint const *") IntBuffer value) {
        GLES20.nglUniform2iv(location, value.remaining() >> 1, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void glUniform3f(@NativeType(value="GLint") int var0, @NativeType(value="GLfloat") float var1, @NativeType(value="GLfloat") float var2, @NativeType(value="GLfloat") float var3);

    public static native void nglUniform3fv(int var0, int var1, long var2);

    public static void glUniform3fv(@NativeType(value="GLint") int location, @NativeType(value="GLfloat const *") FloatBuffer value) {
        GLES20.nglUniform3fv(location, value.remaining() / 3, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void glUniform3i(@NativeType(value="GLint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLint") int var2, @NativeType(value="GLint") int var3);

    public static native void nglUniform3iv(int var0, int var1, long var2);

    public static void glUniform3iv(@NativeType(value="GLint") int location, @NativeType(value="GLint const *") IntBuffer value) {
        GLES20.nglUniform3iv(location, value.remaining() / 3, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void glUniform4f(@NativeType(value="GLint") int var0, @NativeType(value="GLfloat") float var1, @NativeType(value="GLfloat") float var2, @NativeType(value="GLfloat") float var3, @NativeType(value="GLfloat") float var4);

    public static native void nglUniform4fv(int var0, int var1, long var2);

    public static void glUniform4fv(@NativeType(value="GLint") int location, @NativeType(value="GLfloat const *") FloatBuffer value) {
        GLES20.nglUniform4fv(location, value.remaining() >> 2, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void glUniform4i(@NativeType(value="GLint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLint") int var2, @NativeType(value="GLint") int var3, @NativeType(value="GLint") int var4);

    public static native void nglUniform4iv(int var0, int var1, long var2);

    public static void glUniform4iv(@NativeType(value="GLint") int location, @NativeType(value="GLint const *") IntBuffer value) {
        GLES20.nglUniform4iv(location, value.remaining() >> 2, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void nglUniformMatrix2fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix2fv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="GLfloat const *") FloatBuffer value) {
        GLES20.nglUniformMatrix2fv(location, value.remaining() >> 2, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglUniformMatrix3fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix3fv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="GLfloat const *") FloatBuffer value) {
        GLES20.nglUniformMatrix3fv(location, value.remaining() / 9, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglUniformMatrix4fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix4fv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="GLfloat const *") FloatBuffer value) {
        GLES20.nglUniformMatrix4fv(location, value.remaining() >> 4, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void glUseProgram(@NativeType(value="GLuint") int var0);

    public static native void glValidateProgram(@NativeType(value="GLuint") int var0);

    public static native void glVertexAttrib1f(@NativeType(value="GLuint") int var0, @NativeType(value="GLfloat") float var1);

    public static native void nglVertexAttrib1fv(int var0, long var1);

    public static void glVertexAttrib1fv(@NativeType(value="GLuint") int index, @NativeType(value="GLfloat const *") FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, (int)1);
        }
        GLES20.nglVertexAttrib1fv(index, MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static native void glVertexAttrib2f(@NativeType(value="GLuint") int var0, @NativeType(value="GLfloat") float var1, @NativeType(value="GLfloat") float var2);

    public static native void nglVertexAttrib2fv(int var0, long var1);

    public static void glVertexAttrib2fv(@NativeType(value="GLuint") int index, @NativeType(value="GLfloat const *") FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, (int)2);
        }
        GLES20.nglVertexAttrib2fv(index, MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static native void glVertexAttrib3f(@NativeType(value="GLuint") int var0, @NativeType(value="GLfloat") float var1, @NativeType(value="GLfloat") float var2, @NativeType(value="GLfloat") float var3);

    public static native void nglVertexAttrib3fv(int var0, long var1);

    public static void glVertexAttrib3fv(@NativeType(value="GLuint") int index, @NativeType(value="GLfloat const *") FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, (int)3);
        }
        GLES20.nglVertexAttrib3fv(index, MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static native void glVertexAttrib4f(@NativeType(value="GLuint") int var0, @NativeType(value="GLfloat") float var1, @NativeType(value="GLfloat") float var2, @NativeType(value="GLfloat") float var3, @NativeType(value="GLfloat") float var4);

    public static native void nglVertexAttrib4fv(int var0, long var1);

    public static void glVertexAttrib4fv(@NativeType(value="GLuint") int index, @NativeType(value="GLfloat const *") FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, (int)4);
        }
        GLES20.nglVertexAttrib4fv(index, MemoryUtil.memAddress((FloatBuffer)v));
    }

    public static native void nglVertexAttribPointer(int var0, int var1, int var2, boolean var3, int var4, long var5);

    public static void glVertexAttribPointer(@NativeType(value="GLuint") int index, @NativeType(value="GLint") int size, @NativeType(value="GLenum") int type, @NativeType(value="GLboolean") boolean normalized, @NativeType(value="GLsizei") int stride, @NativeType(value="void const *") ByteBuffer pointer) {
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress((ByteBuffer)pointer));
    }

    public static void glVertexAttribPointer(@NativeType(value="GLuint") int index, @NativeType(value="GLint") int size, @NativeType(value="GLenum") int type, @NativeType(value="GLboolean") boolean normalized, @NativeType(value="GLsizei") int stride, @NativeType(value="void const *") long pointer) {
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, pointer);
    }

    public static void glVertexAttribPointer(@NativeType(value="GLuint") int index, @NativeType(value="GLint") int size, @NativeType(value="GLenum") int type, @NativeType(value="GLboolean") boolean normalized, @NativeType(value="GLsizei") int stride, @NativeType(value="void const *") ShortBuffer pointer) {
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress((ShortBuffer)pointer));
    }

    public static void glVertexAttribPointer(@NativeType(value="GLuint") int index, @NativeType(value="GLint") int size, @NativeType(value="GLenum") int type, @NativeType(value="GLboolean") boolean normalized, @NativeType(value="GLsizei") int stride, @NativeType(value="void const *") IntBuffer pointer) {
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress((IntBuffer)pointer));
    }

    public static void glVertexAttribPointer(@NativeType(value="GLuint") int index, @NativeType(value="GLint") int size, @NativeType(value="GLenum") int type, @NativeType(value="GLboolean") boolean normalized, @NativeType(value="GLsizei") int stride, @NativeType(value="void const *") FloatBuffer pointer) {
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress((FloatBuffer)pointer));
    }

    public static native void glViewport(@NativeType(value="GLint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLsizei") int var2, @NativeType(value="GLsizei") int var3);

    public static void glBufferData(@NativeType(value="GLenum") int target, @NativeType(value="void const *") short[] data, @NativeType(value="GLenum") int usage) {
        long __functionAddress = GLES.getICD().glBufferData;
        JNI.callPPV((int)target, (long)(Integer.toUnsignedLong(data.length) << 1), (short[])data, (int)usage, (long)__functionAddress);
    }

    public static void glBufferData(@NativeType(value="GLenum") int target, @NativeType(value="void const *") int[] data, @NativeType(value="GLenum") int usage) {
        long __functionAddress = GLES.getICD().glBufferData;
        JNI.callPPV((int)target, (long)(Integer.toUnsignedLong(data.length) << 2), (int[])data, (int)usage, (long)__functionAddress);
    }

    public static void glBufferData(@NativeType(value="GLenum") int target, @NativeType(value="void const *") float[] data, @NativeType(value="GLenum") int usage) {
        long __functionAddress = GLES.getICD().glBufferData;
        JNI.callPPV((int)target, (long)(Integer.toUnsignedLong(data.length) << 2), (float[])data, (int)usage, (long)__functionAddress);
    }

    public static void glBufferSubData(@NativeType(value="GLenum") int target, @NativeType(value="GLintptr") long offset, @NativeType(value="void const *") short[] data) {
        long __functionAddress = GLES.getICD().glBufferSubData;
        JNI.callPPPV((int)target, (long)offset, (long)(Integer.toUnsignedLong(data.length) << 1), (short[])data, (long)__functionAddress);
    }

    public static void glBufferSubData(@NativeType(value="GLenum") int target, @NativeType(value="GLintptr") long offset, @NativeType(value="void const *") int[] data) {
        long __functionAddress = GLES.getICD().glBufferSubData;
        JNI.callPPPV((int)target, (long)offset, (long)(Integer.toUnsignedLong(data.length) << 2), (int[])data, (long)__functionAddress);
    }

    public static void glBufferSubData(@NativeType(value="GLenum") int target, @NativeType(value="GLintptr") long offset, @NativeType(value="void const *") float[] data) {
        long __functionAddress = GLES.getICD().glBufferSubData;
        JNI.callPPPV((int)target, (long)offset, (long)(Integer.toUnsignedLong(data.length) << 2), (float[])data, (long)__functionAddress);
    }

    public static void glDeleteBuffers(@NativeType(value="GLuint const *") int[] buffers) {
        long __functionAddress = GLES.getICD().glDeleteBuffers;
        JNI.callPV((int)buffers.length, (int[])buffers, (long)__functionAddress);
    }

    public static void glDeleteFramebuffers(@NativeType(value="GLuint const *") int[] framebuffers) {
        long __functionAddress = GLES.getICD().glDeleteFramebuffers;
        JNI.callPV((int)framebuffers.length, (int[])framebuffers, (long)__functionAddress);
    }

    public static void glDeleteRenderbuffers(@NativeType(value="GLuint const *") int[] renderbuffers) {
        long __functionAddress = GLES.getICD().glDeleteRenderbuffers;
        JNI.callPV((int)renderbuffers.length, (int[])renderbuffers, (long)__functionAddress);
    }

    public static void glDeleteTextures(@NativeType(value="GLuint const *") int[] textures) {
        long __functionAddress = GLES.getICD().glDeleteTextures;
        JNI.callPV((int)textures.length, (int[])textures, (long)__functionAddress);
    }

    public static void glGenBuffers(@NativeType(value="GLuint *") int[] buffers) {
        long __functionAddress = GLES.getICD().glGenBuffers;
        JNI.callPV((int)buffers.length, (int[])buffers, (long)__functionAddress);
    }

    public static void glGenFramebuffers(@NativeType(value="GLuint *") int[] framebuffers) {
        long __functionAddress = GLES.getICD().glGenFramebuffers;
        JNI.callPV((int)framebuffers.length, (int[])framebuffers, (long)__functionAddress);
    }

    public static void glGenRenderbuffers(@NativeType(value="GLuint *") int[] renderbuffers) {
        long __functionAddress = GLES.getICD().glGenRenderbuffers;
        JNI.callPV((int)renderbuffers.length, (int[])renderbuffers, (long)__functionAddress);
    }

    public static void glGenTextures(@NativeType(value="GLuint *") int[] textures) {
        long __functionAddress = GLES.getICD().glGenTextures;
        JNI.callPV((int)textures.length, (int[])textures, (long)__functionAddress);
    }

    public static void glGetActiveAttrib(@NativeType(value="GLuint") int program, @NativeType(value="GLuint") int index, @Nullable @NativeType(value="GLsizei *") int[] length, @NativeType(value="GLint *") int[] size, @NativeType(value="GLenum *") int[] type, @NativeType(value="GLchar *") ByteBuffer name) {
        long __functionAddress = GLES.getICD().glGetActiveAttrib;
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])length, (int)1);
            Checks.check((int[])size, (int)1);
            Checks.check((int[])type, (int)1);
        }
        JNI.callPPPPV((int)program, (int)index, (int)name.remaining(), (int[])length, (int[])size, (int[])type, (long)MemoryUtil.memAddress((ByteBuffer)name), (long)__functionAddress);
    }

    public static void glGetActiveUniform(@NativeType(value="GLuint") int program, @NativeType(value="GLuint") int index, @Nullable @NativeType(value="GLsizei *") int[] length, @NativeType(value="GLint *") int[] size, @NativeType(value="GLenum *") int[] type, @NativeType(value="GLchar *") ByteBuffer name) {
        long __functionAddress = GLES.getICD().glGetActiveUniform;
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])length, (int)1);
            Checks.check((int[])size, (int)1);
            Checks.check((int[])type, (int)1);
        }
        JNI.callPPPPV((int)program, (int)index, (int)name.remaining(), (int[])length, (int[])size, (int[])type, (long)MemoryUtil.memAddress((ByteBuffer)name), (long)__functionAddress);
    }

    public static void glGetAttachedShaders(@NativeType(value="GLuint") int program, @Nullable @NativeType(value="GLsizei *") int[] count, @NativeType(value="GLuint *") int[] shaders) {
        long __functionAddress = GLES.getICD().glGetAttachedShaders;
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])count, (int)1);
        }
        JNI.callPPV((int)program, (int)shaders.length, (int[])count, (int[])shaders, (long)__functionAddress);
    }

    public static void glGetBufferParameteriv(@NativeType(value="GLenum") int target, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") int[] params) {
        long __functionAddress = GLES.getICD().glGetBufferParameteriv;
        if (Checks.CHECKS) {
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((int)target, (int)pname, (int[])params, (long)__functionAddress);
    }

    public static void glGetFloatv(@NativeType(value="GLenum") int pname, @NativeType(value="GLfloat *") float[] data) {
        long __functionAddress = GLES.getICD().glGetFloatv;
        if (Checks.CHECKS) {
            Checks.check((float[])data, (int)1);
        }
        JNI.callPV((int)pname, (float[])data, (long)__functionAddress);
    }

    public static void glGetFramebufferAttachmentParameteriv(@NativeType(value="GLenum") int target, @NativeType(value="GLenum") int attachment, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") int[] params) {
        long __functionAddress = GLES.getICD().glGetFramebufferAttachmentParameteriv;
        if (Checks.CHECKS) {
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((int)target, (int)attachment, (int)pname, (int[])params, (long)__functionAddress);
    }

    public static void glGetIntegerv(@NativeType(value="GLenum") int pname, @NativeType(value="GLint *") int[] data) {
        long __functionAddress = GLES.getICD().glGetIntegerv;
        if (Checks.CHECKS) {
            Checks.check((int[])data, (int)1);
        }
        JNI.callPV((int)pname, (int[])data, (long)__functionAddress);
    }

    public static void glGetProgramiv(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") int[] params) {
        long __functionAddress = GLES.getICD().glGetProgramiv;
        if (Checks.CHECKS) {
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((int)program, (int)pname, (int[])params, (long)__functionAddress);
    }

    public static void glGetProgramInfoLog(@NativeType(value="GLuint") int program, @Nullable @NativeType(value="GLsizei *") int[] length, @NativeType(value="GLchar *") ByteBuffer infoLog) {
        long __functionAddress = GLES.getICD().glGetProgramInfoLog;
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPV((int)program, (int)infoLog.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)infoLog), (long)__functionAddress);
    }

    public static void glGetRenderbufferParameteriv(@NativeType(value="GLenum") int target, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") int[] params) {
        long __functionAddress = GLES.getICD().glGetRenderbufferParameteriv;
        if (Checks.CHECKS) {
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((int)target, (int)pname, (int[])params, (long)__functionAddress);
    }

    public static void glGetShaderiv(@NativeType(value="GLuint") int shader, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") int[] params) {
        long __functionAddress = GLES.getICD().glGetShaderiv;
        if (Checks.CHECKS) {
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((int)shader, (int)pname, (int[])params, (long)__functionAddress);
    }

    public static void glGetShaderInfoLog(@NativeType(value="GLuint") int shader, @Nullable @NativeType(value="GLsizei *") int[] length, @NativeType(value="GLchar *") ByteBuffer infoLog) {
        long __functionAddress = GLES.getICD().glGetShaderInfoLog;
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPV((int)shader, (int)infoLog.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)infoLog), (long)__functionAddress);
    }

    public static void glGetShaderPrecisionFormat(@NativeType(value="GLenum") int shadertype, @NativeType(value="GLenum") int precisiontype, @NativeType(value="GLint *") int[] range, @NativeType(value="GLint *") int[] precision) {
        long __functionAddress = GLES.getICD().glGetShaderPrecisionFormat;
        if (Checks.CHECKS) {
            Checks.check((int[])range, (int)2);
            Checks.check((int[])precision, (int)2);
        }
        JNI.callPPV((int)shadertype, (int)precisiontype, (int[])range, (int[])precision, (long)__functionAddress);
    }

    public static void glGetShaderSource(@NativeType(value="GLuint") int shader, @Nullable @NativeType(value="GLsizei *") int[] length, @NativeType(value="GLchar *") ByteBuffer source) {
        long __functionAddress = GLES.getICD().glGetShaderSource;
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPV((int)shader, (int)source.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)source), (long)__functionAddress);
    }

    public static void glGetTexParameterfv(@NativeType(value="GLenum") int target, @NativeType(value="GLenum") int pname, @NativeType(value="GLfloat *") float[] params) {
        long __functionAddress = GLES.getICD().glGetTexParameterfv;
        if (Checks.CHECKS) {
            Checks.check((float[])params, (int)1);
        }
        JNI.callPV((int)target, (int)pname, (float[])params, (long)__functionAddress);
    }

    public static void glGetTexParameteriv(@NativeType(value="GLenum") int target, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") int[] params) {
        long __functionAddress = GLES.getICD().glGetTexParameteriv;
        if (Checks.CHECKS) {
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((int)target, (int)pname, (int[])params, (long)__functionAddress);
    }

    public static void glGetUniformfv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLfloat *") float[] params) {
        long __functionAddress = GLES.getICD().glGetUniformfv;
        if (Checks.CHECKS) {
            Checks.check((float[])params, (int)1);
        }
        JNI.callPV((int)program, (int)location, (float[])params, (long)__functionAddress);
    }

    public static void glGetUniformiv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLint *") int[] params) {
        long __functionAddress = GLES.getICD().glGetUniformiv;
        if (Checks.CHECKS) {
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((int)program, (int)location, (int[])params, (long)__functionAddress);
    }

    public static void glGetVertexAttribfv(@NativeType(value="GLuint") int index, @NativeType(value="GLenum") int pname, @NativeType(value="GLfloat *") float[] params) {
        long __functionAddress = GLES.getICD().glGetVertexAttribfv;
        if (Checks.CHECKS) {
            Checks.check((float[])params, (int)4);
        }
        JNI.callPV((int)index, (int)pname, (float[])params, (long)__functionAddress);
    }

    public static void glGetVertexAttribiv(@NativeType(value="GLuint") int index, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") int[] params) {
        long __functionAddress = GLES.getICD().glGetVertexAttribiv;
        if (Checks.CHECKS) {
            Checks.check((int[])params, (int)4);
        }
        JNI.callPV((int)index, (int)pname, (int[])params, (long)__functionAddress);
    }

    public static void glReadPixels(@NativeType(value="GLint") int x, @NativeType(value="GLint") int y, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @NativeType(value="void *") short[] pixels) {
        long __functionAddress = GLES.getICD().glReadPixels;
        JNI.callPV((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (short[])pixels, (long)__functionAddress);
    }

    public static void glReadPixels(@NativeType(value="GLint") int x, @NativeType(value="GLint") int y, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @NativeType(value="void *") int[] pixels) {
        long __functionAddress = GLES.getICD().glReadPixels;
        JNI.callPV((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (int[])pixels, (long)__functionAddress);
    }

    public static void glReadPixels(@NativeType(value="GLint") int x, @NativeType(value="GLint") int y, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @NativeType(value="void *") float[] pixels) {
        long __functionAddress = GLES.getICD().glReadPixels;
        JNI.callPV((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (float[])pixels, (long)__functionAddress);
    }

    public static void glShaderBinary(@NativeType(value="GLuint const *") int[] shaders, @NativeType(value="GLenum") int binaryformat, @NativeType(value="void const *") ByteBuffer binary) {
        long __functionAddress = GLES.getICD().glShaderBinary;
        JNI.callPPV((int)shaders.length, (int[])shaders, (int)binaryformat, (long)MemoryUtil.memAddress((ByteBuffer)binary), (int)binary.remaining(), (long)__functionAddress);
    }

    public static void glShaderSource(@NativeType(value="GLuint") int shader, @NativeType(value="GLchar const * const *") PointerBuffer string, @Nullable @NativeType(value="GLint const *") int[] length) {
        long __functionAddress = GLES.getICD().glShaderSource;
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])length, (int)string.remaining());
        }
        JNI.callPPV((int)shader, (int)string.remaining(), (long)MemoryUtil.memAddress((CustomBuffer)string), (int[])length, (long)__functionAddress);
    }

    public static void glTexImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLint") int internalformat, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLint") int border, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @Nullable @NativeType(value="void const *") short[] pixels) {
        long __functionAddress = GLES.getICD().glTexImage2D;
        JNI.callPV((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (short[])pixels, (long)__functionAddress);
    }

    public static void glTexImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLint") int internalformat, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLint") int border, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @Nullable @NativeType(value="void const *") int[] pixels) {
        long __functionAddress = GLES.getICD().glTexImage2D;
        JNI.callPV((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (int[])pixels, (long)__functionAddress);
    }

    public static void glTexImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLint") int internalformat, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLint") int border, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @Nullable @NativeType(value="void const *") float[] pixels) {
        long __functionAddress = GLES.getICD().glTexImage2D;
        JNI.callPV((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (float[])pixels, (long)__functionAddress);
    }

    public static void glTexParameterfv(@NativeType(value="GLenum") int target, @NativeType(value="GLenum") int pname, @NativeType(value="GLfloat const *") float[] params) {
        long __functionAddress = GLES.getICD().glTexParameterfv;
        if (Checks.CHECKS) {
            Checks.check((float[])params, (int)1);
        }
        JNI.callPV((int)target, (int)pname, (float[])params, (long)__functionAddress);
    }

    public static void glTexParameteriv(@NativeType(value="GLenum") int target, @NativeType(value="GLenum") int pname, @NativeType(value="GLint const *") int[] params) {
        long __functionAddress = GLES.getICD().glTexParameteriv;
        if (Checks.CHECKS) {
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((int)target, (int)pname, (int[])params, (long)__functionAddress);
    }

    public static void glTexSubImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLint") int xoffset, @NativeType(value="GLint") int yoffset, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @NativeType(value="void const *") short[] pixels) {
        long __functionAddress = GLES.getICD().glTexSubImage2D;
        JNI.callPV((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (short[])pixels, (long)__functionAddress);
    }

    public static void glTexSubImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLint") int xoffset, @NativeType(value="GLint") int yoffset, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @NativeType(value="void const *") int[] pixels) {
        long __functionAddress = GLES.getICD().glTexSubImage2D;
        JNI.callPV((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (int[])pixels, (long)__functionAddress);
    }

    public static void glTexSubImage2D(@NativeType(value="GLenum") int target, @NativeType(value="GLint") int level, @NativeType(value="GLint") int xoffset, @NativeType(value="GLint") int yoffset, @NativeType(value="GLsizei") int width, @NativeType(value="GLsizei") int height, @NativeType(value="GLenum") int format, @NativeType(value="GLenum") int type, @NativeType(value="void const *") float[] pixels) {
        long __functionAddress = GLES.getICD().glTexSubImage2D;
        JNI.callPV((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (float[])pixels, (long)__functionAddress);
    }

    public static void glUniform1fv(@NativeType(value="GLint") int location, @NativeType(value="GLfloat const *") float[] value) {
        long __functionAddress = GLES.getICD().glUniform1fv;
        JNI.callPV((int)location, (int)value.length, (float[])value, (long)__functionAddress);
    }

    public static void glUniform1iv(@NativeType(value="GLint") int location, @NativeType(value="GLint const *") int[] value) {
        long __functionAddress = GLES.getICD().glUniform1iv;
        JNI.callPV((int)location, (int)value.length, (int[])value, (long)__functionAddress);
    }

    public static void glUniform2fv(@NativeType(value="GLint") int location, @NativeType(value="GLfloat const *") float[] value) {
        long __functionAddress = GLES.getICD().glUniform2fv;
        JNI.callPV((int)location, (int)(value.length >> 1), (float[])value, (long)__functionAddress);
    }

    public static void glUniform2iv(@NativeType(value="GLint") int location, @NativeType(value="GLint const *") int[] value) {
        long __functionAddress = GLES.getICD().glUniform2iv;
        JNI.callPV((int)location, (int)(value.length >> 1), (int[])value, (long)__functionAddress);
    }

    public static void glUniform3fv(@NativeType(value="GLint") int location, @NativeType(value="GLfloat const *") float[] value) {
        long __functionAddress = GLES.getICD().glUniform3fv;
        JNI.callPV((int)location, (int)(value.length / 3), (float[])value, (long)__functionAddress);
    }

    public static void glUniform3iv(@NativeType(value="GLint") int location, @NativeType(value="GLint const *") int[] value) {
        long __functionAddress = GLES.getICD().glUniform3iv;
        JNI.callPV((int)location, (int)(value.length / 3), (int[])value, (long)__functionAddress);
    }

    public static void glUniform4fv(@NativeType(value="GLint") int location, @NativeType(value="GLfloat const *") float[] value) {
        long __functionAddress = GLES.getICD().glUniform4fv;
        JNI.callPV((int)location, (int)(value.length >> 2), (float[])value, (long)__functionAddress);
    }

    public static void glUniform4iv(@NativeType(value="GLint") int location, @NativeType(value="GLint const *") int[] value) {
        long __functionAddress = GLES.getICD().glUniform4iv;
        JNI.callPV((int)location, (int)(value.length >> 2), (int[])value, (long)__functionAddress);
    }

    public static void glUniformMatrix2fv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="GLfloat const *") float[] value) {
        long __functionAddress = GLES.getICD().glUniformMatrix2fv;
        JNI.callPV((int)location, (int)(value.length >> 2), (boolean)transpose, (float[])value, (long)__functionAddress);
    }

    public static void glUniformMatrix3fv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="GLfloat const *") float[] value) {
        long __functionAddress = GLES.getICD().glUniformMatrix3fv;
        JNI.callPV((int)location, (int)(value.length / 9), (boolean)transpose, (float[])value, (long)__functionAddress);
    }

    public static void glUniformMatrix4fv(@NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="GLfloat const *") float[] value) {
        long __functionAddress = GLES.getICD().glUniformMatrix4fv;
        JNI.callPV((int)location, (int)(value.length >> 4), (boolean)transpose, (float[])value, (long)__functionAddress);
    }

    public static void glVertexAttrib1fv(@NativeType(value="GLuint") int index, @NativeType(value="GLfloat const *") float[] v) {
        long __functionAddress = GLES.getICD().glVertexAttrib1fv;
        if (Checks.CHECKS) {
            Checks.check((float[])v, (int)1);
        }
        JNI.callPV((int)index, (float[])v, (long)__functionAddress);
    }

    public static void glVertexAttrib2fv(@NativeType(value="GLuint") int index, @NativeType(value="GLfloat const *") float[] v) {
        long __functionAddress = GLES.getICD().glVertexAttrib2fv;
        if (Checks.CHECKS) {
            Checks.check((float[])v, (int)2);
        }
        JNI.callPV((int)index, (float[])v, (long)__functionAddress);
    }

    public static void glVertexAttrib3fv(@NativeType(value="GLuint") int index, @NativeType(value="GLfloat const *") float[] v) {
        long __functionAddress = GLES.getICD().glVertexAttrib3fv;
        if (Checks.CHECKS) {
            Checks.check((float[])v, (int)3);
        }
        JNI.callPV((int)index, (float[])v, (long)__functionAddress);
    }

    public static void glVertexAttrib4fv(@NativeType(value="GLuint") int index, @NativeType(value="GLfloat const *") float[] v) {
        long __functionAddress = GLES.getICD().glVertexAttrib4fv;
        if (Checks.CHECKS) {
            Checks.check((float[])v, (int)4);
        }
        JNI.callPV((int)index, (float[])v, (long)__functionAddress);
    }

    static {
        GLES.initialize();
    }
}

