/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.unsafememcpy;

import java.nio.Buffer;
import java.nio.ByteBuffer;

public class UnsafeUtils {
    private static boolean hasLoadedNatives = false;

    static {
        UnsafeUtils.loadNatives();
    }

    public static void loadNatives() {
        if (!hasLoadedNatives) {
            hasLoadedNatives = true;
            System.loadLibrary("UnsafeMemcpy");
            int n = UnsafeUtils.getVersionMajor();
            int n2 = UnsafeUtils.getVersionMinor();
            if (n != 1 || n2 < 0) {
                throw new UnsatisfiedLinkError("Invalid UnsafeMemcpy native library version: " + n + "." + n2 + " (expected: 1.0)");
            }
        }
    }

    public static native int getVersionMajor();

    public static native int getVersionMinor();

    public static native ByteBuffer makeDirectBuffer(long var0, int var2);

    public static native ByteBuffer makeDirectBuffer(long var0, long var2);

    public static native long getAddress(Buffer var0);

    public static native byte getMemByte(long var0);

    public static native short getMemShort(long var0);

    public static native char getMemChar(long var0);

    public static native int getMemInt(long var0);

    public static native long getMemLong(long var0);

    public static native double getMemDouble(long var0);

    public static native float getMemFloat(long var0);

    public static native void setMemByte(long var0, byte var2);

    public static native void setMemShort(long var0, short var2);

    public static native void setMemChar(long var0, char var2);

    public static native void setMemInt(long var0, int var2);

    public static native void setMemLong(long var0, long var2);

    public static native void setMemDouble(long var0, double var2);

    public static native void setMemFloat(long var0, float var2);
}

