/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc;

import dev.onvoid.webrtc.RTCDataChannelBuffer;
import dev.onvoid.webrtc.RTCDataChannelObserver;
import dev.onvoid.webrtc.RTCDataChannelState;
import dev.onvoid.webrtc.internal.DisposableNativeObject;
import java.nio.ByteBuffer;

public class RTCDataChannel
extends DisposableNativeObject {
    private RTCDataChannel() {
    }

    public native void registerObserver(RTCDataChannelObserver var1);

    public native void unregisterObserver();

    public native String getLabel();

    public native boolean isReliable();

    public native boolean isOrdered();

    public native int getMaxPacketLifeTime();

    public native int getMaxRetransmits();

    public native String getProtocol();

    public native boolean isNegotiated();

    public native int getId();

    public native RTCDataChannelState getState();

    public native long getBufferedAmount();

    public native void close();

    @Override
    public native void dispose();

    public void send(RTCDataChannelBuffer buffer) throws Exception {
        ByteBuffer data = buffer.data;
        if (data.isDirect()) {
            this.sendDirectBuffer(data, buffer.binary);
        } else {
            byte[] arrayBuffer;
            if (data.hasArray()) {
                arrayBuffer = data.array();
            } else {
                arrayBuffer = new byte[data.remaining()];
                data.get(arrayBuffer);
            }
            this.sendByteArrayBuffer(arrayBuffer, buffer.binary);
        }
    }

    private native void sendDirectBuffer(ByteBuffer var1, boolean var2);

    private native void sendByteArrayBuffer(byte[] var1, boolean var2);
}

