/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.media.audio;

import dev.onvoid.webrtc.media.MediaStreamTrack;
import dev.onvoid.webrtc.media.audio.AudioTrackSink;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;

public class AudioTrack
extends MediaStreamTrack {
    private final Map<AudioTrackSink, Long> sinks = new IdentityHashMap<AudioTrackSink, Long>();

    private AudioTrack() {
    }

    @Override
    public void dispose() {
        for (long nativeSink : this.sinks.values()) {
            this.removeSinkInternal(nativeSink);
        }
        this.sinks.clear();
        super.dispose();
    }

    public void addSink(AudioTrackSink sink) {
        if (Objects.isNull(sink)) {
            throw new NullPointerException();
        }
        if (this.sinks.containsKey(sink)) {
            return;
        }
        long nativeSink = this.addSinkInternal(sink);
        this.sinks.put(sink, nativeSink);
    }

    public void removeSink(AudioTrackSink sink) {
        if (Objects.isNull(sink)) {
            throw new NullPointerException();
        }
        Long nativeSink = this.sinks.remove(sink);
        if (Objects.nonNull(nativeSink)) {
            this.removeSinkInternal(nativeSink);
        }
    }

    public native int getSignalLevel();

    private native long addSinkInternal(AudioTrackSink var1);

    private native void removeSinkInternal(long var1);
}

