/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.media.video;

import dev.onvoid.webrtc.media.MediaStreamTrack;
import dev.onvoid.webrtc.media.video.VideoTrackSink;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;

public class VideoTrack
extends MediaStreamTrack {
    private final Map<VideoTrackSink, Long> sinks = new IdentityHashMap<VideoTrackSink, Long>();

    private VideoTrack() {
    }

    @Override
    public void dispose() {
        for (long nativeSink : this.sinks.values()) {
            this.removeSinkInternal(nativeSink);
        }
        this.sinks.clear();
        super.dispose();
    }

    public void addSink(VideoTrackSink sink) {
        if (Objects.isNull(sink)) {
            throw new NullPointerException();
        }
        if (this.sinks.containsKey(sink)) {
            return;
        }
        long nativeSink = this.addSinkInternal(sink);
        this.sinks.put(sink, nativeSink);
    }

    public void removeSink(VideoTrackSink sink) {
        if (Objects.isNull(sink)) {
            throw new NullPointerException();
        }
        Long nativeSink = this.sinks.remove(sink);
        if (Objects.nonNull(nativeSink)) {
            this.removeSinkInternal(nativeSink);
        }
    }

    private native long addSinkInternal(VideoTrackSink var1);

    private native void removeSinkInternal(long var1);
}

