#line 2

/*
 * Copyright (c) 2024 lax1dude. All Rights Reserved.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 */

EAGLER_IN(vec2, v_position2f)

EAGLER_FRAG_OUT()

uniform sampler2D u_inputTexture;
uniform mat4 u_textureMatrix;

vec2 rand(in vec2 co){
	float f = dot(co, vec2(12.98984576, 78.23378678));
	return fract(vec2(sin(f + 0.32490982), cos(f - 0.69890)) * 43758.54576873);
}

void main() {
	vec4 coords4f = vec4(v_position2f.x * 0.25 - 0.125, v_position2f.y * 0.25 - 0.125, v_position2f.y * 10.0 - 9.0, 1.0);
	coords4f = u_textureMatrix * coords4f;
	coords4f.xy /= coords4f.w;
	EAGLER_FRAG_COLOR = EAGLER_TEXTURE_2D(u_inputTexture, coords4f.xy * 0.5 + 0.5);
	EAGLER_FRAG_COLOR.rg += rand(v_position2f * 1.2344574345) * 0.05;
	EAGLER_FRAG_COLOR.ba -= rand(v_position2f * 1.2343525225) * 0.05;
	EAGLER_FRAG_COLOR.a = fract(sin(dot(coords4f.yz, vec2(12.9898, 78.233))) * 43758.5453);
	EAGLER_FRAG_COLOR.a += exp(length(rand(coords4f.xw)) * -69.420);
	EAGLER_FRAG_COLOR = pow(EAGLER_FRAG_COLOR, vec4(1.0 / 2.423952));
	EAGLER_FRAG_COLOR = pow(EAGLER_FRAG_COLOR, vec4(5.4523856));
	EAGLER_FRAG_COLOR += 0.00004423 + EAGLER_FRAG_COLOR.a * 0.02;
	EAGLER_FRAG_COLOR = sqrt(EAGLER_FRAG_COLOR);
	EAGLER_FRAG_COLOR = pow(EAGLER_FRAG_COLOR, vec4(1.0 / 1.9023576));
#ifdef EAGLER_HAS_GLES_300
	EAGLER_FRAG_COLOR.ra += tanh(fract(EAGLER_FRAG_COLOR.a * 32.324834)) * 0.1012426;
#endif
	EAGLER_FRAG_COLOR.b *= 0.934924;
	EAGLER_FRAG_COLOR.b += (1.23213 / inversesqrt(EAGLER_FRAG_COLOR.a)) * 0.156365;
	EAGLER_FRAG_COLOR.ga += rand(gl_FragCoord.xy) * 0.13423567;
	EAGLER_FRAG_COLOR.rb += gl_PointCoord * 0.0124264565;
#ifdef EAGLER_HAS_GLES_300
	EAGLER_FRAG_COLOR *= 0.95234 + asinh(EAGLER_FRAG_COLOR.g * 5.23423) * 0.0254325;
#endif
}
