package net.minecraft.advancements;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;
import javax.annotation.Nullable;

import org.json.JSONException;
import org.json.JSONObject;

import net.lax1dude.eaglercraft.json.JSONTypeCodec;
import net.lax1dude.eaglercraft.json.JSONTypeDeserializer;
import net.minecraft.network.PacketBuffer;

public class AdvancementProgress implements Comparable<AdvancementProgress> {
	private final Map<String, CriterionProgress> field_192110_a = Maps.<String, CriterionProgress>newHashMap();
	private String[][] field_192111_b = new String[0][];

	public void func_192099_a(Map<String, Criterion> p_192099_1_, String[][] p_192099_2_) {
		Set<String> set = p_192099_1_.keySet();
		Iterator<Entry<String, CriterionProgress>> iterator = this.field_192110_a.entrySet().iterator();

		while (iterator.hasNext()) {
			Entry<String, CriterionProgress> entry = (Entry) iterator.next();

			if (!set.contains(entry.getKey())) {
				iterator.remove();
			}
		}

		for (String s : set) {
			if (!this.field_192110_a.containsKey(s)) {
				this.field_192110_a.put(s, new CriterionProgress(this));
			}
		}

		this.field_192111_b = p_192099_2_;
	}

	public boolean func_192105_a() {
		if (this.field_192111_b.length == 0) {
			return false;
		} else {
			for (String[] astring : this.field_192111_b) {
				boolean flag = false;

				for (String s : astring) {
					CriterionProgress criterionprogress = this.func_192106_c(s);

					if (criterionprogress != null && criterionprogress.func_192151_a()) {
						flag = true;
						break;
					}
				}

				if (!flag) {
					return false;
				}
			}

			return true;
		}
	}

	public boolean func_192108_b() {
		for (CriterionProgress criterionprogress : this.field_192110_a.values()) {
			if (criterionprogress.func_192151_a()) {
				return true;
			}
		}

		return false;
	}

	public boolean func_192109_a(String p_192109_1_) {
		CriterionProgress criterionprogress = this.field_192110_a.get(p_192109_1_);

		if (criterionprogress != null && !criterionprogress.func_192151_a()) {
			criterionprogress.func_192153_b();
			return true;
		} else {
			return false;
		}
	}

	public boolean func_192101_b(String p_192101_1_) {
		CriterionProgress criterionprogress = this.field_192110_a.get(p_192101_1_);

		if (criterionprogress != null && criterionprogress.func_192151_a()) {
			criterionprogress.func_192154_c();
			return true;
		} else {
			return false;
		}
	}

	public String toString() {
		return "AdvancementProgress{criteria=" + this.field_192110_a + ", requirements="
				+ Arrays.deepToString(this.field_192111_b) + '}';
	}

	public void func_192104_a(PacketBuffer p_192104_1_) {
		p_192104_1_.writeVarIntToBuffer(this.field_192110_a.size());

		for (Entry<String, CriterionProgress> entry : this.field_192110_a.entrySet()) {
			p_192104_1_.writeString(entry.getKey());
			((CriterionProgress) entry.getValue()).func_192150_a(p_192104_1_);
		}
	}

	public static AdvancementProgress func_192100_b(PacketBuffer p_192100_0_) {
		AdvancementProgress advancementprogress = new AdvancementProgress();
		int i = p_192100_0_.readVarIntFromBuffer();

		for (int j = 0; j < i; ++j) {
			advancementprogress.field_192110_a.put(p_192100_0_.readStringFromBuffer(32767),
					CriterionProgress.func_192149_a(p_192100_0_, advancementprogress));
		}

		return advancementprogress;
	}

	@Nullable
	public CriterionProgress func_192106_c(String p_192106_1_) {
		return this.field_192110_a.get(p_192106_1_);
	}

	public float func_192103_c() {
		if (this.field_192110_a.isEmpty()) {
			return 0.0F;
		} else {
			float f = (float) this.field_192111_b.length;
			float f1 = (float) this.func_194032_h();
			return f1 / f;
		}
	}

	@Nullable
	public String func_193126_d() {
		if (this.field_192110_a.isEmpty()) {
			return null;
		} else {
			int i = this.field_192111_b.length;

			if (i <= 1) {
				return null;
			} else {
				int j = this.func_194032_h();
				return j + "/" + i;
			}
		}
	}

	private int func_194032_h() {
		int i = 0;

		for (String[] astring : this.field_192111_b) {
			boolean flag = false;

			for (String s : astring) {
				CriterionProgress criterionprogress = this.func_192106_c(s);

				if (criterionprogress != null && criterionprogress.func_192151_a()) {
					flag = true;
					break;
				}
			}

			if (flag) {
				++i;
			}
		}

		return i;
	}

	public Iterable<String> func_192107_d() {
		List<String> list = Lists.<String>newArrayList();

		for (Entry<String, CriterionProgress> entry : this.field_192110_a.entrySet()) {
			if (!((CriterionProgress) entry.getValue()).func_192151_a()) {
				list.add(entry.getKey());
			}
		}

		return list;
	}

	public Iterable<String> func_192102_e() {
		List<String> list = Lists.<String>newArrayList();

		for (Entry<String, CriterionProgress> entry : this.field_192110_a.entrySet()) {
			if (((CriterionProgress) entry.getValue()).func_192151_a()) {
				list.add(entry.getKey());
			}
		}

		return list;
	}

	@Nullable
	public Date func_193128_g() {
		Date date = null;

		for (CriterionProgress criterionprogress : this.field_192110_a.values()) {
			if (criterionprogress.func_192151_a() && (date == null || criterionprogress.func_193140_d().before(date))) {
				date = criterionprogress.func_193140_d();
			}
		}

		return date;
	}

	public int compareTo(AdvancementProgress p_compareTo_1_) {
		Date date = this.func_193128_g();
		Date date1 = p_compareTo_1_.func_193128_g();

		if (date == null && date1 != null) {
			return 1;
		} else if (date != null && date1 == null) {
			return -1;
		} else {
			return date == null && date1 == null ? 0 : date.compareTo(date1);
		}
	}

	public static class Serializer implements JSONTypeDeserializer<JSONObject, AdvancementProgress>,
			JSONTypeCodec<AdvancementProgress, JSONObject> {
		public JSONObject serialize(AdvancementProgress p_serialize_1_) {
			JSONObject jsonobject = new JSONObject();
			JSONObject jsonobject1 = new JSONObject();

			for (Entry<String, CriterionProgress> entry : p_serialize_1_.field_192110_a.entrySet()) {
				CriterionProgress criterionprogress = entry.getValue();

				if (criterionprogress.func_192151_a()) {
					if (criterionprogress.func_192148_e() != null) {
						jsonobject1.put(entry.getKey(), criterionprogress.func_192148_e());
					}
				}
			}

			if (!jsonobject1.entrySet().isEmpty()) {
				jsonobject.put("criteria", jsonobject1);
			}

			jsonobject.put("done", Boolean.valueOf(p_serialize_1_.func_192105_a()));
			return jsonobject;
		}

		public AdvancementProgress deserialize(JSONObject jsonobject) throws JSONException {
			JSONObject jsonobject1 = jsonobject.optJSONObject("criteria", new JSONObject());
			AdvancementProgress advancementprogress = new AdvancementProgress();

			for (Entry<String, Object> entry : jsonobject1.entrySet()) {
				String s = entry.getKey();
				advancementprogress.field_192110_a.put(s,
						CriterionProgress.func_192152_a(advancementprogress, (String) entry.getValue()));
			}

			return advancementprogress;
		}
	}
}
