package net.minecraft.advancements;

import java.io.IOException;
import javax.annotation.Nullable;

import org.json.JSONException;
import org.json.JSONObject;

import net.lax1dude.eaglercraft.json.JSONTypeProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.peyton.eagler.json.JSONUtils;

public class DisplayInfo {
	private final ITextComponent field_192300_a;
	private final ITextComponent field_193225_b;
	private final ItemStack field_192301_b;
	private final ResourceLocation field_192302_c;
	private final FrameType field_192303_d;
	private final boolean field_193226_f;
	private final boolean field_193227_g;
	private final boolean field_193228_h;
	private float field_192304_e;
	private float field_192305_f;

	public DisplayInfo(ItemStack p_i47586_1_, ITextComponent p_i47586_2_, ITextComponent p_i47586_3_,
			@Nullable ResourceLocation p_i47586_4_, FrameType p_i47586_5_, boolean p_i47586_6_, boolean p_i47586_7_,
			boolean p_i47586_8_) {
		this.field_192300_a = p_i47586_2_;
		this.field_193225_b = p_i47586_3_;
		this.field_192301_b = p_i47586_1_;
		this.field_192302_c = p_i47586_4_;
		this.field_192303_d = p_i47586_5_;
		this.field_193226_f = p_i47586_6_;
		this.field_193227_g = p_i47586_7_;
		this.field_193228_h = p_i47586_8_;
	}

	public void func_192292_a(float p_192292_1_, float p_192292_2_) {
		this.field_192304_e = p_192292_1_;
		this.field_192305_f = p_192292_2_;
	}

	public ITextComponent func_192297_a() {
		return this.field_192300_a;
	}

	public ITextComponent func_193222_b() {
		return this.field_193225_b;
	}

	public ItemStack func_192298_b() {
		return this.field_192301_b;
	}

	@Nullable
	public ResourceLocation func_192293_c() {
		return this.field_192302_c;
	}

	public FrameType func_192291_d() {
		return this.field_192303_d;
	}

	public float func_192299_e() {
		return this.field_192304_e;
	}

	public float func_192296_f() {
		return this.field_192305_f;
	}

	public boolean func_193223_h() {
		return this.field_193226_f;
	}

	public boolean func_193220_i() {
		return this.field_193227_g;
	}

	public boolean func_193224_j() {
		return this.field_193228_h;
	}

	public static DisplayInfo func_192294_a(JSONObject p_192294_0_) {
		ITextComponent itextcomponent = (ITextComponent) JSONTypeProvider.deserialize(p_192294_0_.get("title"),
				ITextComponent.class);
		ITextComponent itextcomponent1 = (ITextComponent) JSONTypeProvider.deserialize(p_192294_0_.get("description"),
				ITextComponent.class);

		if (itextcomponent != null && itextcomponent1 != null) {
			ItemStack itemstack = func_193221_a(p_192294_0_.getJSONObject("icon"));
			ResourceLocation resourcelocation = p_192294_0_.has("background")
					? new ResourceLocation(p_192294_0_.getString("background"))
					: null;
			FrameType frametype = p_192294_0_.has("frame") ? FrameType.func_192308_a(p_192294_0_.getString("frame"))
					: FrameType.TASK;
			boolean flag = p_192294_0_.optBoolean("show_toast", true);
			boolean flag1 = p_192294_0_.optBoolean("announce_to_chat", true);
			boolean flag2 = p_192294_0_.optBoolean("hidden", false);
			return new DisplayInfo(itemstack, itextcomponent, itextcomponent1, resourcelocation, frametype, flag, flag1,
					flag2);
		} else {
			throw new JSONException("Both title and description must be set");
		}
	}

	private static ItemStack func_193221_a(JSONObject p_193221_0_) {
		if (!p_193221_0_.has("item")) {
			throw new JSONException("Unsupported icon type, currently only items are supported (add 'item' key)");
		} else {
			Item item = JSONUtils.getItem(p_193221_0_, "item");
			int i = p_193221_0_.optInt("data", 0);
			return new ItemStack(item, 1, i);
		}
	}

	public void func_192290_a(PacketBuffer p_192290_1_) {
		p_192290_1_.writeTextComponent(this.field_192300_a);
		p_192290_1_.writeTextComponent(this.field_193225_b);
		p_192290_1_.writeItemStackToBuffer(this.field_192301_b);
		p_192290_1_.writeEnumValue(this.field_192303_d);
		int i = 0;

		if (this.field_192302_c != null) {
			i |= 1;
		}

		if (this.field_193226_f) {
			i |= 2;
		}

		if (this.field_193228_h) {
			i |= 4;
		}

		p_192290_1_.writeInt(i);

		if (this.field_192302_c != null) {
			p_192290_1_.func_192572_a(this.field_192302_c);
		}

		p_192290_1_.writeFloat(this.field_192304_e);
		p_192290_1_.writeFloat(this.field_192305_f);
	}

	public static DisplayInfo func_192295_b(PacketBuffer p_192295_0_) throws IOException {
		ITextComponent itextcomponent = p_192295_0_.readTextComponent();
		ITextComponent itextcomponent1 = p_192295_0_.readTextComponent();
		ItemStack itemstack = p_192295_0_.readItemStackFromBuffer();
		FrameType frametype = (FrameType) p_192295_0_.readEnumValue(FrameType.class);
		int i = p_192295_0_.readInt();
		ResourceLocation resourcelocation = (i & 1) != 0 ? p_192295_0_.func_192575_l() : null;
		boolean flag = (i & 2) != 0;
		boolean flag1 = (i & 4) != 0;
		DisplayInfo displayinfo = new DisplayInfo(itemstack, itextcomponent, itextcomponent1, resourcelocation,
				frametype, flag, false, flag1);
		displayinfo.func_192292_a(p_192295_0_.readFloat(), p_192295_0_.readFloat());
		return displayinfo;
	}
}
