package net.minecraft.advancements.critereon;

import javax.annotation.Nullable;

import org.json.JSONException;
import org.json.JSONObject;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;

public class EntityPredicate {
	public static final EntityPredicate field_192483_a = new EntityPredicate((ResourceLocation) null,
			DistancePredicate.field_193423_a, LocationPredicate.field_193455_a, MobEffectsPredicate.field_193473_a,
			NBTPredicate.field_193479_a);
	private final ResourceLocation field_192484_b;
	private final DistancePredicate field_192485_c;
	private final LocationPredicate field_193435_d;
	private final MobEffectsPredicate field_193436_e;
	private final NBTPredicate field_193437_f;

	public EntityPredicate(@Nullable ResourceLocation p_i47541_1_, DistancePredicate p_i47541_2_,
			LocationPredicate p_i47541_3_, MobEffectsPredicate p_i47541_4_, NBTPredicate p_i47541_5_) {
		this.field_192484_b = p_i47541_1_;
		this.field_192485_c = p_i47541_2_;
		this.field_193435_d = p_i47541_3_;
		this.field_193436_e = p_i47541_4_;
		this.field_193437_f = p_i47541_5_;
	}

	public boolean func_192482_a(EntityPlayerMP p_192482_1_, @Nullable Entity p_192482_2_) {
		if (this == field_192483_a) {
			return true;
		} else if (p_192482_2_ == null) {
			return false;
		} else if (this.field_192484_b != null && !EntityList.isStringEntityName(p_192482_2_, this.field_192484_b)) {
			return false;
		} else if (!this.field_192485_c.func_193422_a(p_192482_1_.posX, p_192482_1_.posY, p_192482_1_.posZ,
				p_192482_2_.posX, p_192482_2_.posY, p_192482_2_.posZ)) {
			return false;
		} else if (!this.field_193435_d.func_193452_a(p_192482_1_.getServerWorld(), p_192482_2_.posX, p_192482_2_.posY,
				p_192482_2_.posZ)) {
			return false;
		} else if (!this.field_193436_e.func_193469_a(p_192482_2_)) {
			return false;
		} else {
			return this.field_193437_f.func_193475_a(p_192482_2_);
		}
	}

	public static EntityPredicate func_192481_a(@Nullable Object p_192481_0_) {
		if (p_192481_0_ != null) {
			JSONObject jsonobject = (JSONObject) p_192481_0_;
			ResourceLocation resourcelocation = null;

			if (jsonobject.has("type")) {
				resourcelocation = new ResourceLocation(jsonobject.getString("type"));

				if (!EntityList.isStringValidEntityName(resourcelocation)) {
					throw new JSONException("Unknown entity type '" + resourcelocation + "', valid types are: "
							+ EntityList.func_192840_b());
				}
			}

			DistancePredicate distancepredicate = DistancePredicate.func_193421_a(jsonobject.getOptional("distance"));
			LocationPredicate locationpredicate = LocationPredicate.func_193454_a(jsonobject.getOptional("location"));
			MobEffectsPredicate mobeffectspredicate = MobEffectsPredicate
					.func_193471_a(jsonobject.getOptional("effects"));
			NBTPredicate nbtpredicate = NBTPredicate.func_193476_a(jsonobject.getOptional("nbt"));
			return new EntityPredicate(resourcelocation, distancepredicate, locationpredicate, mobeffectspredicate,
					nbtpredicate);
		} else {
			return field_192483_a;
		}
	}
}
