package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;

public abstract class GuiListExtended extends GuiSlot {
	public GuiListExtended(Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn) {
		super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
	}

	/**
	 * The element in the slot that was clicked, boolean for whether it was double
	 * clicked or not
	 */
	protected void elementClicked(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
	}

	/**
	 * Returns true if the element passed in is currently selected
	 */
	protected boolean isSelected(int slotIndex) {
		return false;
	}

	protected void drawBackground() {
	}

	protected void func_192637_a(int p_192637_1_, int p_192637_2_, int p_192637_3_, int p_192637_4_, int p_192637_5_,
			int p_192637_6_, float p_192637_7_) {
		this.getListEntry(p_192637_1_).func_192634_a(p_192637_1_, p_192637_2_, p_192637_3_, this.getListWidth(),
				p_192637_4_, p_192637_5_, p_192637_6_, this.isMouseYWithinSlotBounds(p_192637_6_)
						&& this.getSlotIndexFromScreenCoords(p_192637_5_, p_192637_6_) == p_192637_1_,
				p_192637_7_);
	}

	protected void func_192639_a(int p_192639_1_, int p_192639_2_, int p_192639_3_, float p_192639_4_) {
		this.getListEntry(p_192639_1_).func_192633_a(p_192639_1_, p_192639_2_, p_192639_3_, p_192639_4_);
	}

	public boolean mouseClicked(int mouseX, int mouseY, int mouseEvent) {
		if (this.isMouseYWithinSlotBounds(mouseY)) {
			int i = this.getSlotIndexFromScreenCoords(mouseX, mouseY);

			if (i >= 0) {
				int j = this.left + this.width / 2 - this.getListWidth() / 2 + 2;
				int k = this.top + 4 - this.getAmountScrolled() + i * this.slotHeight + this.headerPadding;
				int l = mouseX - j;
				int i1 = mouseY - k;

				if (this.getListEntry(i).mousePressed(i, mouseX, mouseY, mouseEvent, l, i1)) {
					this.setEnabled(false);
					return true;
				}
			}
		}

		return false;
	}

	public boolean mouseReleased(int p_148181_1_, int p_148181_2_, int p_148181_3_) {
		for (int i = 0; i < this.getSize(); ++i) {
			int j = this.left + this.width / 2 - this.getListWidth() / 2 + 2;
			int k = this.top + 4 - this.getAmountScrolled() + i * this.slotHeight + this.headerPadding;
			int l = p_148181_1_ - j;
			int i1 = p_148181_2_ - k;
			this.getListEntry(i).mouseReleased(i, p_148181_1_, p_148181_2_, p_148181_3_, l, i1);
		}

		this.setEnabled(true);
		return false;
	}

	/**
	 * Gets the IGuiListEntry object for the given index
	 */
	public abstract GuiListExtended.IGuiListEntry getListEntry(int index);

	public interface IGuiListEntry {
		void func_192633_a(int p_192633_1_, int p_192633_2_, int p_192633_3_, float p_192633_4_);

		void func_192634_a(int p_192634_1_, int p_192634_2_, int p_192634_3_, int p_192634_4_, int p_192634_5_,
				int p_192634_6_, int p_192634_7_, boolean p_192634_8_, float p_192634_9_);

		boolean mousePressed(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY);

		void mouseReleased(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY);
	}
}
