package net.minecraft.client.gui;

import java.io.IOException;

import net.lax1dude.eaglercraft.EagRuntime;
import net.lax1dude.eaglercraft.Mouse;
import net.lax1dude.eaglercraft.minecraft.GuiScreenGenericErrorMessage;
import net.lax1dude.eaglercraft.opengl.GlStateManager;
import net.lax1dude.eaglercraft.cookie.GuiScreenRevokeSessionToken;
import net.lax1dude.eaglercraft.cookie.ServerCookieDataStore;
import net.lax1dude.eaglercraft.internal.EnumCursorType;
import net.lax1dude.eaglercraft.sp.SingleplayerServerController;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;

public class GuiOptions extends GuiScreen {
	private static final GameSettings.Options[] SCREEN_OPTIONS = new GameSettings.Options[] {
			GameSettings.Options.FOV };
	private final GuiScreen lastScreen;

	/** Reference to the GameSettings object. */
	private final GameSettings settings;
	private GuiButton difficultyButton;
	private GuiLockIconButton lockButton;
	protected String title = "Options";

	public GuiOptions(GuiScreen p_i1046_1_, GameSettings p_i1046_2_) {
		this.lastScreen = p_i1046_1_;
		this.settings = p_i1046_2_;
	}

	/**
	 * Adds the buttons (and other controls) to the screen in question. Called when
	 * the GUI is displayed and when the window resizes, the buttonList is cleared
	 * beforehand.
	 */
	public void initGui() {
		this.title = I18n.format("options.title");
		int i = 0;

		for (GameSettings.Options gamesettings$options : SCREEN_OPTIONS) {
			if (gamesettings$options.getEnumFloat()) {
				this.buttonList.add(new GuiOptionSlider(gamesettings$options.returnEnumOrdinal(),
						this.width / 2 - 155 + i % 2 * 160, this.height / 6 - 12 + 24 * (i >> 1),
						gamesettings$options));
			} else {
				GuiOptionButton guioptionbutton = new GuiOptionButton(gamesettings$options.returnEnumOrdinal(),
						this.width / 2 - 155 + i % 2 * 160, this.height / 6 - 12 + 24 * (i >> 1), gamesettings$options,
						this.settings.getKeyBinding(gamesettings$options));
				this.buttonList.add(guioptionbutton);
			}

			++i;

		}

		if (this.mc.world != null) {
			EnumDifficulty enumdifficulty = this.mc.world.getDifficulty();
			this.difficultyButton = new GuiButton(108, this.width / 2 - 155 + i % 2 * 160,
					this.height / 6 - 12 + 24 * (i >> 1), 150, 20, this.getDifficultyText(enumdifficulty));
			this.buttonList.add(this.difficultyButton);

			if (this.mc.isSingleplayer() && !this.mc.world.getWorldInfo().isHardcoreModeEnabled()) {
				this.difficultyButton.setWidth(this.difficultyButton.getButtonWidth() - 20);
				this.lockButton = new GuiLockIconButton(109,
						this.difficultyButton.xPosition + this.difficultyButton.getButtonWidth(),
						this.difficultyButton.yPosition);
				this.buttonList.add(this.lockButton);
				this.lockButton.setLocked(this.mc.world.getWorldInfo().isDifficultyLocked());
				this.lockButton.enabled = !this.lockButton.isLocked();
				this.difficultyButton.enabled = !this.lockButton.isLocked();
			} else {
				this.difficultyButton.enabled = false;
			}
		}

		this.buttonList.add(new GuiButton(110, this.width / 2 - 155, this.height / 6 + 48 - 6, 150, 20,
				I18n.format("options.skinCustomisation")));
		this.buttonList.add(new GuiButton(106, this.width / 2 + 5, this.height / 6 + 48 - 6, 150, 20,
				I18n.format("options.sounds")));
		this.buttonList.add(new GuiButton(101, this.width / 2 - 155, this.height / 6 + 72 - 6, 150, 20,
				I18n.format("options.video")));
		this.buttonList.add(new GuiButton(100, this.width / 2 + 5, this.height / 6 + 72 - 6, 150, 20,
				I18n.format("options.controls")));
		this.buttonList.add(new GuiButton(102, this.width / 2 - 155, this.height / 6 + 96 - 6, 150, 20,
				I18n.format("options.language")));
		this.buttonList.add(new GuiButton(103, this.width / 2 + 5, this.height / 6 + 96 - 6, 150, 20,
				I18n.format("options.chat.title")));
		this.buttonList.add(new GuiButton(105, this.width / 2 - 155, this.height / 6 + 120 - 6, 150, 20,
				I18n.format("options.resourcepack")));
	/*	this.buttonList.add(new GuiButton(300, this.width / 2 + 5, this.height / 6 + 120 - 6, 150, 20,
				I18n.format("options.misc"))); */
		this.buttonList.add(new GuiButton(200, this.width / 2 - 100, this.height / 6 + 168, I18n.format("gui.done")));
	}

	public String getDifficultyText(EnumDifficulty p_175355_1_) {
		ITextComponent itextcomponent = new TextComponentString("");
		itextcomponent.appendSibling(new TextComponentTranslation("options.difficulty", new Object[0]));
		itextcomponent.appendText(": ");
		itextcomponent
				.appendSibling(new TextComponentTranslation(p_175355_1_.getDifficultyResourceKey(), new Object[0]));
		return itextcomponent.getFormattedText();
	}

	public void confirmClicked(boolean result, int id) {
		this.mc.displayGuiScreen(this);

		if (id == 109 && result && this.mc.world != null) {
			this.mc.world.getWorldInfo().setDifficultyLocked(true);
			SingleplayerServerController.setDifficulty(-1);
			this.lockButton.setLocked(true);
			this.lockButton.enabled = false;
			this.difficultyButton.enabled = false;
		}
	}

	/**
	 * Fired when a key is typed (except F11 which toggles full screen). This is the
	 * equivalent of KeyListener.keyTyped(KeyEvent e). Args : character (character
	 * on the key), keyCode (lwjgl Keyboard key code)
	 */
	protected void keyTyped(char typedChar, int keyCode) throws IOException {
		if (keyCode == 1) {
			this.mc.gameSettings.saveOptions();
		}

		super.keyTyped(typedChar, keyCode);
	}

	/**
	 * Called by the controls from the buttonList when activated. (Mouse pressed for
	 * buttons)
	 */
	protected void actionPerformed(GuiButton button) throws IOException {
		if (button.enabled) {
			if (button.id < 100 && button instanceof GuiOptionButton) {
				GameSettings.Options gamesettings$options = ((GuiOptionButton) button).returnEnumOptions();
				this.settings.setOptionValue(gamesettings$options, 1);
				button.displayString = this.settings.getKeyBinding(GameSettings.Options.getEnumOptions(button.id));
			}

			if (button.id == 108) {
				this.mc.world.getWorldInfo().setDifficulty(
						EnumDifficulty.getDifficultyEnum(this.mc.world.getDifficulty().getDifficultyId() + 1));
				SingleplayerServerController
						.setDifficulty(this.mc.world.getWorldInfo().getDifficulty().getDifficultyId());
				this.difficultyButton.displayString = this.getDifficultyText(this.mc.world.getDifficulty());
			}

			if (button.id == 109) {
				this.mc.displayGuiScreen(new GuiYesNo(this,
						(new TextComponentTranslation("difficulty.lock.title", new Object[0])).getFormattedText(),
						(new TextComponentTranslation("difficulty.lock.question",
								new Object[] { new TextComponentTranslation(
										this.mc.world.getWorldInfo().getDifficulty().getDifficultyResourceKey(),
										new Object[0]) }))
								.getFormattedText(),
						109));
			}

			if (button.id == 110) {
				this.mc.gameSettings.saveOptions();
				this.mc.displayGuiScreen(new GuiCustomizeSkin(this));
			}

			if (button.id == 101) {
				this.mc.gameSettings.saveOptions();
				this.mc.displayGuiScreen(new GuiVideoSettings(this, this.settings));
			}

			if (button.id == 100) {
				this.mc.gameSettings.saveOptions();
				this.mc.displayGuiScreen(new GuiControls(this, this.settings));
			}

			if (button.id == 102) {
				this.mc.gameSettings.saveOptions();
				this.mc.displayGuiScreen(new GuiLanguage(this, this.settings, this.mc.getLanguageManager()));
			}

			if (button.id == 103) {
				this.mc.gameSettings.saveOptions();
				this.mc.displayGuiScreen(new ScreenChatOptions(this, this.settings));
			}

			if (button.id == 200) {
				this.mc.gameSettings.saveOptions();
				this.mc.displayGuiScreen(this.lastScreen);
			}

			if (button.id == 105) {
				this.mc.gameSettings.saveOptions();
				this.mc.displayGuiScreen(new GuiScreenResourcePacks(this));
			}

			if (button.id == 106) {
				this.mc.gameSettings.saveOptions();
				this.mc.displayGuiScreen(new GuiScreenOptionsSounds(this, this.settings));
			}
		}
	}

	/**
	 * Draws the screen and all the components in it.
	 */
	public void drawScreen(int mouseX, int mouseY, float partialTicks) {
		this.drawDefaultBackground();
		this.drawCenteredString(this.fontRendererObj, this.title, this.width / 2, 15, 16777215);
		
		if (EagRuntime.getConfiguration().isEnableServerCookies() && mc.player == null) {
			GlStateManager.pushMatrix();
			GlStateManager.scale(0.75f, 0.75f, 0.75f);
			GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);

			String text = I18n.format("revokeSessionToken.button");

			int w = mc.fontRendererObj.getStringWidth(text);
			boolean hover = mouseX > width - 5 - (w + 5) * 3 / 4 && mouseY > 1 && mouseX < width - 2 && mouseY < 12;
			if (hover) {
				Mouse.showCursor(EnumCursorType.HAND);
			}

			drawString(mc.fontRendererObj, TextFormatting.UNDERLINE + text, (width - 1) * 4 / 3 - w - 5, 5,
					hover ? 0xFFEEEE22 : 0xFFCCCCCC);

			GlStateManager.popMatrix();
		}
		
		super.drawScreen(mouseX, mouseY, partialTicks);
	}
	
	protected void mouseClicked(int mx, int my, int button) throws IOException {
		super.mouseClicked(mx, my, button);
		if (EagRuntime.getConfiguration().isEnableServerCookies() && mc.player == null) {
			int w = mc.fontRendererObj.getStringWidth(I18n.format("revokeSessionToken.button"));
			if (mx > width - 5 - (w + 5) * 3 / 4 && my > 1 && mx < width - 2 && my < 12) {
				ServerCookieDataStore.flush();
				mc.displayGuiScreen(ServerCookieDataStore.numRevokable() == 0
						? new GuiScreenGenericErrorMessage("errorNoSessions.title", "errorNoSessions.desc", this)
						: new GuiScreenRevokeSessionToken(this));
				mc.getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("gui.button.press"), 1.0F));
			}
		}
	}
}
