package net.minecraft.client.gui;

import java.io.IOException;

import net.lax1dude.eaglercraft.Keyboard;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.resources.I18n;

public class GuiScreenServerList extends GuiScreen {
	private final GuiScreen lastScreen;
	private final ServerData serverData;
	private GuiTextField ipEdit;

	public GuiScreenServerList(GuiScreen p_i1031_1_, ServerData p_i1031_2_) {
		this.lastScreen = p_i1031_1_;
		this.serverData = p_i1031_2_;
	}

	/**
	 * Called from the main game loop to update the screen.
	 */
	public void updateScreen() {
		this.ipEdit.updateCursorCounter();
	}

	/**
	 * Adds the buttons (and other controls) to the screen in question. Called when
	 * the GUI is displayed and when the window resizes, the buttonList is cleared
	 * beforehand.
	 */
	public void initGui() {
		Keyboard.enableRepeatEvents(true);
		this.buttonList.clear();
		this.buttonList.add(
				new GuiButton(0, this.width / 2 - 100, this.height / 4 + 96 + 12, I18n.format("selectServer.select")));
		this.buttonList
				.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 120 + 12, I18n.format("gui.cancel")));
		this.ipEdit = new GuiTextField(2, this.fontRendererObj, this.width / 2 - 100, 116, 200, 20);
		this.ipEdit.setMaxStringLength(128);
		this.ipEdit.setFocused(true);
		this.ipEdit.setText(this.mc.gameSettings.lastServer);
		(this.buttonList.get(0)).enabled = !this.ipEdit.getText().isEmpty()
				&& this.ipEdit.getText().split(":").length > 0;
	}

	/**
	 * Called when the screen is unloaded. Used to disable keyboard repeat events
	 */
	public void onGuiClosed() {
		Keyboard.enableRepeatEvents(false);
		this.mc.gameSettings.lastServer = this.ipEdit.getText();
		this.mc.gameSettings.saveOptions();
	}

	/**
	 * Called by the controls from the buttonList when activated. (Mouse pressed for
	 * buttons)
	 */
	protected void actionPerformed(GuiButton button) throws IOException {
		if (button.enabled) {
			if (button.id == 1) {
				this.lastScreen.confirmClicked(false, 0);
			} else if (button.id == 0) {
				this.serverData.serverIP = this.ipEdit.getText();
				this.lastScreen.confirmClicked(true, 0);
			}
		}
	}

	/**
	 * Fired when a key is typed (except F11 which toggles full screen). This is the
	 * equivalent of KeyListener.keyTyped(KeyEvent e). Args : character (character
	 * on the key), keyCode (lwjgl Keyboard key code)
	 */
	protected void keyTyped(char typedChar, int keyCode) throws IOException {
		if (this.ipEdit.textboxKeyTyped(typedChar, keyCode)) {
			(this.buttonList.get(0)).enabled = !this.ipEdit.getText().isEmpty()
					&& this.ipEdit.getText().split(":").length > 0;
		} else if (keyCode == 28 || keyCode == 156) {
			this.actionPerformed(this.buttonList.get(0));
		}
	}

	/**
	 * Called when the mouse is clicked. Args : mouseX, mouseY, clickedButton
	 */
	protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
		super.mouseClicked(mouseX, mouseY, mouseButton);
		this.ipEdit.mouseClicked(mouseX, mouseY, mouseButton);
	}

	/**
	 * Draws the screen and all the components in it.
	 */
	public void drawScreen(int mouseX, int mouseY, float partialTicks) {
		this.drawDefaultBackground();
		this.drawCenteredString(this.fontRendererObj, I18n.format("selectServer.direct"), this.width / 2, 20, 16777215);
		this.drawString(this.fontRendererObj, I18n.format("addServer.enterIp"), this.width / 2 - 100, 100, 10526880);
		this.ipEdit.drawTextBox();
		super.drawScreen(mouseX, mouseY, partialTicks);
	}
}
