package net.minecraft.client.particle;

import net.lax1dude.eaglercraft.opengl.WorldRenderer;
import net.lax1dude.eaglercraft.opengl.GlStateManager;
import net.lax1dude.eaglercraft.opengl.RealOpenGLEnums;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ParticleFootStep extends Particle {
	private static final ResourceLocation FOOTPRINT_TEXTURE = new ResourceLocation("textures/particle/footprint.png");
	private int footstepAge;
	private final int footstepMaxAge;
	private final TextureManager currentFootSteps;

	protected ParticleFootStep(TextureManager currentFootStepsIn, World worldIn, double xCoordIn, double yCoordIn,
			double zCoordIn) {
		super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.0D, 0.0D, 0.0D);
		this.currentFootSteps = currentFootStepsIn;
		this.motionX = 0.0D;
		this.motionY = 0.0D;
		this.motionZ = 0.0D;
		this.footstepMaxAge = 200;
	}

	/**
	 * Renders the particle
	 */
	public void renderParticle(WorldRenderer worldRendererIn, Entity entityIn, float partialTicks, float rotationX,
			float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
		float f = ((float) this.footstepAge + partialTicks) / (float) this.footstepMaxAge;
		f = f * f;
		float f1 = 2.0F - f * 2.0F;

		if (f1 > 1.0F) {
			f1 = 1.0F;
		}

		f1 = f1 * 0.2F;
		GlStateManager.disableLighting();
		float f2 = 0.125F;
		float f3 = (float) (this.posX - interpPosX);
		float f4 = (float) (this.posY - interpPosY);
		float f5 = (float) (this.posZ - interpPosZ);
		float f6 = this.worldObj.getLightBrightness(new BlockPos(this.posX, this.posY, this.posZ));
		this.currentFootSteps.bindTexture(FOOTPRINT_TEXTURE);
		GlStateManager.enableBlend();
		GlStateManager.blendFunc(RealOpenGLEnums.GL_SRC_ALPHA, RealOpenGLEnums.GL_ONE_MINUS_SRC_ALPHA);
		worldRendererIn.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR);
		worldRendererIn.pos((double) (f3 - 0.125F), (double) f4, (double) (f5 + 0.125F)).tex(0.0D, 1.0D)
				.color(f6, f6, f6, f1).endVertex();
		worldRendererIn.pos((double) (f3 + 0.125F), (double) f4, (double) (f5 + 0.125F)).tex(1.0D, 1.0D)
				.color(f6, f6, f6, f1).endVertex();
		worldRendererIn.pos((double) (f3 + 0.125F), (double) f4, (double) (f5 - 0.125F)).tex(1.0D, 0.0D)
				.color(f6, f6, f6, f1).endVertex();
		worldRendererIn.pos((double) (f3 - 0.125F), (double) f4, (double) (f5 - 0.125F)).tex(0.0D, 0.0D)
				.color(f6, f6, f6, f1).endVertex();
		Tessellator.getInstance().draw();
		GlStateManager.disableBlend();
		GlStateManager.enableLighting();
	}

	public void onUpdate() {
		++this.footstepAge;

		if (this.footstepAge == this.footstepMaxAge) {
			this.setExpired();
		}
	}

	/**
	 * Retrieve what effect layer (what texture) the particle should be rendered
	 * with. 0 for the particle sprite sheet, 1 for the main Texture atlas, and 3
	 * for a custom texture
	 */
	public int getFXLayer() {
		return 3;
	}

	public static class Factory implements IParticleFactory {
		public Particle createParticle(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn,
				double xSpeedIn, double ySpeedIn, double zSpeedIn, int... p_178902_15_) {
			return new ParticleFootStep(Minecraft.getMinecraft().getTextureManager(), worldIn, xCoordIn, yCoordIn,
					zCoordIn);
		}
	}
}
