package net.minecraft.client.particle;

import net.lax1dude.eaglercraft.EaglercraftRandom;
import net.minecraft.world.World;

public class ParticleSpell extends Particle {
	private static final EaglercraftRandom RANDOM = new EaglercraftRandom();

	/** Base spell texture index */
	private int baseSpellTextureIndex = 128;

	protected ParticleSpell(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double p_i1229_8_,
			double ySpeed, double p_i1229_12_) {
		super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.5D - RANDOM.nextDouble(), ySpeed, 0.5D - RANDOM.nextDouble());
		this.motionY *= 0.20000000298023224D;

		if (p_i1229_8_ == 0.0D && p_i1229_12_ == 0.0D) {
			this.motionX *= 0.10000000149011612D;
			this.motionZ *= 0.10000000149011612D;
		}

		this.particleScale *= 0.75F;
		this.particleMaxAge = (int) (8.0D / (Math.random() * 0.8D + 0.2D));
	}

	public boolean isTransparent() {
		return true;
	}

	public void onUpdate() {
		this.prevPosX = this.posX;
		this.prevPosY = this.posY;
		this.prevPosZ = this.posZ;

		if (this.particleAge++ >= this.particleMaxAge) {
			this.setExpired();
		}

		this.setParticleTextureIndex(this.baseSpellTextureIndex + (7 - this.particleAge * 8 / this.particleMaxAge));
		this.motionY += 0.004D;
		this.moveEntity(this.motionX, this.motionY, this.motionZ);

		if (this.posY == this.prevPosY) {
			this.motionX *= 1.1D;
			this.motionZ *= 1.1D;
		}

		this.motionX *= 0.9599999785423279D;
		this.motionY *= 0.9599999785423279D;
		this.motionZ *= 0.9599999785423279D;

		if (this.isCollided) {
			this.motionX *= 0.699999988079071D;
			this.motionZ *= 0.699999988079071D;
		}
	}

	/**
	 * Sets the base spell texture index
	 */
	public void setBaseSpellTextureIndex(int baseSpellTextureIndexIn) {
		this.baseSpellTextureIndex = baseSpellTextureIndexIn;
	}

	public static class AmbientMobFactory implements IParticleFactory {
		public Particle createParticle(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn,
				double xSpeedIn, double ySpeedIn, double zSpeedIn, int... p_178902_15_) {
			Particle particle = new ParticleSpell(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
			particle.setAlphaF(0.15F);
			particle.setRBGColorF((float) xSpeedIn, (float) ySpeedIn, (float) zSpeedIn);
			return particle;
		}
	}

	public static class Factory implements IParticleFactory {
		public Particle createParticle(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn,
				double xSpeedIn, double ySpeedIn, double zSpeedIn, int... p_178902_15_) {
			return new ParticleSpell(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
		}
	}

	public static class InstantFactory implements IParticleFactory {
		public Particle createParticle(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn,
				double xSpeedIn, double ySpeedIn, double zSpeedIn, int... p_178902_15_) {
			Particle particle = new ParticleSpell(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
			((ParticleSpell) particle).setBaseSpellTextureIndex(144);
			return particle;
		}
	}

	public static class MobFactory implements IParticleFactory {
		public Particle createParticle(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn,
				double xSpeedIn, double ySpeedIn, double zSpeedIn, int... p_178902_15_) {
			Particle particle = new ParticleSpell(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
			particle.setRBGColorF((float) xSpeedIn, (float) ySpeedIn, (float) zSpeedIn);
			return particle;
		}
	}

	public static class WitchFactory implements IParticleFactory {
		public Particle createParticle(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn,
				double xSpeedIn, double ySpeedIn, double zSpeedIn, int... p_178902_15_) {
			Particle particle = new ParticleSpell(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
			((ParticleSpell) particle).setBaseSpellTextureIndex(144);
			float f = worldIn.rand.nextFloat() * 0.5F + 0.35F;
			particle.setRBGColorF(1.0F * f, 0.0F * f, 1.0F * f);
			return particle;
		}
	}
}
