package net.minecraft.client.particle;

import net.lax1dude.eaglercraft.opengl.WorldRenderer;
import net.lax1dude.eaglercraft.opengl.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ParticleSweepAttack extends Particle {
	private static final ResourceLocation SWEEP_TEXTURE = new ResourceLocation("textures/entity/sweep.png");
	private int life;
	private final int lifeTime;
	private final TextureManager textureManager;
	private final float size;

	protected ParticleSweepAttack(TextureManager textureManagerIn, World worldIn, double x, double y, double z,
			double p_i46582_9_, double p_i46582_11_, double p_i46582_13_) {
		super(worldIn, x, y, z, 0.0D, 0.0D, 0.0D);
		this.textureManager = textureManagerIn;
		this.lifeTime = 4;
		float f = this.rand.nextFloat() * 0.6F + 0.4F;
		this.particleRed = f;
		this.particleGreen = f;
		this.particleBlue = f;
		this.size = 1.0F - (float) p_i46582_9_ * 0.5F;
	}

	/**
	 * Renders the particle
	 */
	public void renderParticle(WorldRenderer worldRendererIn, Entity entityIn, float partialTicks, float rotationX,
			float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
		int i = (int) (((float) this.life + partialTicks) * 3.0F / (float) this.lifeTime);

		if (i <= 7) {
			this.textureManager.bindTexture(SWEEP_TEXTURE);
			float f = (float) (i % 4) / 4.0F;
			float f1 = f + 0.24975F;
			float f2 = (float) (i / 2) / 2.0F;
			float f3 = f2 + 0.4995F;
			float f4 = 1.0F * this.size;
			float f5 = (float) (this.prevPosX + (this.posX - this.prevPosX) * (double) partialTicks - interpPosX);
			float f6 = (float) (this.prevPosY + (this.posY - this.prevPosY) * (double) partialTicks - interpPosY);
			float f7 = (float) (this.prevPosZ + (this.posZ - this.prevPosZ) * (double) partialTicks - interpPosZ);
			GlStateManager.color(1.0F, 1.0F, 1.0F, 1.0F);
			GlStateManager.disableLighting();
			RenderHelper.disableStandardItemLighting();
			worldRendererIn.begin(7, DefaultVertexFormats.PARTICLE_POSITION_TEX_COLOR_LMAP);
			worldRendererIn
					.pos((double) (f5 - rotationX * f4 - rotationXY * f4), (double) (f6 - rotationZ * f4 * 0.5F),
							(double) (f7 - rotationYZ * f4 - rotationXZ * f4))
					.tex((double) f1, (double) f3).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0F)
					.lightmap(0, 240).normal(0.0F, 1.0F, 0.0F).endVertex();
			worldRendererIn
					.pos((double) (f5 - rotationX * f4 + rotationXY * f4), (double) (f6 + rotationZ * f4 * 0.5F),
							(double) (f7 - rotationYZ * f4 + rotationXZ * f4))
					.tex((double) f1, (double) f2).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0F)
					.lightmap(0, 240).normal(0.0F, 1.0F, 0.0F).endVertex();
			worldRendererIn
					.pos((double) (f5 + rotationX * f4 + rotationXY * f4), (double) (f6 + rotationZ * f4 * 0.5F),
							(double) (f7 + rotationYZ * f4 + rotationXZ * f4))
					.tex((double) f, (double) f2).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0F)
					.lightmap(0, 240).normal(0.0F, 1.0F, 0.0F).endVertex();
			worldRendererIn
					.pos((double) (f5 + rotationX * f4 - rotationXY * f4), (double) (f6 - rotationZ * f4 * 0.5F),
							(double) (f7 + rotationYZ * f4 - rotationXZ * f4))
					.tex((double) f, (double) f3).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0F)
					.lightmap(0, 240).normal(0.0F, 1.0F, 0.0F).endVertex();
			Tessellator.getInstance().draw();
			GlStateManager.enableLighting();
		}
	}

	public int getBrightnessForRender(float p_189214_1_) {
		return 61680;
	}

	public void onUpdate() {
		this.prevPosX = this.posX;
		this.prevPosY = this.posY;
		this.prevPosZ = this.posZ;
		++this.life;

		if (this.life == this.lifeTime) {
			this.setExpired();
		}
	}

	/**
	 * Retrieve what effect layer (what texture) the particle should be rendered
	 * with. 0 for the particle sprite sheet, 1 for the main Texture atlas, and 3
	 * for a custom texture
	 */
	public int getFXLayer() {
		return 3;
	}

	public static class Factory implements IParticleFactory {
		public Particle createParticle(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn,
				double xSpeedIn, double ySpeedIn, double zSpeedIn, int... p_178902_15_) {
			return new ParticleSweepAttack(Minecraft.getMinecraft().getTextureManager(), worldIn, xCoordIn, yCoordIn,
					zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
		}
	}
}
