package net.minecraft.client.renderer.entity;

import net.lax1dude.eaglercraft.opengl.GlStateManager;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.util.ResourceLocation;

public class RenderCaveSpider extends RenderSpider<EntityCaveSpider> {
	private static final ResourceLocation CAVE_SPIDER_TEXTURES = new ResourceLocation(
			"textures/entity/spider/cave_spider.png");

	public RenderCaveSpider(RenderManager renderManagerIn) {
		super(renderManagerIn);
		this.shadowSize *= 0.7F;
	}

	/**
	 * Allows the render to do state modifications necessary before the model is
	 * rendered.
	 */
	protected void preRenderCallback(EntityCaveSpider entitylivingbaseIn, float partialTickTime) {
		GlStateManager.scale(0.7F, 0.7F, 0.7F);
	}

	/**
	 * Returns the location of an entity's texture. Doesn't seem to be called unless
	 * you call Render.bindEntityTexture.
	 */
	protected ResourceLocation getEntityTexture(EntityCaveSpider entity) {
		return CAVE_SPIDER_TEXTURES;
	}
}
