package net.minecraft.client.renderer.entity;

import net.lax1dude.eaglercraft.opengl.GlStateManager;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.util.ResourceLocation;

public class RenderWitherSkeleton extends RenderSkeleton {
	private static final ResourceLocation WITHER_SKELETON_TEXTURES = new ResourceLocation(
			"textures/entity/skeleton/wither_skeleton.png");

	public RenderWitherSkeleton(RenderManager p_i47188_1_) {
		super(p_i47188_1_);
	}

	/**
	 * Returns the location of an entity's texture. Doesn't seem to be called unless
	 * you call Render.bindEntityTexture.
	 */
	protected ResourceLocation getEntityTexture(AbstractSkeleton entity) {
		return WITHER_SKELETON_TEXTURES;
	}

	/**
	 * Allows the render to do state modifications necessary before the model is
	 * rendered.
	 */
	protected void preRenderCallback(AbstractSkeleton entitylivingbaseIn, float partialTickTime) {
		GlStateManager.scale(1.2F, 1.2F, 1.2F);
	}
}
