package net.minecraft.client.renderer.tileentity;

import net.lax1dude.eaglercraft.opengl.GlStateManager;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public abstract class TileEntitySpecialRenderer<T extends TileEntity> {
	protected static final ResourceLocation[] DESTROY_STAGES = new ResourceLocation[] {
			new ResourceLocation("textures/blocks/destroy_stage_0.png"),
			new ResourceLocation("textures/blocks/destroy_stage_1.png"),
			new ResourceLocation("textures/blocks/destroy_stage_2.png"),
			new ResourceLocation("textures/blocks/destroy_stage_3.png"),
			new ResourceLocation("textures/blocks/destroy_stage_4.png"),
			new ResourceLocation("textures/blocks/destroy_stage_5.png"),
			new ResourceLocation("textures/blocks/destroy_stage_6.png"),
			new ResourceLocation("textures/blocks/destroy_stage_7.png"),
			new ResourceLocation("textures/blocks/destroy_stage_8.png"),
			new ResourceLocation("textures/blocks/destroy_stage_9.png") };
	protected TileEntityRendererDispatcher rendererDispatcher;

	public void func_192841_a(T p_192841_1_, double p_192841_2_, double p_192841_4_, double p_192841_6_,
			float p_192841_8_, int p_192841_9_, float p_192841_10_) {
		ITextComponent itextcomponent = p_192841_1_.getDisplayName();

		if (itextcomponent != null && this.rendererDispatcher.cameraHitResult != null
				&& p_192841_1_.getPos().equals(this.rendererDispatcher.cameraHitResult.getBlockPos())) {
			this.setLightmapDisabled(true);
			this.drawNameplate(p_192841_1_, itextcomponent.getFormattedText(), p_192841_2_, p_192841_4_, p_192841_6_,
					12);
			this.setLightmapDisabled(false);
		}
	}

	/**
	 * Sets whether to use the light map when rendering. Disabling this allows
	 * rendering ignoring lighting, which can be useful for floating text, e.g.
	 */
	protected void setLightmapDisabled(boolean disabled) {
		GlStateManager.setActiveTexture(OpenGlHelper.lightmapTexUnit);

		if (disabled) {
			GlStateManager.disableTexture2D();
		} else {
			GlStateManager.enableTexture2D();
		}

		GlStateManager.setActiveTexture(OpenGlHelper.defaultTexUnit);
	}

	protected void bindTexture(ResourceLocation location) {
		TextureManager texturemanager = this.rendererDispatcher.renderEngine;

		if (texturemanager != null) {
			texturemanager.bindTexture(location);
		}
	}

	protected World getWorld() {
		return this.rendererDispatcher.worldObj;
	}

	public void setRendererDispatcher(TileEntityRendererDispatcher rendererDispatcherIn) {
		this.rendererDispatcher = rendererDispatcherIn;
	}

	public FontRenderer getFontRenderer() {
		return this.rendererDispatcher.getFontRenderer();
	}

	public boolean isGlobalRenderer(T te) {
		return false;
	}

	protected void drawNameplate(T te, String str, double x, double y, double z, int maxDistance) {
		Entity entity = this.rendererDispatcher.entity;
		double d0 = te.getDistanceSq(entity.posX, entity.posY, entity.posZ);

		if (d0 <= (double) (maxDistance * maxDistance)) {
			float f = this.rendererDispatcher.entityYaw;
			float f1 = this.rendererDispatcher.entityPitch;
			boolean flag = false;
			EntityRenderer.drawNameplate(this.getFontRenderer(), str, (float) x + 0.5F, (float) y + 1.5F,
					(float) z + 0.5F, 0, f, f1, false, false);
		}
	}
}
