package net.minecraft.entity.ai;

import net.lax1dude.eaglercraft.EaglercraftRandom;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAIFleeSun extends EntityAIBase {
	private final EntityCreature theCreature;
	private double shelterX;
	private double shelterY;
	private double shelterZ;
	private final double movementSpeed;
	private final World theWorld;

	public EntityAIFleeSun(EntityCreature theCreatureIn, double movementSpeedIn) {
		this.theCreature = theCreatureIn;
		this.movementSpeed = movementSpeedIn;
		this.theWorld = theCreatureIn.world;
		this.setMutexBits(1);
	}

	/**
	 * Returns whether the EntityAIBase should begin execution.
	 */
	public boolean shouldExecute() {
		if (!this.theWorld.isDaytime()) {
			return false;
		} else if (!this.theCreature.isBurning()) {
			return false;
		} else if (!this.theWorld.canSeeSky(new BlockPos(this.theCreature.posX,
				this.theCreature.getEntityBoundingBox().minY, this.theCreature.posZ))) {
			return false;
		} else if (!this.theCreature.getItemStackFromSlot(EntityEquipmentSlot.HEAD).func_190926_b()) {
			return false;
		} else {
			Vec3d vec3d = this.findPossibleShelter();

			if (vec3d == null) {
				return false;
			} else {
				this.shelterX = vec3d.xCoord;
				this.shelterY = vec3d.yCoord;
				this.shelterZ = vec3d.zCoord;
				return true;
			}
		}
	}

	/**
	 * Returns whether an in-progress EntityAIBase should continue executing
	 */
	public boolean continueExecuting() {
		return !this.theCreature.getNavigator().noPath();
	}

	/**
	 * Execute a one shot task or start executing a continuous task
	 */
	public void startExecuting() {
		this.theCreature.getNavigator().tryMoveToXYZ(this.shelterX, this.shelterY, this.shelterZ, this.movementSpeed);
	}

	@Nullable
	private Vec3d findPossibleShelter() {
		EaglercraftRandom random = this.theCreature.getRNG();
		BlockPos blockpos = new BlockPos(this.theCreature.posX, this.theCreature.getEntityBoundingBox().minY,
				this.theCreature.posZ);

		for (int i = 0; i < 10; ++i) {
			BlockPos blockpos1 = blockpos.add(random.nextInt(20) - 10, random.nextInt(6) - 3, random.nextInt(20) - 10);

			if (!this.theWorld.canSeeSky(blockpos1) && this.theCreature.getBlockPathWeight(blockpos1) < 0.0F) {
				return new Vec3d((double) blockpos1.getX(), (double) blockpos1.getY(), (double) blockpos1.getZ());
			}
		}

		return null;
	}
}
