package net.minecraft.entity.ai;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAIPanic extends EntityAIBase {
	protected final EntityCreature theEntityCreature;
	protected double speed;
	protected double randPosX;
	protected double randPosY;
	protected double randPosZ;

	public EntityAIPanic(EntityCreature creature, double speedIn) {
		this.theEntityCreature = creature;
		this.speed = speedIn;
		this.setMutexBits(1);
	}

	/**
	 * Returns whether the EntityAIBase should begin execution.
	 */
	public boolean shouldExecute() {
		if (this.theEntityCreature.getAITarget() == null && !this.theEntityCreature.isBurning()) {
			return false;
		} else {
			if (this.theEntityCreature.isBurning()) {
				BlockPos blockpos = this.getRandPos(this.theEntityCreature.world, this.theEntityCreature, 5, 4);

				if (blockpos != null) {
					this.randPosX = (double) blockpos.getX();
					this.randPosY = (double) blockpos.getY();
					this.randPosZ = (double) blockpos.getZ();
					return true;
				}
			}

			return this.func_190863_f();
		}
	}

	protected boolean func_190863_f() {
		Vec3d vec3d = RandomPositionGenerator.findRandomTarget(this.theEntityCreature, 5, 4);

		if (vec3d == null) {
			return false;
		} else {
			this.randPosX = vec3d.xCoord;
			this.randPosY = vec3d.yCoord;
			this.randPosZ = vec3d.zCoord;
			return true;
		}
	}

	/**
	 * Execute a one shot task or start executing a continuous task
	 */
	public void startExecuting() {
		this.theEntityCreature.getNavigator().tryMoveToXYZ(this.randPosX, this.randPosY, this.randPosZ, this.speed);
	}

	/**
	 * Returns whether an in-progress EntityAIBase should continue executing
	 */
	public boolean continueExecuting() {
		return !this.theEntityCreature.getNavigator().noPath();
	}

	@Nullable
	private BlockPos getRandPos(World worldIn, Entity entityIn, int horizontalRange, int verticalRange) {
		BlockPos blockpos = new BlockPos(entityIn);
		int i = blockpos.getX();
		int j = blockpos.getY();
		int k = blockpos.getZ();
		float f = (float) (horizontalRange * horizontalRange * verticalRange * 2);
		BlockPos blockpos1 = null;
		BlockPos blockpos$mutableblockpos = new BlockPos();

		for (int l = i - horizontalRange; l <= i + horizontalRange; ++l) {
			for (int i1 = j - verticalRange; i1 <= j + verticalRange; ++i1) {
				for (int j1 = k - horizontalRange; j1 <= k + horizontalRange; ++j1) {
					blockpos$mutableblockpos.setPos(l, i1, j1);
					IBlockState iblockstate = worldIn.getBlockState(blockpos$mutableblockpos);

					if (iblockstate.getMaterial() == Material.WATER) {
						float f1 = (float) ((l - i) * (l - i) + (i1 - j) * (i1 - j) + (j1 - k) * (j1 - k));

						if (f1 < f) {
							f = f1;
							blockpos1 = new BlockPos(blockpos$mutableblockpos);
						}
					}
				}
			}
		}

		return blockpos1;
	}
}
