package net.minecraft.init;

import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemArmorStand;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemEmptyMap;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemShears;
import net.minecraft.util.ResourceLocation;

public class Items {
	public static final Item AIR;
	public static final Item IRON_SHOVEL;
	public static final Item IRON_PICKAXE;
	public static final Item IRON_AXE;
	public static final Item FLINT_AND_STEEL;
	public static final Item APPLE;
	public static final ItemBow BOW;
	public static final Item ARROW;
	public static final Item SPECTRAL_ARROW;
	public static final Item TIPPED_ARROW;
	public static final Item COAL;
	public static final Item DIAMOND;
	public static final Item IRON_INGOT;
	public static final Item GOLD_INGOT;
	public static final Item IRON_SWORD;
	public static final Item WOODEN_SWORD;
	public static final Item WOODEN_SHOVEL;
	public static final Item WOODEN_PICKAXE;
	public static final Item WOODEN_AXE;
	public static final Item STONE_SWORD;
	public static final Item STONE_SHOVEL;
	public static final Item STONE_PICKAXE;
	public static final Item STONE_AXE;
	public static final Item DIAMOND_SWORD;
	public static final Item DIAMOND_SHOVEL;
	public static final Item DIAMOND_PICKAXE;
	public static final Item DIAMOND_AXE;
	public static final Item STICK;
	public static final Item BOWL;
	public static final Item MUSHROOM_STEW;
	public static final Item GOLDEN_SWORD;
	public static final Item GOLDEN_SHOVEL;
	public static final Item GOLDEN_PICKAXE;
	public static final Item GOLDEN_AXE;
	public static final Item STRING;
	public static final Item FEATHER;
	public static final Item GUNPOWDER;
	public static final Item WOODEN_HOE;
	public static final Item STONE_HOE;
	public static final Item IRON_HOE;
	public static final Item DIAMOND_HOE;
	public static final Item GOLDEN_HOE;
	public static final Item WHEAT_SEEDS;
	public static final Item WHEAT;
	public static final Item BREAD;
	public static final ItemArmor LEATHER_HELMET;
	public static final ItemArmor LEATHER_CHESTPLATE;
	public static final ItemArmor LEATHER_LEGGINGS;
	public static final ItemArmor LEATHER_BOOTS;
	public static final ItemArmor CHAINMAIL_HELMET;
	public static final ItemArmor CHAINMAIL_CHESTPLATE;
	public static final ItemArmor CHAINMAIL_LEGGINGS;
	public static final ItemArmor CHAINMAIL_BOOTS;
	public static final ItemArmor IRON_HELMET;
	public static final ItemArmor IRON_CHESTPLATE;
	public static final ItemArmor IRON_LEGGINGS;
	public static final ItemArmor IRON_BOOTS;
	public static final ItemArmor DIAMOND_HELMET;
	public static final ItemArmor DIAMOND_CHESTPLATE;
	public static final ItemArmor DIAMOND_LEGGINGS;
	public static final ItemArmor DIAMOND_BOOTS;
	public static final ItemArmor GOLDEN_HELMET;
	public static final ItemArmor GOLDEN_CHESTPLATE;
	public static final ItemArmor GOLDEN_LEGGINGS;
	public static final ItemArmor GOLDEN_BOOTS;
	public static final Item FLINT;
	public static final Item PORKCHOP;
	public static final Item COOKED_PORKCHOP;
	public static final Item PAINTING;
	public static final Item GOLDEN_APPLE;
	public static final Item SIGN;
	public static final Item OAK_DOOR;
	public static final Item SPRUCE_DOOR;
	public static final Item BIRCH_DOOR;
	public static final Item JUNGLE_DOOR;
	public static final Item ACACIA_DOOR;
	public static final Item DARK_OAK_DOOR;
	public static final Item BUCKET;
	public static final Item WATER_BUCKET;
	public static final Item LAVA_BUCKET;
	public static final Item MINECART;
	public static final Item SADDLE;
	public static final Item IRON_DOOR;
	public static final Item REDSTONE;
	public static final Item SNOWBALL;
	public static final Item BOAT;
	public static final Item SPRUCE_BOAT;
	public static final Item BIRCH_BOAT;
	public static final Item JUNGLE_BOAT;
	public static final Item ACACIA_BOAT;
	public static final Item DARK_OAK_BOAT;
	public static final Item LEATHER;
	public static final Item MILK_BUCKET;
	public static final Item BRICK;
	public static final Item CLAY_BALL;
	public static final Item REEDS;
	public static final Item PAPER;
	public static final Item BOOK;
	public static final Item SLIME_BALL;
	public static final Item CHEST_MINECART;
	public static final Item FURNACE_MINECART;
	public static final Item EGG;
	public static final Item COMPASS;
	public static final ItemFishingRod FISHING_ROD;
	public static final Item CLOCK;
	public static final Item GLOWSTONE_DUST;
	public static final Item FISH;
	public static final Item COOKED_FISH;
	public static final Item DYE;
	public static final Item BONE;
	public static final Item SUGAR;
	public static final Item CAKE;
	public static final Item BED;
	public static final Item REPEATER;
	public static final Item COOKIE;
	public static final ItemMap FILLED_MAP;
	public static final ItemShears SHEARS;
	public static final Item MELON;
	public static final Item PUMPKIN_SEEDS;
	public static final Item MELON_SEEDS;
	public static final Item BEEF;
	public static final Item COOKED_BEEF;
	public static final Item CHICKEN;
	public static final Item COOKED_CHICKEN;
	public static final Item MUTTON;
	public static final Item COOKED_MUTTON;
	public static final Item RABBIT;
	public static final Item COOKED_RABBIT;
	public static final Item RABBIT_STEW;
	public static final Item RABBIT_FOOT;
	public static final Item RABBIT_HIDE;
	public static final Item ROTTEN_FLESH;
	public static final Item ENDER_PEARL;
	public static final Item BLAZE_ROD;
	public static final Item GHAST_TEAR;
	public static final Item GOLD_NUGGET;
	public static final Item NETHER_WART;
	public static final ItemPotion POTIONITEM;
	public static final ItemPotion SPLASH_POTION;
	public static final ItemPotion LINGERING_POTION;
	public static final Item GLASS_BOTTLE;
	public static final Item DRAGON_BREATH;
	public static final Item SPIDER_EYE;
	public static final Item FERMENTED_SPIDER_EYE;
	public static final Item BLAZE_POWDER;
	public static final Item MAGMA_CREAM;
	public static final Item BREWING_STAND;
	public static final Item CAULDRON;
	public static final Item ENDER_EYE;
	public static final Item SPECKLED_MELON;
	public static final Item SPAWN_EGG;
	public static final Item EXPERIENCE_BOTTLE;
	public static final Item FIRE_CHARGE;
	public static final Item WRITABLE_BOOK;
	public static final Item WRITTEN_BOOK;
	public static final Item EMERALD;
	public static final Item ITEM_FRAME;
	public static final Item FLOWER_POT;
	public static final Item CARROT;
	public static final Item POTATO;
	public static final Item BAKED_POTATO;
	public static final Item POISONOUS_POTATO;
	public static final ItemEmptyMap MAP;
	public static final Item GOLDEN_CARROT;
	public static final Item SKULL;
	public static final Item CARROT_ON_A_STICK;
	public static final Item NETHER_STAR;
	public static final Item PUMPKIN_PIE;
	public static final Item FIREWORKS;
	public static final Item FIREWORK_CHARGE;
	public static final Item ENCHANTED_BOOK;
	public static final Item COMPARATOR;
	public static final Item NETHERBRICK;
	public static final Item QUARTZ;
	public static final Item TNT_MINECART;
	public static final Item HOPPER_MINECART;
	public static final ItemArmorStand ARMOR_STAND;
	public static final Item IRON_HORSE_ARMOR;
	public static final Item GOLDEN_HORSE_ARMOR;
	public static final Item DIAMOND_HORSE_ARMOR;
	public static final Item LEAD;
	public static final Item NAME_TAG;
	public static final Item COMMAND_BLOCK_MINECART;
	public static final Item RECORD_13;
	public static final Item RECORD_CAT;
	public static final Item RECORD_BLOCKS;
	public static final Item RECORD_CHIRP;
	public static final Item RECORD_FAR;
	public static final Item RECORD_MALL;
	public static final Item RECORD_MELLOHI;
	public static final Item RECORD_STAL;
	public static final Item RECORD_STRAD;
	public static final Item RECORD_WARD;
	public static final Item RECORD_11;
	public static final Item RECORD_WAIT;
	public static final Item PRISMARINE_SHARD;
	public static final Item PRISMARINE_CRYSTALS;
	public static final Item BANNER;
	public static final Item END_CRYSTAL;
	public static final Item SHIELD;
	public static final Item ELYTRA;
	public static final Item CHORUS_FRUIT;
	public static final Item CHORUS_FRUIT_POPPED;
	public static final Item BEETROOT_SEEDS;
	public static final Item BEETROOT;
	public static final Item BEETROOT_SOUP;
	public static final Item TOTEM_OF_UNDYING;
	public static final Item SHULKER_SHELL;
	public static final Item IRON_NUGGET;
	public static final Item KNOWLEDGE_BOOK;

	private static Item getRegisteredItem(String name) {
		Item item = Item.REGISTRY.getObject(new ResourceLocation(name));

		if (item == null) {
			throw new IllegalStateException("Invalid Item requested: " + name);
		} else {
			return item;
		}
	}

	static {
		if (!Bootstrap.isRegistered()) {
			throw new RuntimeException("Accessed Items before Bootstrap!");
		} else {
			AIR = getRegisteredItem("air");
			IRON_SHOVEL = getRegisteredItem("iron_shovel");
			IRON_PICKAXE = getRegisteredItem("iron_pickaxe");
			IRON_AXE = getRegisteredItem("iron_axe");
			FLINT_AND_STEEL = getRegisteredItem("flint_and_steel");
			APPLE = getRegisteredItem("apple");
			BOW = (ItemBow) getRegisteredItem("bow");
			ARROW = getRegisteredItem("arrow");
			SPECTRAL_ARROW = getRegisteredItem("spectral_arrow");
			TIPPED_ARROW = getRegisteredItem("tipped_arrow");
			COAL = getRegisteredItem("coal");
			DIAMOND = getRegisteredItem("diamond");
			IRON_INGOT = getRegisteredItem("iron_ingot");
			GOLD_INGOT = getRegisteredItem("gold_ingot");
			IRON_SWORD = getRegisteredItem("iron_sword");
			WOODEN_SWORD = getRegisteredItem("wooden_sword");
			WOODEN_SHOVEL = getRegisteredItem("wooden_shovel");
			WOODEN_PICKAXE = getRegisteredItem("wooden_pickaxe");
			WOODEN_AXE = getRegisteredItem("wooden_axe");
			STONE_SWORD = getRegisteredItem("stone_sword");
			STONE_SHOVEL = getRegisteredItem("stone_shovel");
			STONE_PICKAXE = getRegisteredItem("stone_pickaxe");
			STONE_AXE = getRegisteredItem("stone_axe");
			DIAMOND_SWORD = getRegisteredItem("diamond_sword");
			DIAMOND_SHOVEL = getRegisteredItem("diamond_shovel");
			DIAMOND_PICKAXE = getRegisteredItem("diamond_pickaxe");
			DIAMOND_AXE = getRegisteredItem("diamond_axe");
			STICK = getRegisteredItem("stick");
			BOWL = getRegisteredItem("bowl");
			MUSHROOM_STEW = getRegisteredItem("mushroom_stew");
			GOLDEN_SWORD = getRegisteredItem("golden_sword");
			GOLDEN_SHOVEL = getRegisteredItem("golden_shovel");
			GOLDEN_PICKAXE = getRegisteredItem("golden_pickaxe");
			GOLDEN_AXE = getRegisteredItem("golden_axe");
			STRING = getRegisteredItem("string");
			FEATHER = getRegisteredItem("feather");
			GUNPOWDER = getRegisteredItem("gunpowder");
			WOODEN_HOE = getRegisteredItem("wooden_hoe");
			STONE_HOE = getRegisteredItem("stone_hoe");
			IRON_HOE = getRegisteredItem("iron_hoe");
			DIAMOND_HOE = getRegisteredItem("diamond_hoe");
			GOLDEN_HOE = getRegisteredItem("golden_hoe");
			WHEAT_SEEDS = getRegisteredItem("wheat_seeds");
			WHEAT = getRegisteredItem("wheat");
			BREAD = getRegisteredItem("bread");
			LEATHER_HELMET = (ItemArmor) getRegisteredItem("leather_helmet");
			LEATHER_CHESTPLATE = (ItemArmor) getRegisteredItem("leather_chestplate");
			LEATHER_LEGGINGS = (ItemArmor) getRegisteredItem("leather_leggings");
			LEATHER_BOOTS = (ItemArmor) getRegisteredItem("leather_boots");
			CHAINMAIL_HELMET = (ItemArmor) getRegisteredItem("chainmail_helmet");
			CHAINMAIL_CHESTPLATE = (ItemArmor) getRegisteredItem("chainmail_chestplate");
			CHAINMAIL_LEGGINGS = (ItemArmor) getRegisteredItem("chainmail_leggings");
			CHAINMAIL_BOOTS = (ItemArmor) getRegisteredItem("chainmail_boots");
			IRON_HELMET = (ItemArmor) getRegisteredItem("iron_helmet");
			IRON_CHESTPLATE = (ItemArmor) getRegisteredItem("iron_chestplate");
			IRON_LEGGINGS = (ItemArmor) getRegisteredItem("iron_leggings");
			IRON_BOOTS = (ItemArmor) getRegisteredItem("iron_boots");
			DIAMOND_HELMET = (ItemArmor) getRegisteredItem("diamond_helmet");
			DIAMOND_CHESTPLATE = (ItemArmor) getRegisteredItem("diamond_chestplate");
			DIAMOND_LEGGINGS = (ItemArmor) getRegisteredItem("diamond_leggings");
			DIAMOND_BOOTS = (ItemArmor) getRegisteredItem("diamond_boots");
			GOLDEN_HELMET = (ItemArmor) getRegisteredItem("golden_helmet");
			GOLDEN_CHESTPLATE = (ItemArmor) getRegisteredItem("golden_chestplate");
			GOLDEN_LEGGINGS = (ItemArmor) getRegisteredItem("golden_leggings");
			GOLDEN_BOOTS = (ItemArmor) getRegisteredItem("golden_boots");
			FLINT = getRegisteredItem("flint");
			PORKCHOP = getRegisteredItem("porkchop");
			COOKED_PORKCHOP = getRegisteredItem("cooked_porkchop");
			PAINTING = getRegisteredItem("painting");
			GOLDEN_APPLE = getRegisteredItem("golden_apple");
			SIGN = getRegisteredItem("sign");
			OAK_DOOR = getRegisteredItem("wooden_door");
			SPRUCE_DOOR = getRegisteredItem("spruce_door");
			BIRCH_DOOR = getRegisteredItem("birch_door");
			JUNGLE_DOOR = getRegisteredItem("jungle_door");
			ACACIA_DOOR = getRegisteredItem("acacia_door");
			DARK_OAK_DOOR = getRegisteredItem("dark_oak_door");
			BUCKET = getRegisteredItem("bucket");
			WATER_BUCKET = getRegisteredItem("water_bucket");
			LAVA_BUCKET = getRegisteredItem("lava_bucket");
			MINECART = getRegisteredItem("minecart");
			SADDLE = getRegisteredItem("saddle");
			IRON_DOOR = getRegisteredItem("iron_door");
			REDSTONE = getRegisteredItem("redstone");
			SNOWBALL = getRegisteredItem("snowball");
			BOAT = getRegisteredItem("boat");
			SPRUCE_BOAT = getRegisteredItem("spruce_boat");
			BIRCH_BOAT = getRegisteredItem("birch_boat");
			JUNGLE_BOAT = getRegisteredItem("jungle_boat");
			ACACIA_BOAT = getRegisteredItem("acacia_boat");
			DARK_OAK_BOAT = getRegisteredItem("dark_oak_boat");
			LEATHER = getRegisteredItem("leather");
			MILK_BUCKET = getRegisteredItem("milk_bucket");
			BRICK = getRegisteredItem("brick");
			CLAY_BALL = getRegisteredItem("clay_ball");
			REEDS = getRegisteredItem("reeds");
			PAPER = getRegisteredItem("paper");
			BOOK = getRegisteredItem("book");
			SLIME_BALL = getRegisteredItem("slime_ball");
			CHEST_MINECART = getRegisteredItem("chest_minecart");
			FURNACE_MINECART = getRegisteredItem("furnace_minecart");
			EGG = getRegisteredItem("egg");
			COMPASS = getRegisteredItem("compass");
			FISHING_ROD = (ItemFishingRod) getRegisteredItem("fishing_rod");
			CLOCK = getRegisteredItem("clock");
			GLOWSTONE_DUST = getRegisteredItem("glowstone_dust");
			FISH = getRegisteredItem("fish");
			COOKED_FISH = getRegisteredItem("cooked_fish");
			DYE = getRegisteredItem("dye");
			BONE = getRegisteredItem("bone");
			SUGAR = getRegisteredItem("sugar");
			CAKE = getRegisteredItem("cake");
			BED = getRegisteredItem("bed");
			REPEATER = getRegisteredItem("repeater");
			COOKIE = getRegisteredItem("cookie");
			FILLED_MAP = (ItemMap) getRegisteredItem("filled_map");
			SHEARS = (ItemShears) getRegisteredItem("shears");
			MELON = getRegisteredItem("melon");
			PUMPKIN_SEEDS = getRegisteredItem("pumpkin_seeds");
			MELON_SEEDS = getRegisteredItem("melon_seeds");
			BEEF = getRegisteredItem("beef");
			COOKED_BEEF = getRegisteredItem("cooked_beef");
			CHICKEN = getRegisteredItem("chicken");
			COOKED_CHICKEN = getRegisteredItem("cooked_chicken");
			MUTTON = getRegisteredItem("mutton");
			COOKED_MUTTON = getRegisteredItem("cooked_mutton");
			RABBIT = getRegisteredItem("rabbit");
			COOKED_RABBIT = getRegisteredItem("cooked_rabbit");
			RABBIT_STEW = getRegisteredItem("rabbit_stew");
			RABBIT_FOOT = getRegisteredItem("rabbit_foot");
			RABBIT_HIDE = getRegisteredItem("rabbit_hide");
			ROTTEN_FLESH = getRegisteredItem("rotten_flesh");
			ENDER_PEARL = getRegisteredItem("ender_pearl");
			BLAZE_ROD = getRegisteredItem("blaze_rod");
			GHAST_TEAR = getRegisteredItem("ghast_tear");
			GOLD_NUGGET = getRegisteredItem("gold_nugget");
			NETHER_WART = getRegisteredItem("nether_wart");
			POTIONITEM = (ItemPotion) getRegisteredItem("potion");
			SPLASH_POTION = (ItemPotion) getRegisteredItem("splash_potion");
			LINGERING_POTION = (ItemPotion) getRegisteredItem("lingering_potion");
			GLASS_BOTTLE = getRegisteredItem("glass_bottle");
			DRAGON_BREATH = getRegisteredItem("dragon_breath");
			SPIDER_EYE = getRegisteredItem("spider_eye");
			FERMENTED_SPIDER_EYE = getRegisteredItem("fermented_spider_eye");
			BLAZE_POWDER = getRegisteredItem("blaze_powder");
			MAGMA_CREAM = getRegisteredItem("magma_cream");
			BREWING_STAND = getRegisteredItem("brewing_stand");
			CAULDRON = getRegisteredItem("cauldron");
			ENDER_EYE = getRegisteredItem("ender_eye");
			SPECKLED_MELON = getRegisteredItem("speckled_melon");
			SPAWN_EGG = getRegisteredItem("spawn_egg");
			EXPERIENCE_BOTTLE = getRegisteredItem("experience_bottle");
			FIRE_CHARGE = getRegisteredItem("fire_charge");
			WRITABLE_BOOK = getRegisteredItem("writable_book");
			WRITTEN_BOOK = getRegisteredItem("written_book");
			EMERALD = getRegisteredItem("emerald");
			ITEM_FRAME = getRegisteredItem("item_frame");
			FLOWER_POT = getRegisteredItem("flower_pot");
			CARROT = getRegisteredItem("carrot");
			POTATO = getRegisteredItem("potato");
			BAKED_POTATO = getRegisteredItem("baked_potato");
			POISONOUS_POTATO = getRegisteredItem("poisonous_potato");
			MAP = (ItemEmptyMap) getRegisteredItem("map");
			GOLDEN_CARROT = getRegisteredItem("golden_carrot");
			SKULL = getRegisteredItem("skull");
			CARROT_ON_A_STICK = getRegisteredItem("carrot_on_a_stick");
			NETHER_STAR = getRegisteredItem("nether_star");
			PUMPKIN_PIE = getRegisteredItem("pumpkin_pie");
			FIREWORKS = getRegisteredItem("fireworks");
			FIREWORK_CHARGE = getRegisteredItem("firework_charge");
			ENCHANTED_BOOK = getRegisteredItem("enchanted_book");
			COMPARATOR = getRegisteredItem("comparator");
			NETHERBRICK = getRegisteredItem("netherbrick");
			QUARTZ = getRegisteredItem("quartz");
			TNT_MINECART = getRegisteredItem("tnt_minecart");
			HOPPER_MINECART = getRegisteredItem("hopper_minecart");
			ARMOR_STAND = (ItemArmorStand) getRegisteredItem("armor_stand");
			IRON_HORSE_ARMOR = getRegisteredItem("iron_horse_armor");
			GOLDEN_HORSE_ARMOR = getRegisteredItem("golden_horse_armor");
			DIAMOND_HORSE_ARMOR = getRegisteredItem("diamond_horse_armor");
			LEAD = getRegisteredItem("lead");
			NAME_TAG = getRegisteredItem("name_tag");
			COMMAND_BLOCK_MINECART = getRegisteredItem("command_block_minecart");
			RECORD_13 = getRegisteredItem("record_13");
			RECORD_CAT = getRegisteredItem("record_cat");
			RECORD_BLOCKS = getRegisteredItem("record_blocks");
			RECORD_CHIRP = getRegisteredItem("record_chirp");
			RECORD_FAR = getRegisteredItem("record_far");
			RECORD_MALL = getRegisteredItem("record_mall");
			RECORD_MELLOHI = getRegisteredItem("record_mellohi");
			RECORD_STAL = getRegisteredItem("record_stal");
			RECORD_STRAD = getRegisteredItem("record_strad");
			RECORD_WARD = getRegisteredItem("record_ward");
			RECORD_11 = getRegisteredItem("record_11");
			RECORD_WAIT = getRegisteredItem("record_wait");
			PRISMARINE_SHARD = getRegisteredItem("prismarine_shard");
			PRISMARINE_CRYSTALS = getRegisteredItem("prismarine_crystals");
			BANNER = getRegisteredItem("banner");
			END_CRYSTAL = getRegisteredItem("end_crystal");
			SHIELD = getRegisteredItem("shield");
			ELYTRA = getRegisteredItem("elytra");
			CHORUS_FRUIT = getRegisteredItem("chorus_fruit");
			CHORUS_FRUIT_POPPED = getRegisteredItem("chorus_fruit_popped");
			BEETROOT_SEEDS = getRegisteredItem("beetroot_seeds");
			BEETROOT = getRegisteredItem("beetroot");
			BEETROOT_SOUP = getRegisteredItem("beetroot_soup");
			TOTEM_OF_UNDYING = getRegisteredItem("totem_of_undying");
			SHULKER_SHELL = getRegisteredItem("shulker_shell");
			IRON_NUGGET = getRegisteredItem("iron_nugget");
			KNOWLEDGE_BOOK = getRegisteredItem("knowledge_book");
		}
	}
}
