package net.minecraft.init;

import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public class SoundEvents {
	public static final SoundEvent AMBIENT_CAVE;
	public static final SoundEvent BLOCK_ANVIL_BREAK;
	public static final SoundEvent BLOCK_ANVIL_DESTROY;
	public static final SoundEvent BLOCK_ANVIL_FALL;
	public static final SoundEvent BLOCK_ANVIL_HIT;
	public static final SoundEvent BLOCK_ANVIL_LAND;
	public static final SoundEvent BLOCK_ANVIL_PLACE;
	public static final SoundEvent BLOCK_ANVIL_STEP;
	public static final SoundEvent BLOCK_ANVIL_USE;
	public static final SoundEvent ENTITY_ARMORSTAND_BREAK;
	public static final SoundEvent ENTITY_ARMORSTAND_FALL;
	public static final SoundEvent ENTITY_ARMORSTAND_HIT;
	public static final SoundEvent ENTITY_ARMORSTAND_PLACE;
	public static final SoundEvent ITEM_ARMOR_EQUIP_CHAIN;
	public static final SoundEvent ITEM_ARMOR_EQUIP_DIAMOND;
	public static final SoundEvent ITEM_ARMOR_EQUIP_ELYTRA;
	public static final SoundEvent ITEM_ARMOR_EQUIP_GENERIC;
	public static final SoundEvent ITEM_ARMOR_EQUIP_GOLD;
	public static final SoundEvent ITEM_ARMOR_EQUIP_IRON;
	public static final SoundEvent ITEM_ARMOR_EQUIP_LEATHER;
	public static final SoundEvent ENTITY_ARROW_HIT;
	public static final SoundEvent ENTITY_ARROW_HIT_PLAYER;
	public static final SoundEvent ENTITY_ARROW_SHOOT;
	public static final SoundEvent ENTITY_BAT_AMBIENT;
	public static final SoundEvent ENTITY_BAT_DEATH;
	public static final SoundEvent ENTITY_BAT_HURT;
	public static final SoundEvent ENTITY_BAT_LOOP;
	public static final SoundEvent ENTITY_BAT_TAKEOFF;
	public static final SoundEvent ENTITY_BLAZE_AMBIENT;
	public static final SoundEvent ENTITY_BLAZE_BURN;
	public static final SoundEvent ENTITY_BLAZE_DEATH;
	public static final SoundEvent ENTITY_BLAZE_HURT;
	public static final SoundEvent ENTITY_BLAZE_SHOOT;
	public static final SoundEvent ENTITY_BOAT_PADDLE_LAND;
	public static final SoundEvent ENTITY_BOAT_PADDLE_WATER;
	public static final SoundEvent ENTITY_BOBBER_RETRIEVE;
	public static final SoundEvent ENTITY_BOBBER_SPLASH;
	public static final SoundEvent ENTITY_BOBBER_THROW;
	public static final SoundEvent ITEM_BOTTLE_EMPTY;
	public static final SoundEvent ITEM_BOTTLE_FILL;
	public static final SoundEvent ITEM_BOTTLE_FILL_DRAGONBREATH;
	public static final SoundEvent BLOCK_BREWING_STAND_BREW;
	public static final SoundEvent ITEM_BUCKET_EMPTY;
	public static final SoundEvent ITEM_BUCKET_EMPTY_LAVA;
	public static final SoundEvent ITEM_BUCKET_FILL;
	public static final SoundEvent ITEM_BUCKET_FILL_LAVA;
	public static final SoundEvent ENTITY_CAT_AMBIENT;
	public static final SoundEvent ENTITY_CAT_DEATH;
	public static final SoundEvent ENTITY_CAT_HISS;
	public static final SoundEvent ENTITY_CAT_HURT;
	public static final SoundEvent ENTITY_CAT_PURR;
	public static final SoundEvent ENTITY_CAT_PURREOW;
	public static final SoundEvent BLOCK_CHEST_CLOSE;
	public static final SoundEvent BLOCK_CHEST_LOCKED;
	public static final SoundEvent BLOCK_CHEST_OPEN;
	public static final SoundEvent ENTITY_CHICKEN_AMBIENT;
	public static final SoundEvent ENTITY_CHICKEN_DEATH;
	public static final SoundEvent ENTITY_CHICKEN_EGG;
	public static final SoundEvent ENTITY_CHICKEN_HURT;
	public static final SoundEvent ENTITY_CHICKEN_STEP;
	public static final SoundEvent BLOCK_CHORUS_FLOWER_DEATH;
	public static final SoundEvent BLOCK_CHORUS_FLOWER_GROW;
	public static final SoundEvent ITEM_CHORUS_FRUIT_TELEPORT;
	public static final SoundEvent BLOCK_CLOTH_BREAK;
	public static final SoundEvent BLOCK_CLOTH_FALL;
	public static final SoundEvent BLOCK_CLOTH_HIT;
	public static final SoundEvent BLOCK_CLOTH_PLACE;
	public static final SoundEvent BLOCK_CLOTH_STEP;
	public static final SoundEvent BLOCK_COMPARATOR_CLICK;
	public static final SoundEvent ENTITY_COW_AMBIENT;
	public static final SoundEvent ENTITY_COW_DEATH;
	public static final SoundEvent ENTITY_COW_HURT;
	public static final SoundEvent ENTITY_COW_MILK;
	public static final SoundEvent ENTITY_COW_STEP;
	public static final SoundEvent ENTITY_CREEPER_DEATH;
	public static final SoundEvent ENTITY_CREEPER_HURT;
	public static final SoundEvent ENTITY_CREEPER_PRIMED;
	public static final SoundEvent BLOCK_DISPENSER_DISPENSE;
	public static final SoundEvent BLOCK_DISPENSER_FAIL;
	public static final SoundEvent BLOCK_DISPENSER_LAUNCH;
	public static final SoundEvent ENTITY_DONKEY_AMBIENT;
	public static final SoundEvent ENTITY_DONKEY_ANGRY;
	public static final SoundEvent ENTITY_DONKEY_CHEST;
	public static final SoundEvent ENTITY_DONKEY_DEATH;
	public static final SoundEvent ENTITY_DONKEY_HURT;
	public static final SoundEvent ENTITY_EGG_THROW;
	public static final SoundEvent ENTITY_ELDER_GUARDIAN_AMBIENT;
	public static final SoundEvent ENTITY_ELDERGUARDIAN_AMBIENTLAND;
	public static final SoundEvent ENTITY_ELDER_GUARDIAN_CURSE;
	public static final SoundEvent ENTITY_ELDER_GUARDIAN_DEATH;
	public static final SoundEvent ENTITY_ELDER_GUARDIAN_DEATH_LAND;
	public static final SoundEvent ENTITY_ELDER_GUARDIAN_FLOP;
	public static final SoundEvent ENTITY_ELDER_GUARDIAN_HURT;
	public static final SoundEvent ENTITY_ELDER_GUARDIAN_HURT_LAND;
	public static final SoundEvent ITEM_ELYTRA_FLYING;
	public static final SoundEvent BLOCK_ENCHANTMENT_TABLE_USE;
	public static final SoundEvent BLOCK_ENDERCHEST_CLOSE;
	public static final SoundEvent BLOCK_ENDERCHEST_OPEN;
	public static final SoundEvent ENTITY_ENDERDRAGON_AMBIENT;
	public static final SoundEvent ENTITY_ENDERDRAGON_DEATH;
	public static final SoundEvent ENTITY_ENDERDRAGON_FIREBALL_EPLD;
	public static final SoundEvent ENTITY_ENDERDRAGON_FLAP;
	public static final SoundEvent ENTITY_ENDERDRAGON_GROWL;
	public static final SoundEvent ENTITY_ENDERDRAGON_HURT;
	public static final SoundEvent ENTITY_ENDERDRAGON_SHOOT;
	public static final SoundEvent ENTITY_ENDEREYE_DEATH;
	public static final SoundEvent ENTITY_ENDEREYE_LAUNCH;
	public static final SoundEvent ENTITY_ENDERMEN_AMBIENT;
	public static final SoundEvent ENTITY_ENDERMEN_DEATH;
	public static final SoundEvent ENTITY_ENDERMEN_HURT;
	public static final SoundEvent ENTITY_ENDERMEN_SCREAM;
	public static final SoundEvent ENTITY_ENDERMEN_STARE;
	public static final SoundEvent ENTITY_ENDERMEN_TELEPORT;
	public static final SoundEvent ENTITY_ENDERMITE_AMBIENT;
	public static final SoundEvent ENTITY_ENDERMITE_DEATH;
	public static final SoundEvent ENTITY_ENDERMITE_HURT;
	public static final SoundEvent ENTITY_ENDERMITE_STEP;
	public static final SoundEvent ENTITY_ENDERPEARL_THROW;
	public static final SoundEvent BLOCK_END_GATEWAY_SPAWN;
	public static final SoundEvent BLOCK_END_PORTAL_FRAME_FILL;
	public static final SoundEvent BLOCK_END_PORTAL_SPAWN;
	public static final SoundEvent ENTITY_EVOCATION_FANGS_ATTACK;
	public static final SoundEvent ENTITY_EVOCATION_ILLAGER_AMBIENT;
	public static final SoundEvent ENTITY_EVOCATION_ILLAGER_CAST_SPELL;
	public static final SoundEvent ENTITY_EVOCATION_ILLAGER_DEATH;
	public static final SoundEvent ENTITY_EVOCATION_ILLAGER_HURT;
	public static final SoundEvent ENTITY_EVOCATION_ILLAGER_PREPARE_ATTACK;
	public static final SoundEvent ENTITY_EVOCATION_ILLAGER_PREPARE_SUMMON;
	public static final SoundEvent ENTITY_EVOCATION_ILLAGER_PREPARE_WOLOLO;
	public static final SoundEvent ENTITY_EXPERIENCE_BOTTLE_THROW;
	public static final SoundEvent ENTITY_EXPERIENCE_ORB_PICKUP;
	public static final SoundEvent BLOCK_FENCE_GATE_CLOSE;
	public static final SoundEvent BLOCK_FENCE_GATE_OPEN;
	public static final SoundEvent ITEM_FIRECHARGE_USE;
	public static final SoundEvent ENTITY_FIREWORK_BLAST;
	public static final SoundEvent ENTITY_FIREWORK_BLAST_FAR;
	public static final SoundEvent ENTITY_FIREWORK_LARGE_BLAST;
	public static final SoundEvent ENTITY_FIREWORK_LARGE_BLAST_FAR;
	public static final SoundEvent ENTITY_FIREWORK_LAUNCH;
	public static final SoundEvent ENTITY_FIREWORK_SHOOT;
	public static final SoundEvent ENTITY_FIREWORK_TWINKLE;
	public static final SoundEvent ENTITY_FIREWORK_TWINKLE_FAR;
	public static final SoundEvent BLOCK_FIRE_AMBIENT;
	public static final SoundEvent BLOCK_FIRE_EXTINGUISH;
	public static final SoundEvent ITEM_FLINTANDSTEEL_USE;
	public static final SoundEvent BLOCK_FURNACE_FIRE_CRACKLE;
	public static final SoundEvent ENTITY_GENERIC_BIG_FALL;
	public static final SoundEvent ENTITY_GENERIC_BURN;
	public static final SoundEvent ENTITY_GENERIC_DEATH;
	public static final SoundEvent ENTITY_GENERIC_DRINK;
	public static final SoundEvent ENTITY_GENERIC_EAT;
	public static final SoundEvent ENTITY_GENERIC_EXPLODE;
	public static final SoundEvent ENTITY_GENERIC_EXTINGUISH_FIRE;
	public static final SoundEvent ENTITY_GENERIC_HURT;
	public static final SoundEvent ENTITY_GENERIC_SMALL_FALL;
	public static final SoundEvent ENTITY_GENERIC_SPLASH;
	public static final SoundEvent ENTITY_GENERIC_SWIM;
	public static final SoundEvent ENTITY_GHAST_AMBIENT;
	public static final SoundEvent ENTITY_GHAST_DEATH;
	public static final SoundEvent ENTITY_GHAST_HURT;
	public static final SoundEvent ENTITY_GHAST_SCREAM;
	public static final SoundEvent ENTITY_GHAST_SHOOT;
	public static final SoundEvent ENTITY_GHAST_WARN;
	public static final SoundEvent BLOCK_GLASS_BREAK;
	public static final SoundEvent BLOCK_GLASS_FALL;
	public static final SoundEvent BLOCK_GLASS_HIT;
	public static final SoundEvent BLOCK_GLASS_PLACE;
	public static final SoundEvent BLOCK_GLASS_STEP;
	public static final SoundEvent BLOCK_GRASS_BREAK;
	public static final SoundEvent BLOCK_GRASS_FALL;
	public static final SoundEvent BLOCK_GRASS_HIT;
	public static final SoundEvent BLOCK_GRASS_PLACE;
	public static final SoundEvent BLOCK_GRASS_STEP;
	public static final SoundEvent BLOCK_GRAVEL_BREAK;
	public static final SoundEvent BLOCK_GRAVEL_FALL;
	public static final SoundEvent BLOCK_GRAVEL_HIT;
	public static final SoundEvent BLOCK_GRAVEL_PLACE;
	public static final SoundEvent BLOCK_GRAVEL_STEP;
	public static final SoundEvent ENTITY_GUARDIAN_AMBIENT;
	public static final SoundEvent ENTITY_GUARDIAN_AMBIENT_LAND;
	public static final SoundEvent ENTITY_GUARDIAN_ATTACK;
	public static final SoundEvent ENTITY_GUARDIAN_DEATH;
	public static final SoundEvent ENTITY_GUARDIAN_DEATH_LAND;
	public static final SoundEvent ENTITY_GUARDIAN_FLOP;
	public static final SoundEvent ENTITY_GUARDIAN_HURT;
	public static final SoundEvent ENTITY_GUARDIAN_HURT_LAND;
	public static final SoundEvent ITEM_HOE_TILL;
	public static final SoundEvent ENTITY_HORSE_AMBIENT;
	public static final SoundEvent ENTITY_HORSE_ANGRY;
	public static final SoundEvent ENTITY_HORSE_ARMOR;
	public static final SoundEvent ENTITY_HORSE_BREATHE;
	public static final SoundEvent ENTITY_HORSE_DEATH;
	public static final SoundEvent ENTITY_HORSE_EAT;
	public static final SoundEvent ENTITY_HORSE_GALLOP;
	public static final SoundEvent ENTITY_HORSE_HURT;
	public static final SoundEvent ENTITY_HORSE_JUMP;
	public static final SoundEvent ENTITY_HORSE_LAND;
	public static final SoundEvent ENTITY_HORSE_SADDLE;
	public static final SoundEvent ENTITY_HORSE_STEP;
	public static final SoundEvent ENTITY_HORSE_STEP_WOOD;
	public static final SoundEvent ENTITY_HOSTILE_BIG_FALL;
	public static final SoundEvent ENTITY_HOSTILE_DEATH;
	public static final SoundEvent ENTITY_HOSTILE_HURT;
	public static final SoundEvent ENTITY_HOSTILE_SMALL_FALL;
	public static final SoundEvent ENTITY_HOSTILE_SPLASH;
	public static final SoundEvent ENTITY_HOSTILE_SWIM;
	public static final SoundEvent ENTITY_HUSK_AMBIENT;
	public static final SoundEvent ENTITY_HUSK_DEATH;
	public static final SoundEvent ENTITY_HUSK_HURT;
	public static final SoundEvent ENTITY_HUSK_STEP;
	public static final SoundEvent ENTITY_ILLUSION_ILLAGER_AMBIENT;
	public static final SoundEvent ENTITY_ILLUSION_ILLAGER_CAST_SPELL;
	public static final SoundEvent ENTITY_ILLUSION_ILLAGER_DEATH;
	public static final SoundEvent ENTITY_ILLUSION_ILLAGER_HURT;
	public static final SoundEvent ENTITY_ILLUSION_ILLAGER_MIRROR_MOVE;
	public static final SoundEvent ENTITY_ILLUSION_ILLAGER_PREPARE_BLINDNESS;
	public static final SoundEvent ENTITY_ILLUSION_ILLAGER_PREPARE_MIRROR;
	public static final SoundEvent ENTITY_IRONGOLEM_ATTACK;
	public static final SoundEvent ENTITY_IRONGOLEM_DEATH;
	public static final SoundEvent ENTITY_IRONGOLEM_HURT;
	public static final SoundEvent ENTITY_IRONGOLEM_STEP;
	public static final SoundEvent BLOCK_IRON_DOOR_CLOSE;
	public static final SoundEvent BLOCK_IRON_DOOR_OPEN;
	public static final SoundEvent BLOCK_IRON_TRAPDOOR_CLOSE;
	public static final SoundEvent BLOCK_IRON_TRAPDOOR_OPEN;
	public static final SoundEvent ENTITY_ITEMFRAME_ADD_ITEM;
	public static final SoundEvent ENTITY_ITEMFRAME_BREAK;
	public static final SoundEvent ENTITY_ITEMFRAME_PLACE;
	public static final SoundEvent ENTITY_ITEMFRAME_REMOVE_ITEM;
	public static final SoundEvent ENTITY_ITEMFRAME_ROTATE_ITEM;
	public static final SoundEvent ENTITY_ITEM_BREAK;
	public static final SoundEvent ENTITY_ITEM_PICKUP;
	public static final SoundEvent BLOCK_LADDER_BREAK;
	public static final SoundEvent BLOCK_LADDER_FALL;
	public static final SoundEvent BLOCK_LADDER_HIT;
	public static final SoundEvent BLOCK_LADDER_PLACE;
	public static final SoundEvent BLOCK_LADDER_STEP;
	public static final SoundEvent BLOCK_LAVA_AMBIENT;
	public static final SoundEvent BLOCK_LAVA_EXTINGUISH;
	public static final SoundEvent BLOCK_LAVA_POP;
	public static final SoundEvent ENTITY_LEASHKNOT_BREAK;
	public static final SoundEvent ENTITY_LEASHKNOT_PLACE;
	public static final SoundEvent BLOCK_LEVER_CLICK;
	public static final SoundEvent ENTITY_LIGHTNING_IMPACT;
	public static final SoundEvent ENTITY_LIGHTNING_THUNDER;
	public static final SoundEvent ENTITY_LINGERINGPOTION_THROW;
	public static final SoundEvent ENTITY_LLAMA_AMBIENT;
	public static final SoundEvent ENTITY_LLAMA_ANGRY;
	public static final SoundEvent ENTITY_LLAMA_CHEST;
	public static final SoundEvent ENTITY_LLAMA_DEATH;
	public static final SoundEvent ENTITY_LLAMA_EAT;
	public static final SoundEvent ENTITY_LLAMA_HURT;
	public static final SoundEvent ENTITY_LLAMA_SPIT;
	public static final SoundEvent ENTITY_LLAMA_STEP;
	public static final SoundEvent ENTITY_LLAMA_SWAG;
	public static final SoundEvent ENTITY_MAGMACUBE_DEATH;
	public static final SoundEvent ENTITY_MAGMACUBE_HURT;
	public static final SoundEvent ENTITY_MAGMACUBE_JUMP;
	public static final SoundEvent ENTITY_MAGMACUBE_SQUISH;
	public static final SoundEvent BLOCK_METAL_BREAK;
	public static final SoundEvent BLOCK_METAL_FALL;
	public static final SoundEvent BLOCK_METAL_HIT;
	public static final SoundEvent BLOCK_METAL_PLACE;
	public static final SoundEvent BLOCK_METAL_PRESSPLATE_CLICK_OFF;
	public static final SoundEvent BLOCK_METAL_PRESSPLATE_CLICK_ON;
	public static final SoundEvent BLOCK_METAL_STEP;
	public static final SoundEvent ENTITY_MINECART_INSIDE;
	public static final SoundEvent ENTITY_MINECART_RIDING;
	public static final SoundEvent ENTITY_MOOSHROOM_SHEAR;
	public static final SoundEvent ENTITY_MULE_AMBIENT;
	public static final SoundEvent ENTITY_MULE_CHEST;
	public static final SoundEvent ENTITY_MULE_DEATH;
	public static final SoundEvent ENTITY_MULE_HURT;
	public static final SoundEvent MUSIC_CREATIVE;
	public static final SoundEvent MUSIC_CREDITS;
	public static final SoundEvent MUSIC_DRAGON;
	public static final SoundEvent MUSIC_END;
	public static final SoundEvent MUSIC_GAME;
	public static final SoundEvent MUSIC_MENU;
	public static final SoundEvent MUSIC_NETHER;
	public static final SoundEvent BLOCK_NOTE_BASEDRUM;
	public static final SoundEvent BLOCK_NOTE_BASS;
	public static final SoundEvent BLOCK_NOTE_BELL;
	public static final SoundEvent BLOCK_NOTE_CHIME;
	public static final SoundEvent BLOCK_NOTE_FLUTE;
	public static final SoundEvent BLOCK_NOTE_GUITAR;
	public static final SoundEvent BLOCK_NOTE_HARP;
	public static final SoundEvent BLOCK_NOTE_HAT;
	public static final SoundEvent BLOCK_NOTE_PLING;
	public static final SoundEvent BLOCK_NOTE_SNARE;
	public static final SoundEvent BLOCK_NOTE_XYLOPHONE;
	public static final SoundEvent ENTITY_PAINTING_BREAK;
	public static final SoundEvent ENTITY_PAINTING_PLACE;
	public static final SoundEvent ENTITY_PARROT_AMBIENT;
	public static final SoundEvent ENTITY_PARROT_DEATH;
	public static final SoundEvent ENTITY_PARROT_EAT;
	public static final SoundEvent ENTITY_PARROT_FLY;
	public static final SoundEvent ENTITY_PARROT_HURT;
	public static final SoundEvent ENTITY_PARROT_IMITATE_BLAZE;
	public static final SoundEvent ENTITY_PARROT_IMITATE_CREEPER;
	public static final SoundEvent ENTITY_PARROT_IMITATE_ELDER_GUARDIAN;
	public static final SoundEvent ENTITY_PARROT_IMITATE_ENDERDRAGON;
	public static final SoundEvent ENTITY_PARROT_IMITATE_ENDERMAN;
	public static final SoundEvent ENTITY_PARROT_IMITATE_ENDERMITE;
	public static final SoundEvent ENTITY_PARROT_IMITATE_EVOCATION_ILLAGER;
	public static final SoundEvent ENTITY_PARROT_IMITATE_GHAST;
	public static final SoundEvent ENTITY_PARROT_IMITATE_HUSK;
	public static final SoundEvent ENTITY_PARROT_IMITATE_ILLUSION_ILLAGER;
	public static final SoundEvent ENTITY_PARROT_IMITATE_MAGMACUBE;
	public static final SoundEvent ENTITY_PARROT_IMITATE_POLAR_BEAR;
	public static final SoundEvent ENTITY_PARROT_IMITATE_SHULKER;
	public static final SoundEvent ENTITY_PARROT_IMITATE_SILVERFISH;
	public static final SoundEvent ENTITY_PARROT_IMITATE_SKELETON;
	public static final SoundEvent ENTITY_PARROT_IMITATE_SLIME;
	public static final SoundEvent ENTITY_PARROT_IMITATE_SPIDER;
	public static final SoundEvent ENTITY_PARROT_IMITATE_STRAY;
	public static final SoundEvent ENTITY_PARROT_IMITATE_VEX;
	public static final SoundEvent ENTITY_PARROT_IMITATE_VINDICATION_ILLAGER;
	public static final SoundEvent ENTITY_PARROT_IMITATE_WITCH;
	public static final SoundEvent ENTITY_PARROT_IMITATE_WITHER;
	public static final SoundEvent ENTITY_PARROT_IMITATE_WITHER_SKELETON;
	public static final SoundEvent ENTITY_PARROT_IMITATE_WOLF;
	public static final SoundEvent ENTITY_PARROT_IMITATE_ZOMBIE;
	public static final SoundEvent ENTITY_PARROT_IMITATE_ZOMBIE_PIGMAN;
	public static final SoundEvent ENTITY_PARROT_IMITATE_ZOMBIE_VILLAGER;
	public static final SoundEvent ENTITY_PARROT_STEP;
	public static final SoundEvent ENTITY_PIG_AMBIENT;
	public static final SoundEvent ENTITY_PIG_DEATH;
	public static final SoundEvent ENTITY_PIG_HURT;
	public static final SoundEvent ENTITY_PIG_SADDLE;
	public static final SoundEvent ENTITY_PIG_STEP;
	public static final SoundEvent BLOCK_PISTON_CONTRACT;
	public static final SoundEvent BLOCK_PISTON_EXTEND;
	public static final SoundEvent ENTITY_PLAYER_ATTACK_CRIT;
	public static final SoundEvent ENTITY_PLAYER_ATTACK_KNOCKBACK;
	public static final SoundEvent ENTITY_PLAYER_ATTACK_NODAMAGE;
	public static final SoundEvent ENTITY_PLAYER_ATTACK_STRONG;
	public static final SoundEvent ENTITY_PLAYER_ATTACK_SWEEP;
	public static final SoundEvent ENTITY_PLAYER_ATTACK_WEAK;
	public static final SoundEvent ENTITY_PLAYER_BIG_FALL;
	public static final SoundEvent ENTITY_PLAYER_BREATH;
	public static final SoundEvent ENTITY_PLAYER_BURP;
	public static final SoundEvent ENTITY_PLAYER_DEATH;
	public static final SoundEvent ENTITY_PLAYER_HURT;
	public static final SoundEvent ENTITY_PLAYER_HURT_DROWN;
	public static final SoundEvent ENTITY_PLAYER_HURT_ON_FIRE;
	public static final SoundEvent ENTITY_PLAYER_LEVELUP;
	public static final SoundEvent ENTITY_PLAYER_SMALL_FALL;
	public static final SoundEvent ENTITY_PLAYER_SPLASH;
	public static final SoundEvent ENTITY_PLAYER_SWIM;
	public static final SoundEvent ENTITY_POLAR_BEAR_AMBIENT;
	public static final SoundEvent ENTITY_POLAR_BEAR_BABY_AMBIENT;
	public static final SoundEvent ENTITY_POLAR_BEAR_DEATH;
	public static final SoundEvent ENTITY_POLAR_BEAR_HURT;
	public static final SoundEvent ENTITY_POLAR_BEAR_STEP;
	public static final SoundEvent ENTITY_POLAR_BEAR_WARNING;
	public static final SoundEvent BLOCK_PORTAL_AMBIENT;
	public static final SoundEvent BLOCK_PORTAL_TRAVEL;
	public static final SoundEvent BLOCK_PORTAL_TRIGGER;
	public static final SoundEvent ENTITY_RABBIT_AMBIENT;
	public static final SoundEvent ENTITY_RABBIT_ATTACK;
	public static final SoundEvent ENTITY_RABBIT_DEATH;
	public static final SoundEvent ENTITY_RABBIT_HURT;
	public static final SoundEvent ENTITY_RABBIT_JUMP;
	public static final SoundEvent RECORD_11;
	public static final SoundEvent RECORD_13;
	public static final SoundEvent RECORD_BLOCKS;
	public static final SoundEvent RECORD_CAT;
	public static final SoundEvent RECORD_CHIRP;
	public static final SoundEvent RECORD_FAR;
	public static final SoundEvent RECORD_MALL;
	public static final SoundEvent RECORD_MELLOHI;
	public static final SoundEvent RECORD_STAL;
	public static final SoundEvent RECORD_STRAD;
	public static final SoundEvent RECORD_WAIT;
	public static final SoundEvent RECORD_WARD;
	public static final SoundEvent BLOCK_REDSTONE_TORCH_BURNOUT;
	public static final SoundEvent BLOCK_SAND_BREAK;
	public static final SoundEvent BLOCK_SAND_FALL;
	public static final SoundEvent BLOCK_SAND_HIT;
	public static final SoundEvent BLOCK_SAND_PLACE;
	public static final SoundEvent BLOCK_SAND_STEP;
	public static final SoundEvent ENTITY_SHEEP_AMBIENT;
	public static final SoundEvent ENTITY_SHEEP_DEATH;
	public static final SoundEvent ENTITY_SHEEP_HURT;
	public static final SoundEvent ENTITY_SHEEP_SHEAR;
	public static final SoundEvent ENTITY_SHEEP_STEP;
	public static final SoundEvent ITEM_SHIELD_BLOCK;
	public static final SoundEvent ITEM_SHIELD_BREAK;
	public static final SoundEvent ITEM_SHOVEL_FLATTEN;
	public static final SoundEvent ENTITY_SHULKER_AMBIENT;
	public static final SoundEvent BLOCK_SHULKER_BOX_CLOSE;
	public static final SoundEvent BLOCK_SHULKER_BOX_OPEN;
	public static final SoundEvent ENTITY_SHULKER_BULLET_HIT;
	public static final SoundEvent ENTITY_SHULKER_BULLET_HURT;
	public static final SoundEvent ENTITY_SHULKER_CLOSE;
	public static final SoundEvent ENTITY_SHULKER_DEATH;
	public static final SoundEvent ENTITY_SHULKER_HURT;
	public static final SoundEvent ENTITY_SHULKER_HURT_CLOSED;
	public static final SoundEvent ENTITY_SHULKER_OPEN;
	public static final SoundEvent ENTITY_SHULKER_SHOOT;
	public static final SoundEvent ENTITY_SHULKER_TELEPORT;
	public static final SoundEvent ENTITY_SILVERFISH_AMBIENT;
	public static final SoundEvent ENTITY_SILVERFISH_DEATH;
	public static final SoundEvent ENTITY_SILVERFISH_HURT;
	public static final SoundEvent ENTITY_SILVERFISH_STEP;
	public static final SoundEvent ENTITY_SKELETON_AMBIENT;
	public static final SoundEvent ENTITY_SKELETON_DEATH;
	public static final SoundEvent ENTITY_SKELETON_HORSE_AMBIENT;
	public static final SoundEvent ENTITY_SKELETON_HORSE_DEATH;
	public static final SoundEvent ENTITY_SKELETON_HORSE_HURT;
	public static final SoundEvent ENTITY_SKELETON_HURT;
	public static final SoundEvent ENTITY_SKELETON_SHOOT;
	public static final SoundEvent ENTITY_SKELETON_STEP;
	public static final SoundEvent ENTITY_SLIME_ATTACK;
	public static final SoundEvent BLOCK_SLIME_BREAK;
	public static final SoundEvent ENTITY_SLIME_DEATH;
	public static final SoundEvent BLOCK_SLIME_FALL;
	public static final SoundEvent BLOCK_SLIME_HIT;
	public static final SoundEvent ENTITY_SLIME_HURT;
	public static final SoundEvent ENTITY_SLIME_JUMP;
	public static final SoundEvent BLOCK_SLIME_PLACE;
	public static final SoundEvent ENTITY_SLIME_SQUISH;
	public static final SoundEvent BLOCK_SLIME_STEP;
	public static final SoundEvent ENTITY_SMALL_MAGMACUBE_DEATH;
	public static final SoundEvent ENTITY_SMALL_MAGMACUBE_HURT;
	public static final SoundEvent ENTITY_SMALL_MAGMACUBE_SQUISH;
	public static final SoundEvent ENTITY_SMALL_SLIME_DEATH;
	public static final SoundEvent ENTITY_SMALL_SLIME_HURT;
	public static final SoundEvent ENTITY_SMALL_SLIME_JUMP;
	public static final SoundEvent ENTITY_SMALL_SLIME_SQUISH;
	public static final SoundEvent ENTITY_SNOWBALL_THROW;
	public static final SoundEvent ENTITY_SNOWMAN_AMBIENT;
	public static final SoundEvent ENTITY_SNOWMAN_DEATH;
	public static final SoundEvent ENTITY_SNOWMAN_HURT;
	public static final SoundEvent ENTITY_SNOWMAN_SHOOT;
	public static final SoundEvent BLOCK_SNOW_BREAK;
	public static final SoundEvent BLOCK_SNOW_FALL;
	public static final SoundEvent BLOCK_SNOW_HIT;
	public static final SoundEvent BLOCK_SNOW_PLACE;
	public static final SoundEvent BLOCK_SNOW_STEP;
	public static final SoundEvent ENTITY_SPIDER_AMBIENT;
	public static final SoundEvent ENTITY_SPIDER_DEATH;
	public static final SoundEvent ENTITY_SPIDER_HURT;
	public static final SoundEvent ENTITY_SPIDER_STEP;
	public static final SoundEvent ENTITY_SPLASH_POTION_BREAK;
	public static final SoundEvent ENTITY_SPLASH_POTION_THROW;
	public static final SoundEvent ENTITY_SQUID_AMBIENT;
	public static final SoundEvent ENTITY_SQUID_DEATH;
	public static final SoundEvent ENTITY_SQUID_HURT;
	public static final SoundEvent BLOCK_STONE_BREAK;
	public static final SoundEvent BLOCK_STONE_BUTTON_CLICK_OFF;
	public static final SoundEvent BLOCK_STONE_BUTTON_CLICK_ON;
	public static final SoundEvent BLOCK_STONE_FALL;
	public static final SoundEvent BLOCK_STONE_HIT;
	public static final SoundEvent BLOCK_STONE_PLACE;
	public static final SoundEvent BLOCK_STONE_PRESSPLATE_CLICK_OFF;
	public static final SoundEvent BLOCK_STONE_PRESSPLATE_CLICK_ON;
	public static final SoundEvent BLOCK_STONE_STEP;
	public static final SoundEvent ENTITY_STRAY_AMBIENT;
	public static final SoundEvent ENTITY_STRAY_DEATH;
	public static final SoundEvent ENTITY_STRAY_HURT;
	public static final SoundEvent ENTITY_STRAY_STEP;
	public static final SoundEvent ENCHANT_THORNS_HIT;
	public static final SoundEvent ENTITY_TNT_PRIMED;
	public static final SoundEvent ITEM_TOTEM_USE;
	public static final SoundEvent BLOCK_TRIPWIRE_ATTACH;
	public static final SoundEvent BLOCK_TRIPWIRE_CLICK_OFF;
	public static final SoundEvent BLOCK_TRIPWIRE_CLICK_ON;
	public static final SoundEvent BLOCK_TRIPWIRE_DETACH;
	public static final SoundEvent UI_BUTTON_CLICK;
	public static final SoundEvent UI_TOAST_IN;
	public static final SoundEvent UI_TOAST_OUT;
	public static final SoundEvent UI_TOAST_CHALLENGE_COMPLETE;
	public static final SoundEvent ENTITY_VEX_AMBIENT;
	public static final SoundEvent ENTITY_VEX_CHARGE;
	public static final SoundEvent ENTITY_VEX_DEATH;
	public static final SoundEvent ENTITY_VEX_HURT;
	public static final SoundEvent ENTITY_VILLAGER_AMBIENT;
	public static final SoundEvent ENTITY_VILLAGER_DEATH;
	public static final SoundEvent ENTITY_VILLAGER_HURT;
	public static final SoundEvent ENTITY_VILLAGER_NO;
	public static final SoundEvent ENTITY_VILLAGER_TRADING;
	public static final SoundEvent ENTITY_VILLAGER_YES;
	public static final SoundEvent ENTITY_VINDICATION_ILLAGER_AMBIENT;
	public static final SoundEvent ENTITY_VINDICATION_ILLAGER_DEATH;
	public static final SoundEvent ENTITY_VINDICATION_ILLAGER_HURT;
	public static final SoundEvent BLOCK_WATERLILY_PLACE;
	public static final SoundEvent BLOCK_WATER_AMBIENT;
	public static final SoundEvent WEATHER_RAIN;
	public static final SoundEvent WEATHER_RAIN_ABOVE;
	public static final SoundEvent ENTITY_WITCH_AMBIENT;
	public static final SoundEvent ENTITY_WITCH_DEATH;
	public static final SoundEvent ENTITY_WITCH_DRINK;
	public static final SoundEvent ENTITY_WITCH_HURT;
	public static final SoundEvent ENTITY_WITCH_THROW;
	public static final SoundEvent ENTITY_WITHER_AMBIENT;
	public static final SoundEvent ENTITY_WITHER_BREAK_BLOCK;
	public static final SoundEvent ENTITY_WITHER_DEATH;
	public static final SoundEvent ENTITY_WITHER_HURT;
	public static final SoundEvent ENTITY_WITHER_SHOOT;
	public static final SoundEvent ENTITY_WITHER_SKELETON_AMBIENT;
	public static final SoundEvent ENTITY_WITHER_SKELETON_DEATH;
	public static final SoundEvent ENTITY_WITHER_SKELETON_HURT;
	public static final SoundEvent ENTITY_WITHER_SKELETON_STEP;
	public static final SoundEvent ENTITY_WITHER_SPAWN;
	public static final SoundEvent ENTITY_WOLF_AMBIENT;
	public static final SoundEvent ENTITY_WOLF_DEATH;
	public static final SoundEvent ENTITY_WOLF_GROWL;
	public static final SoundEvent ENTITY_WOLF_HOWL;
	public static final SoundEvent ENTITY_WOLF_HURT;
	public static final SoundEvent ENTITY_WOLF_PANT;
	public static final SoundEvent ENTITY_WOLF_SHAKE;
	public static final SoundEvent ENTITY_WOLF_STEP;
	public static final SoundEvent ENTITY_WOLF_WHINE;
	public static final SoundEvent BLOCK_WOODEN_DOOR_CLOSE;
	public static final SoundEvent BLOCK_WOODEN_DOOR_OPEN;
	public static final SoundEvent BLOCK_WOODEN_TRAPDOOR_CLOSE;
	public static final SoundEvent BLOCK_WOODEN_TRAPDOOR_OPEN;
	public static final SoundEvent BLOCK_WOOD_BREAK;
	public static final SoundEvent BLOCK_WOOD_BUTTON_CLICK_OFF;
	public static final SoundEvent BLOCK_WOOD_BUTTON_CLICK_ON;
	public static final SoundEvent BLOCK_WOOD_FALL;
	public static final SoundEvent BLOCK_WOOD_HIT;
	public static final SoundEvent BLOCK_WOOD_PLACE;
	public static final SoundEvent BLOCK_WOOD_PRESSPLATE_CLICK_OFF;
	public static final SoundEvent BLOCK_WOOD_PRESSPLATE_CLICK_ON;
	public static final SoundEvent BLOCK_WOOD_STEP;
	public static final SoundEvent ENTITY_ZOMBIE_AMBIENT;
	public static final SoundEvent ENTITY_ZOMBIE_ATTACK_DOOR_WOOD;
	public static final SoundEvent ENTITY_ZOMBIE_ATTACK_IRON_DOOR;
	public static final SoundEvent ENTITY_ZOMBIE_BREAK_DOOR_WOOD;
	public static final SoundEvent ENTITY_ZOMBIE_DEATH;
	public static final SoundEvent ENTITY_ZOMBIE_HORSE_AMBIENT;
	public static final SoundEvent ENTITY_ZOMBIE_HORSE_DEATH;
	public static final SoundEvent ENTITY_ZOMBIE_HORSE_HURT;
	public static final SoundEvent ENTITY_ZOMBIE_HURT;
	public static final SoundEvent ENTITY_ZOMBIE_INFECT;
	public static final SoundEvent ENTITY_ZOMBIE_PIG_AMBIENT;
	public static final SoundEvent ENTITY_ZOMBIE_PIG_ANGRY;
	public static final SoundEvent ENTITY_ZOMBIE_PIG_DEATH;
	public static final SoundEvent ENTITY_ZOMBIE_PIG_HURT;
	public static final SoundEvent ENTITY_ZOMBIE_STEP;
	public static final SoundEvent ENTITY_ZOMBIE_VILLAGER_AMBIENT;
	public static final SoundEvent ENTITY_ZOMBIE_VILLAGER_CONVERTED;
	public static final SoundEvent ENTITY_ZOMBIE_VILLAGER_CURE;
	public static final SoundEvent ENTITY_ZOMBIE_VILLAGER_DEATH;
	public static final SoundEvent ENTITY_ZOMBIE_VILLAGER_HURT;
	public static final SoundEvent ENTITY_ZOMBIE_VILLAGER_STEP;

	private static SoundEvent getRegisteredSoundEvent(String id) {
		SoundEvent soundevent = SoundEvent.REGISTRY.getObject(new ResourceLocation(id));

		if (soundevent == null) {
			throw new IllegalStateException("Invalid Sound requested: " + id);
		} else {
			return soundevent;
		}
	}

	static {
		if (!Bootstrap.isRegistered()) {
			throw new RuntimeException("Accessed Sounds before Bootstrap!");
		} else {
			AMBIENT_CAVE = getRegisteredSoundEvent("ambient.cave");
			BLOCK_ANVIL_BREAK = getRegisteredSoundEvent("block.anvil.break");
			BLOCK_ANVIL_DESTROY = getRegisteredSoundEvent("block.anvil.destroy");
			BLOCK_ANVIL_FALL = getRegisteredSoundEvent("block.anvil.fall");
			BLOCK_ANVIL_HIT = getRegisteredSoundEvent("block.anvil.hit");
			BLOCK_ANVIL_LAND = getRegisteredSoundEvent("block.anvil.land");
			BLOCK_ANVIL_PLACE = getRegisteredSoundEvent("block.anvil.place");
			BLOCK_ANVIL_STEP = getRegisteredSoundEvent("block.anvil.step");
			BLOCK_ANVIL_USE = getRegisteredSoundEvent("block.anvil.use");
			ENTITY_ARMORSTAND_BREAK = getRegisteredSoundEvent("entity.armorstand.break");
			ENTITY_ARMORSTAND_FALL = getRegisteredSoundEvent("entity.armorstand.fall");
			ENTITY_ARMORSTAND_HIT = getRegisteredSoundEvent("entity.armorstand.hit");
			ENTITY_ARMORSTAND_PLACE = getRegisteredSoundEvent("entity.armorstand.place");
			ITEM_ARMOR_EQUIP_CHAIN = getRegisteredSoundEvent("item.armor.equip_chain");
			ITEM_ARMOR_EQUIP_DIAMOND = getRegisteredSoundEvent("item.armor.equip_diamond");
			ITEM_ARMOR_EQUIP_ELYTRA = getRegisteredSoundEvent("item.armor.equip_elytra");
			ITEM_ARMOR_EQUIP_GENERIC = getRegisteredSoundEvent("item.armor.equip_generic");
			ITEM_ARMOR_EQUIP_GOLD = getRegisteredSoundEvent("item.armor.equip_gold");
			ITEM_ARMOR_EQUIP_IRON = getRegisteredSoundEvent("item.armor.equip_iron");
			ITEM_ARMOR_EQUIP_LEATHER = getRegisteredSoundEvent("item.armor.equip_leather");
			ENTITY_ARROW_HIT = getRegisteredSoundEvent("entity.arrow.hit");
			ENTITY_ARROW_HIT_PLAYER = getRegisteredSoundEvent("entity.arrow.hit_player");
			ENTITY_ARROW_SHOOT = getRegisteredSoundEvent("entity.arrow.shoot");
			ENTITY_BAT_AMBIENT = getRegisteredSoundEvent("entity.bat.ambient");
			ENTITY_BAT_DEATH = getRegisteredSoundEvent("entity.bat.death");
			ENTITY_BAT_HURT = getRegisteredSoundEvent("entity.bat.hurt");
			ENTITY_BAT_LOOP = getRegisteredSoundEvent("entity.bat.loop");
			ENTITY_BAT_TAKEOFF = getRegisteredSoundEvent("entity.bat.takeoff");
			ENTITY_BLAZE_AMBIENT = getRegisteredSoundEvent("entity.blaze.ambient");
			ENTITY_BLAZE_BURN = getRegisteredSoundEvent("entity.blaze.burn");
			ENTITY_BLAZE_DEATH = getRegisteredSoundEvent("entity.blaze.death");
			ENTITY_BLAZE_HURT = getRegisteredSoundEvent("entity.blaze.hurt");
			ENTITY_BLAZE_SHOOT = getRegisteredSoundEvent("entity.blaze.shoot");
			ENTITY_BOAT_PADDLE_LAND = getRegisteredSoundEvent("entity.boat.paddle_land");
			ENTITY_BOAT_PADDLE_WATER = getRegisteredSoundEvent("entity.boat.paddle_water");
			ENTITY_BOBBER_RETRIEVE = getRegisteredSoundEvent("entity.bobber.retrieve");
			ENTITY_BOBBER_SPLASH = getRegisteredSoundEvent("entity.bobber.splash");
			ENTITY_BOBBER_THROW = getRegisteredSoundEvent("entity.bobber.throw");
			ITEM_BOTTLE_EMPTY = getRegisteredSoundEvent("item.bottle.empty");
			ITEM_BOTTLE_FILL = getRegisteredSoundEvent("item.bottle.fill");
			ITEM_BOTTLE_FILL_DRAGONBREATH = getRegisteredSoundEvent("item.bottle.fill_dragonbreath");
			BLOCK_BREWING_STAND_BREW = getRegisteredSoundEvent("block.brewing_stand.brew");
			ITEM_BUCKET_EMPTY = getRegisteredSoundEvent("item.bucket.empty");
			ITEM_BUCKET_EMPTY_LAVA = getRegisteredSoundEvent("item.bucket.empty_lava");
			ITEM_BUCKET_FILL = getRegisteredSoundEvent("item.bucket.fill");
			ITEM_BUCKET_FILL_LAVA = getRegisteredSoundEvent("item.bucket.fill_lava");
			ENTITY_CAT_AMBIENT = getRegisteredSoundEvent("entity.cat.ambient");
			ENTITY_CAT_DEATH = getRegisteredSoundEvent("entity.cat.death");
			ENTITY_CAT_HISS = getRegisteredSoundEvent("entity.cat.hiss");
			ENTITY_CAT_HURT = getRegisteredSoundEvent("entity.cat.hurt");
			ENTITY_CAT_PURR = getRegisteredSoundEvent("entity.cat.purr");
			ENTITY_CAT_PURREOW = getRegisteredSoundEvent("entity.cat.purreow");
			BLOCK_CHEST_CLOSE = getRegisteredSoundEvent("block.chest.close");
			BLOCK_CHEST_LOCKED = getRegisteredSoundEvent("block.chest.locked");
			BLOCK_CHEST_OPEN = getRegisteredSoundEvent("block.chest.open");
			ENTITY_CHICKEN_AMBIENT = getRegisteredSoundEvent("entity.chicken.ambient");
			ENTITY_CHICKEN_DEATH = getRegisteredSoundEvent("entity.chicken.death");
			ENTITY_CHICKEN_EGG = getRegisteredSoundEvent("entity.chicken.egg");
			ENTITY_CHICKEN_HURT = getRegisteredSoundEvent("entity.chicken.hurt");
			ENTITY_CHICKEN_STEP = getRegisteredSoundEvent("entity.chicken.step");
			BLOCK_CHORUS_FLOWER_DEATH = getRegisteredSoundEvent("block.chorus_flower.death");
			BLOCK_CHORUS_FLOWER_GROW = getRegisteredSoundEvent("block.chorus_flower.grow");
			ITEM_CHORUS_FRUIT_TELEPORT = getRegisteredSoundEvent("item.chorus_fruit.teleport");
			BLOCK_CLOTH_BREAK = getRegisteredSoundEvent("block.cloth.break");
			BLOCK_CLOTH_FALL = getRegisteredSoundEvent("block.cloth.fall");
			BLOCK_CLOTH_HIT = getRegisteredSoundEvent("block.cloth.hit");
			BLOCK_CLOTH_PLACE = getRegisteredSoundEvent("block.cloth.place");
			BLOCK_CLOTH_STEP = getRegisteredSoundEvent("block.cloth.step");
			BLOCK_COMPARATOR_CLICK = getRegisteredSoundEvent("block.comparator.click");
			ENTITY_COW_AMBIENT = getRegisteredSoundEvent("entity.cow.ambient");
			ENTITY_COW_DEATH = getRegisteredSoundEvent("entity.cow.death");
			ENTITY_COW_HURT = getRegisteredSoundEvent("entity.cow.hurt");
			ENTITY_COW_MILK = getRegisteredSoundEvent("entity.cow.milk");
			ENTITY_COW_STEP = getRegisteredSoundEvent("entity.cow.step");
			ENTITY_CREEPER_DEATH = getRegisteredSoundEvent("entity.creeper.death");
			ENTITY_CREEPER_HURT = getRegisteredSoundEvent("entity.creeper.hurt");
			ENTITY_CREEPER_PRIMED = getRegisteredSoundEvent("entity.creeper.primed");
			BLOCK_DISPENSER_DISPENSE = getRegisteredSoundEvent("block.dispenser.dispense");
			BLOCK_DISPENSER_FAIL = getRegisteredSoundEvent("block.dispenser.fail");
			BLOCK_DISPENSER_LAUNCH = getRegisteredSoundEvent("block.dispenser.launch");
			ENTITY_DONKEY_AMBIENT = getRegisteredSoundEvent("entity.donkey.ambient");
			ENTITY_DONKEY_ANGRY = getRegisteredSoundEvent("entity.donkey.angry");
			ENTITY_DONKEY_CHEST = getRegisteredSoundEvent("entity.donkey.chest");
			ENTITY_DONKEY_DEATH = getRegisteredSoundEvent("entity.donkey.death");
			ENTITY_DONKEY_HURT = getRegisteredSoundEvent("entity.donkey.hurt");
			ENTITY_EGG_THROW = getRegisteredSoundEvent("entity.egg.throw");
			ENTITY_ELDER_GUARDIAN_AMBIENT = getRegisteredSoundEvent("entity.elder_guardian.ambient");
			ENTITY_ELDERGUARDIAN_AMBIENTLAND = getRegisteredSoundEvent("entity.elder_guardian.ambient_land");
			ENTITY_ELDER_GUARDIAN_CURSE = getRegisteredSoundEvent("entity.elder_guardian.curse");
			ENTITY_ELDER_GUARDIAN_DEATH = getRegisteredSoundEvent("entity.elder_guardian.death");
			ENTITY_ELDER_GUARDIAN_DEATH_LAND = getRegisteredSoundEvent("entity.elder_guardian.death_land");
			ENTITY_ELDER_GUARDIAN_FLOP = getRegisteredSoundEvent("entity.elder_guardian.flop");
			ENTITY_ELDER_GUARDIAN_HURT = getRegisteredSoundEvent("entity.elder_guardian.hurt");
			ENTITY_ELDER_GUARDIAN_HURT_LAND = getRegisteredSoundEvent("entity.elder_guardian.hurt_land");
			ITEM_ELYTRA_FLYING = getRegisteredSoundEvent("item.elytra.flying");
			BLOCK_ENCHANTMENT_TABLE_USE = getRegisteredSoundEvent("block.enchantment_table.use");
			BLOCK_ENDERCHEST_CLOSE = getRegisteredSoundEvent("block.enderchest.close");
			BLOCK_ENDERCHEST_OPEN = getRegisteredSoundEvent("block.enderchest.open");
			ENTITY_ENDERDRAGON_AMBIENT = getRegisteredSoundEvent("entity.enderdragon.ambient");
			ENTITY_ENDERDRAGON_DEATH = getRegisteredSoundEvent("entity.enderdragon.death");
			ENTITY_ENDERDRAGON_FIREBALL_EPLD = getRegisteredSoundEvent("entity.enderdragon_fireball.explode");
			ENTITY_ENDERDRAGON_FLAP = getRegisteredSoundEvent("entity.enderdragon.flap");
			ENTITY_ENDERDRAGON_GROWL = getRegisteredSoundEvent("entity.enderdragon.growl");
			ENTITY_ENDERDRAGON_HURT = getRegisteredSoundEvent("entity.enderdragon.hurt");
			ENTITY_ENDERDRAGON_SHOOT = getRegisteredSoundEvent("entity.enderdragon.shoot");
			ENTITY_ENDEREYE_DEATH = getRegisteredSoundEvent("entity.endereye.death");
			ENTITY_ENDEREYE_LAUNCH = getRegisteredSoundEvent("entity.endereye.launch");
			ENTITY_ENDERMEN_AMBIENT = getRegisteredSoundEvent("entity.endermen.ambient");
			ENTITY_ENDERMEN_DEATH = getRegisteredSoundEvent("entity.endermen.death");
			ENTITY_ENDERMEN_HURT = getRegisteredSoundEvent("entity.endermen.hurt");
			ENTITY_ENDERMEN_SCREAM = getRegisteredSoundEvent("entity.endermen.scream");
			ENTITY_ENDERMEN_STARE = getRegisteredSoundEvent("entity.endermen.stare");
			ENTITY_ENDERMEN_TELEPORT = getRegisteredSoundEvent("entity.endermen.teleport");
			ENTITY_ENDERMITE_AMBIENT = getRegisteredSoundEvent("entity.endermite.ambient");
			ENTITY_ENDERMITE_DEATH = getRegisteredSoundEvent("entity.endermite.death");
			ENTITY_ENDERMITE_HURT = getRegisteredSoundEvent("entity.endermite.hurt");
			ENTITY_ENDERMITE_STEP = getRegisteredSoundEvent("entity.endermite.step");
			ENTITY_ENDERPEARL_THROW = getRegisteredSoundEvent("entity.enderpearl.throw");
			BLOCK_END_GATEWAY_SPAWN = getRegisteredSoundEvent("block.end_gateway.spawn");
			BLOCK_END_PORTAL_FRAME_FILL = getRegisteredSoundEvent("block.end_portal_frame.fill");
			BLOCK_END_PORTAL_SPAWN = getRegisteredSoundEvent("block.end_portal.spawn");
			ENTITY_EVOCATION_FANGS_ATTACK = getRegisteredSoundEvent("entity.evocation_fangs.attack");
			ENTITY_EVOCATION_ILLAGER_AMBIENT = getRegisteredSoundEvent("entity.evocation_illager.ambient");
			ENTITY_EVOCATION_ILLAGER_CAST_SPELL = getRegisteredSoundEvent("entity.evocation_illager.cast_spell");
			ENTITY_EVOCATION_ILLAGER_DEATH = getRegisteredSoundEvent("entity.evocation_illager.death");
			ENTITY_EVOCATION_ILLAGER_HURT = getRegisteredSoundEvent("entity.evocation_illager.hurt");
			ENTITY_EVOCATION_ILLAGER_PREPARE_ATTACK = getRegisteredSoundEvent(
					"entity.evocation_illager.prepare_attack");
			ENTITY_EVOCATION_ILLAGER_PREPARE_SUMMON = getRegisteredSoundEvent(
					"entity.evocation_illager.prepare_summon");
			ENTITY_EVOCATION_ILLAGER_PREPARE_WOLOLO = getRegisteredSoundEvent(
					"entity.evocation_illager.prepare_wololo");
			ENTITY_EXPERIENCE_BOTTLE_THROW = getRegisteredSoundEvent("entity.experience_bottle.throw");
			ENTITY_EXPERIENCE_ORB_PICKUP = getRegisteredSoundEvent("entity.experience_orb.pickup");
			BLOCK_FENCE_GATE_CLOSE = getRegisteredSoundEvent("block.fence_gate.close");
			BLOCK_FENCE_GATE_OPEN = getRegisteredSoundEvent("block.fence_gate.open");
			ITEM_FIRECHARGE_USE = getRegisteredSoundEvent("item.firecharge.use");
			ENTITY_FIREWORK_BLAST = getRegisteredSoundEvent("entity.firework.blast");
			ENTITY_FIREWORK_BLAST_FAR = getRegisteredSoundEvent("entity.firework.blast_far");
			ENTITY_FIREWORK_LARGE_BLAST = getRegisteredSoundEvent("entity.firework.large_blast");
			ENTITY_FIREWORK_LARGE_BLAST_FAR = getRegisteredSoundEvent("entity.firework.large_blast_far");
			ENTITY_FIREWORK_LAUNCH = getRegisteredSoundEvent("entity.firework.launch");
			ENTITY_FIREWORK_SHOOT = getRegisteredSoundEvent("entity.firework.shoot");
			ENTITY_FIREWORK_TWINKLE = getRegisteredSoundEvent("entity.firework.twinkle");
			ENTITY_FIREWORK_TWINKLE_FAR = getRegisteredSoundEvent("entity.firework.twinkle_far");
			BLOCK_FIRE_AMBIENT = getRegisteredSoundEvent("block.fire.ambient");
			BLOCK_FIRE_EXTINGUISH = getRegisteredSoundEvent("block.fire.extinguish");
			ITEM_FLINTANDSTEEL_USE = getRegisteredSoundEvent("item.flintandsteel.use");
			BLOCK_FURNACE_FIRE_CRACKLE = getRegisteredSoundEvent("block.furnace.fire_crackle");
			ENTITY_GENERIC_BIG_FALL = getRegisteredSoundEvent("entity.generic.big_fall");
			ENTITY_GENERIC_BURN = getRegisteredSoundEvent("entity.generic.burn");
			ENTITY_GENERIC_DEATH = getRegisteredSoundEvent("entity.generic.death");
			ENTITY_GENERIC_DRINK = getRegisteredSoundEvent("entity.generic.drink");
			ENTITY_GENERIC_EAT = getRegisteredSoundEvent("entity.generic.eat");
			ENTITY_GENERIC_EXPLODE = getRegisteredSoundEvent("entity.generic.explode");
			ENTITY_GENERIC_EXTINGUISH_FIRE = getRegisteredSoundEvent("entity.generic.extinguish_fire");
			ENTITY_GENERIC_HURT = getRegisteredSoundEvent("entity.generic.hurt");
			ENTITY_GENERIC_SMALL_FALL = getRegisteredSoundEvent("entity.generic.small_fall");
			ENTITY_GENERIC_SPLASH = getRegisteredSoundEvent("entity.generic.splash");
			ENTITY_GENERIC_SWIM = getRegisteredSoundEvent("entity.generic.swim");
			ENTITY_GHAST_AMBIENT = getRegisteredSoundEvent("entity.ghast.ambient");
			ENTITY_GHAST_DEATH = getRegisteredSoundEvent("entity.ghast.death");
			ENTITY_GHAST_HURT = getRegisteredSoundEvent("entity.ghast.hurt");
			ENTITY_GHAST_SCREAM = getRegisteredSoundEvent("entity.ghast.scream");
			ENTITY_GHAST_SHOOT = getRegisteredSoundEvent("entity.ghast.shoot");
			ENTITY_GHAST_WARN = getRegisteredSoundEvent("entity.ghast.warn");
			BLOCK_GLASS_BREAK = getRegisteredSoundEvent("block.glass.break");
			BLOCK_GLASS_FALL = getRegisteredSoundEvent("block.glass.fall");
			BLOCK_GLASS_HIT = getRegisteredSoundEvent("block.glass.hit");
			BLOCK_GLASS_PLACE = getRegisteredSoundEvent("block.glass.place");
			BLOCK_GLASS_STEP = getRegisteredSoundEvent("block.glass.step");
			BLOCK_GRASS_BREAK = getRegisteredSoundEvent("block.grass.break");
			BLOCK_GRASS_FALL = getRegisteredSoundEvent("block.grass.fall");
			BLOCK_GRASS_HIT = getRegisteredSoundEvent("block.grass.hit");
			BLOCK_GRASS_PLACE = getRegisteredSoundEvent("block.grass.place");
			BLOCK_GRASS_STEP = getRegisteredSoundEvent("block.grass.step");
			BLOCK_GRAVEL_BREAK = getRegisteredSoundEvent("block.gravel.break");
			BLOCK_GRAVEL_FALL = getRegisteredSoundEvent("block.gravel.fall");
			BLOCK_GRAVEL_HIT = getRegisteredSoundEvent("block.gravel.hit");
			BLOCK_GRAVEL_PLACE = getRegisteredSoundEvent("block.gravel.place");
			BLOCK_GRAVEL_STEP = getRegisteredSoundEvent("block.gravel.step");
			ENTITY_GUARDIAN_AMBIENT = getRegisteredSoundEvent("entity.guardian.ambient");
			ENTITY_GUARDIAN_AMBIENT_LAND = getRegisteredSoundEvent("entity.guardian.ambient_land");
			ENTITY_GUARDIAN_ATTACK = getRegisteredSoundEvent("entity.guardian.attack");
			ENTITY_GUARDIAN_DEATH = getRegisteredSoundEvent("entity.guardian.death");
			ENTITY_GUARDIAN_DEATH_LAND = getRegisteredSoundEvent("entity.guardian.death_land");
			ENTITY_GUARDIAN_FLOP = getRegisteredSoundEvent("entity.guardian.flop");
			ENTITY_GUARDIAN_HURT = getRegisteredSoundEvent("entity.guardian.hurt");
			ENTITY_GUARDIAN_HURT_LAND = getRegisteredSoundEvent("entity.guardian.hurt_land");
			ITEM_HOE_TILL = getRegisteredSoundEvent("item.hoe.till");
			ENTITY_HORSE_AMBIENT = getRegisteredSoundEvent("entity.horse.ambient");
			ENTITY_HORSE_ANGRY = getRegisteredSoundEvent("entity.horse.angry");
			ENTITY_HORSE_ARMOR = getRegisteredSoundEvent("entity.horse.armor");
			ENTITY_HORSE_BREATHE = getRegisteredSoundEvent("entity.horse.breathe");
			ENTITY_HORSE_DEATH = getRegisteredSoundEvent("entity.horse.death");
			ENTITY_HORSE_EAT = getRegisteredSoundEvent("entity.horse.eat");
			ENTITY_HORSE_GALLOP = getRegisteredSoundEvent("entity.horse.gallop");
			ENTITY_HORSE_HURT = getRegisteredSoundEvent("entity.horse.hurt");
			ENTITY_HORSE_JUMP = getRegisteredSoundEvent("entity.horse.jump");
			ENTITY_HORSE_LAND = getRegisteredSoundEvent("entity.horse.land");
			ENTITY_HORSE_SADDLE = getRegisteredSoundEvent("entity.horse.saddle");
			ENTITY_HORSE_STEP = getRegisteredSoundEvent("entity.horse.step");
			ENTITY_HORSE_STEP_WOOD = getRegisteredSoundEvent("entity.horse.step_wood");
			ENTITY_HOSTILE_BIG_FALL = getRegisteredSoundEvent("entity.hostile.big_fall");
			ENTITY_HOSTILE_DEATH = getRegisteredSoundEvent("entity.hostile.death");
			ENTITY_HOSTILE_HURT = getRegisteredSoundEvent("entity.hostile.hurt");
			ENTITY_HOSTILE_SMALL_FALL = getRegisteredSoundEvent("entity.hostile.small_fall");
			ENTITY_HOSTILE_SPLASH = getRegisteredSoundEvent("entity.hostile.splash");
			ENTITY_HOSTILE_SWIM = getRegisteredSoundEvent("entity.hostile.swim");
			ENTITY_HUSK_AMBIENT = getRegisteredSoundEvent("entity.husk.ambient");
			ENTITY_HUSK_DEATH = getRegisteredSoundEvent("entity.husk.death");
			ENTITY_HUSK_HURT = getRegisteredSoundEvent("entity.husk.hurt");
			ENTITY_HUSK_STEP = getRegisteredSoundEvent("entity.husk.step");
			ENTITY_ILLUSION_ILLAGER_AMBIENT = getRegisteredSoundEvent("entity.illusion_illager.ambient");
			ENTITY_ILLUSION_ILLAGER_CAST_SPELL = getRegisteredSoundEvent("entity.illusion_illager.cast_spell");
			ENTITY_ILLUSION_ILLAGER_DEATH = getRegisteredSoundEvent("entity.illusion_illager.death");
			ENTITY_ILLUSION_ILLAGER_HURT = getRegisteredSoundEvent("entity.illusion_illager.hurt");
			ENTITY_ILLUSION_ILLAGER_MIRROR_MOVE = getRegisteredSoundEvent("entity.illusion_illager.mirror_move");
			ENTITY_ILLUSION_ILLAGER_PREPARE_BLINDNESS = getRegisteredSoundEvent(
					"entity.illusion_illager.prepare_blindness");
			ENTITY_ILLUSION_ILLAGER_PREPARE_MIRROR = getRegisteredSoundEvent("entity.illusion_illager.prepare_mirror");
			ENTITY_IRONGOLEM_ATTACK = getRegisteredSoundEvent("entity.irongolem.attack");
			ENTITY_IRONGOLEM_DEATH = getRegisteredSoundEvent("entity.irongolem.death");
			ENTITY_IRONGOLEM_HURT = getRegisteredSoundEvent("entity.irongolem.hurt");
			ENTITY_IRONGOLEM_STEP = getRegisteredSoundEvent("entity.irongolem.step");
			BLOCK_IRON_DOOR_CLOSE = getRegisteredSoundEvent("block.iron_door.close");
			BLOCK_IRON_DOOR_OPEN = getRegisteredSoundEvent("block.iron_door.open");
			BLOCK_IRON_TRAPDOOR_CLOSE = getRegisteredSoundEvent("block.iron_trapdoor.close");
			BLOCK_IRON_TRAPDOOR_OPEN = getRegisteredSoundEvent("block.iron_trapdoor.open");
			ENTITY_ITEMFRAME_ADD_ITEM = getRegisteredSoundEvent("entity.itemframe.add_item");
			ENTITY_ITEMFRAME_BREAK = getRegisteredSoundEvent("entity.itemframe.break");
			ENTITY_ITEMFRAME_PLACE = getRegisteredSoundEvent("entity.itemframe.place");
			ENTITY_ITEMFRAME_REMOVE_ITEM = getRegisteredSoundEvent("entity.itemframe.remove_item");
			ENTITY_ITEMFRAME_ROTATE_ITEM = getRegisteredSoundEvent("entity.itemframe.rotate_item");
			ENTITY_ITEM_BREAK = getRegisteredSoundEvent("entity.item.break");
			ENTITY_ITEM_PICKUP = getRegisteredSoundEvent("entity.item.pickup");
			BLOCK_LADDER_BREAK = getRegisteredSoundEvent("block.ladder.break");
			BLOCK_LADDER_FALL = getRegisteredSoundEvent("block.ladder.fall");
			BLOCK_LADDER_HIT = getRegisteredSoundEvent("block.ladder.hit");
			BLOCK_LADDER_PLACE = getRegisteredSoundEvent("block.ladder.place");
			BLOCK_LADDER_STEP = getRegisteredSoundEvent("block.ladder.step");
			BLOCK_LAVA_AMBIENT = getRegisteredSoundEvent("block.lava.ambient");
			BLOCK_LAVA_EXTINGUISH = getRegisteredSoundEvent("block.lava.extinguish");
			BLOCK_LAVA_POP = getRegisteredSoundEvent("block.lava.pop");
			ENTITY_LEASHKNOT_BREAK = getRegisteredSoundEvent("entity.leashknot.break");
			ENTITY_LEASHKNOT_PLACE = getRegisteredSoundEvent("entity.leashknot.place");
			BLOCK_LEVER_CLICK = getRegisteredSoundEvent("block.lever.click");
			ENTITY_LIGHTNING_IMPACT = getRegisteredSoundEvent("entity.lightning.impact");
			ENTITY_LIGHTNING_THUNDER = getRegisteredSoundEvent("entity.lightning.thunder");
			ENTITY_LINGERINGPOTION_THROW = getRegisteredSoundEvent("entity.lingeringpotion.throw");
			ENTITY_LLAMA_AMBIENT = getRegisteredSoundEvent("entity.llama.ambient");
			ENTITY_LLAMA_ANGRY = getRegisteredSoundEvent("entity.llama.angry");
			ENTITY_LLAMA_CHEST = getRegisteredSoundEvent("entity.llama.chest");
			ENTITY_LLAMA_DEATH = getRegisteredSoundEvent("entity.llama.death");
			ENTITY_LLAMA_EAT = getRegisteredSoundEvent("entity.llama.eat");
			ENTITY_LLAMA_HURT = getRegisteredSoundEvent("entity.llama.hurt");
			ENTITY_LLAMA_SPIT = getRegisteredSoundEvent("entity.llama.spit");
			ENTITY_LLAMA_STEP = getRegisteredSoundEvent("entity.llama.step");
			ENTITY_LLAMA_SWAG = getRegisteredSoundEvent("entity.llama.swag");
			ENTITY_MAGMACUBE_DEATH = getRegisteredSoundEvent("entity.magmacube.death");
			ENTITY_MAGMACUBE_HURT = getRegisteredSoundEvent("entity.magmacube.hurt");
			ENTITY_MAGMACUBE_JUMP = getRegisteredSoundEvent("entity.magmacube.jump");
			ENTITY_MAGMACUBE_SQUISH = getRegisteredSoundEvent("entity.magmacube.squish");
			BLOCK_METAL_BREAK = getRegisteredSoundEvent("block.metal.break");
			BLOCK_METAL_FALL = getRegisteredSoundEvent("block.metal.fall");
			BLOCK_METAL_HIT = getRegisteredSoundEvent("block.metal.hit");
			BLOCK_METAL_PLACE = getRegisteredSoundEvent("block.metal.place");
			BLOCK_METAL_PRESSPLATE_CLICK_OFF = getRegisteredSoundEvent("block.metal_pressureplate.click_off");
			BLOCK_METAL_PRESSPLATE_CLICK_ON = getRegisteredSoundEvent("block.metal_pressureplate.click_on");
			BLOCK_METAL_STEP = getRegisteredSoundEvent("block.metal.step");
			ENTITY_MINECART_INSIDE = getRegisteredSoundEvent("entity.minecart.inside");
			ENTITY_MINECART_RIDING = getRegisteredSoundEvent("entity.minecart.riding");
			ENTITY_MOOSHROOM_SHEAR = getRegisteredSoundEvent("entity.mooshroom.shear");
			ENTITY_MULE_AMBIENT = getRegisteredSoundEvent("entity.mule.ambient");
			ENTITY_MULE_CHEST = getRegisteredSoundEvent("entity.mule.chest");
			ENTITY_MULE_DEATH = getRegisteredSoundEvent("entity.mule.death");
			ENTITY_MULE_HURT = getRegisteredSoundEvent("entity.mule.hurt");
			MUSIC_CREATIVE = getRegisteredSoundEvent("music.creative");
			MUSIC_CREDITS = getRegisteredSoundEvent("music.credits");
			MUSIC_DRAGON = getRegisteredSoundEvent("music.dragon");
			MUSIC_END = getRegisteredSoundEvent("music.end");
			MUSIC_GAME = getRegisteredSoundEvent("music.game");
			MUSIC_MENU = getRegisteredSoundEvent("music.menu");
			MUSIC_NETHER = getRegisteredSoundEvent("music.nether");
			BLOCK_NOTE_BASEDRUM = getRegisteredSoundEvent("block.note.basedrum");
			BLOCK_NOTE_BASS = getRegisteredSoundEvent("block.note.bass");
			BLOCK_NOTE_BELL = getRegisteredSoundEvent("block.note.bell");
			BLOCK_NOTE_CHIME = getRegisteredSoundEvent("block.note.chime");
			BLOCK_NOTE_FLUTE = getRegisteredSoundEvent("block.note.flute");
			BLOCK_NOTE_GUITAR = getRegisteredSoundEvent("block.note.guitar");
			BLOCK_NOTE_HARP = getRegisteredSoundEvent("block.note.harp");
			BLOCK_NOTE_HAT = getRegisteredSoundEvent("block.note.hat");
			BLOCK_NOTE_PLING = getRegisteredSoundEvent("block.note.pling");
			BLOCK_NOTE_SNARE = getRegisteredSoundEvent("block.note.snare");
			BLOCK_NOTE_XYLOPHONE = getRegisteredSoundEvent("block.note.xylophone");
			ENTITY_PAINTING_BREAK = getRegisteredSoundEvent("entity.painting.break");
			ENTITY_PAINTING_PLACE = getRegisteredSoundEvent("entity.painting.place");
			ENTITY_PARROT_AMBIENT = getRegisteredSoundEvent("entity.parrot.ambient");
			ENTITY_PARROT_DEATH = getRegisteredSoundEvent("entity.parrot.death");
			ENTITY_PARROT_EAT = getRegisteredSoundEvent("entity.parrot.eat");
			ENTITY_PARROT_FLY = getRegisteredSoundEvent("entity.parrot.fly");
			ENTITY_PARROT_HURT = getRegisteredSoundEvent("entity.parrot.hurt");
			ENTITY_PARROT_IMITATE_BLAZE = getRegisteredSoundEvent("entity.parrot.imitate.blaze");
			ENTITY_PARROT_IMITATE_CREEPER = getRegisteredSoundEvent("entity.parrot.imitate.creeper");
			ENTITY_PARROT_IMITATE_ELDER_GUARDIAN = getRegisteredSoundEvent("entity.parrot.imitate.elder_guardian");
			ENTITY_PARROT_IMITATE_ENDERDRAGON = getRegisteredSoundEvent("entity.parrot.imitate.enderdragon");
			ENTITY_PARROT_IMITATE_ENDERMAN = getRegisteredSoundEvent("entity.parrot.imitate.enderman");
			ENTITY_PARROT_IMITATE_ENDERMITE = getRegisteredSoundEvent("entity.parrot.imitate.endermite");
			ENTITY_PARROT_IMITATE_EVOCATION_ILLAGER = getRegisteredSoundEvent(
					"entity.parrot.imitate.evocation_illager");
			ENTITY_PARROT_IMITATE_GHAST = getRegisteredSoundEvent("entity.parrot.imitate.ghast");
			ENTITY_PARROT_IMITATE_HUSK = getRegisteredSoundEvent("entity.parrot.imitate.husk");
			ENTITY_PARROT_IMITATE_ILLUSION_ILLAGER = getRegisteredSoundEvent("entity.parrot.imitate.illusion_illager");
			ENTITY_PARROT_IMITATE_MAGMACUBE = getRegisteredSoundEvent("entity.parrot.imitate.magmacube");
			ENTITY_PARROT_IMITATE_POLAR_BEAR = getRegisteredSoundEvent("entity.parrot.imitate.polar_bear");
			ENTITY_PARROT_IMITATE_SHULKER = getRegisteredSoundEvent("entity.parrot.imitate.shulker");
			ENTITY_PARROT_IMITATE_SILVERFISH = getRegisteredSoundEvent("entity.parrot.imitate.silverfish");
			ENTITY_PARROT_IMITATE_SKELETON = getRegisteredSoundEvent("entity.parrot.imitate.skeleton");
			ENTITY_PARROT_IMITATE_SLIME = getRegisteredSoundEvent("entity.parrot.imitate.slime");
			ENTITY_PARROT_IMITATE_SPIDER = getRegisteredSoundEvent("entity.parrot.imitate.spider");
			ENTITY_PARROT_IMITATE_STRAY = getRegisteredSoundEvent("entity.parrot.imitate.stray");
			ENTITY_PARROT_IMITATE_VEX = getRegisteredSoundEvent("entity.parrot.imitate.vex");
			ENTITY_PARROT_IMITATE_VINDICATION_ILLAGER = getRegisteredSoundEvent(
					"entity.parrot.imitate.vindication_illager");
			ENTITY_PARROT_IMITATE_WITCH = getRegisteredSoundEvent("entity.parrot.imitate.witch");
			ENTITY_PARROT_IMITATE_WITHER = getRegisteredSoundEvent("entity.parrot.imitate.wither");
			ENTITY_PARROT_IMITATE_WITHER_SKELETON = getRegisteredSoundEvent("entity.parrot.imitate.wither_skeleton");
			ENTITY_PARROT_IMITATE_WOLF = getRegisteredSoundEvent("entity.parrot.imitate.wolf");
			ENTITY_PARROT_IMITATE_ZOMBIE = getRegisteredSoundEvent("entity.parrot.imitate.zombie");
			ENTITY_PARROT_IMITATE_ZOMBIE_PIGMAN = getRegisteredSoundEvent("entity.parrot.imitate.zombie_pigman");
			ENTITY_PARROT_IMITATE_ZOMBIE_VILLAGER = getRegisteredSoundEvent("entity.parrot.imitate.zombie_villager");
			ENTITY_PARROT_STEP = getRegisteredSoundEvent("entity.parrot.step");
			ENTITY_PIG_AMBIENT = getRegisteredSoundEvent("entity.pig.ambient");
			ENTITY_PIG_DEATH = getRegisteredSoundEvent("entity.pig.death");
			ENTITY_PIG_HURT = getRegisteredSoundEvent("entity.pig.hurt");
			ENTITY_PIG_SADDLE = getRegisteredSoundEvent("entity.pig.saddle");
			ENTITY_PIG_STEP = getRegisteredSoundEvent("entity.pig.step");
			BLOCK_PISTON_CONTRACT = getRegisteredSoundEvent("block.piston.contract");
			BLOCK_PISTON_EXTEND = getRegisteredSoundEvent("block.piston.extend");
			ENTITY_PLAYER_ATTACK_CRIT = getRegisteredSoundEvent("entity.player.attack.crit");
			ENTITY_PLAYER_ATTACK_KNOCKBACK = getRegisteredSoundEvent("entity.player.attack.knockback");
			ENTITY_PLAYER_ATTACK_NODAMAGE = getRegisteredSoundEvent("entity.player.attack.nodamage");
			ENTITY_PLAYER_ATTACK_STRONG = getRegisteredSoundEvent("entity.player.attack.strong");
			ENTITY_PLAYER_ATTACK_SWEEP = getRegisteredSoundEvent("entity.player.attack.sweep");
			ENTITY_PLAYER_ATTACK_WEAK = getRegisteredSoundEvent("entity.player.attack.weak");
			ENTITY_PLAYER_BIG_FALL = getRegisteredSoundEvent("entity.player.big_fall");
			ENTITY_PLAYER_BREATH = getRegisteredSoundEvent("entity.player.breath");
			ENTITY_PLAYER_BURP = getRegisteredSoundEvent("entity.player.burp");
			ENTITY_PLAYER_DEATH = getRegisteredSoundEvent("entity.player.death");
			ENTITY_PLAYER_HURT = getRegisteredSoundEvent("entity.player.hurt");
			ENTITY_PLAYER_HURT_DROWN = getRegisteredSoundEvent("entity.player.hurt_drown");
			ENTITY_PLAYER_HURT_ON_FIRE = getRegisteredSoundEvent("entity.player.hurt_on_fire");
			ENTITY_PLAYER_LEVELUP = getRegisteredSoundEvent("entity.player.levelup");
			ENTITY_PLAYER_SMALL_FALL = getRegisteredSoundEvent("entity.player.small_fall");
			ENTITY_PLAYER_SPLASH = getRegisteredSoundEvent("entity.player.splash");
			ENTITY_PLAYER_SWIM = getRegisteredSoundEvent("entity.player.swim");
			ENTITY_POLAR_BEAR_AMBIENT = getRegisteredSoundEvent("entity.polar_bear.ambient");
			ENTITY_POLAR_BEAR_BABY_AMBIENT = getRegisteredSoundEvent("entity.polar_bear.baby_ambient");
			ENTITY_POLAR_BEAR_DEATH = getRegisteredSoundEvent("entity.polar_bear.death");
			ENTITY_POLAR_BEAR_HURT = getRegisteredSoundEvent("entity.polar_bear.hurt");
			ENTITY_POLAR_BEAR_STEP = getRegisteredSoundEvent("entity.polar_bear.step");
			ENTITY_POLAR_BEAR_WARNING = getRegisteredSoundEvent("entity.polar_bear.warning");
			BLOCK_PORTAL_AMBIENT = getRegisteredSoundEvent("block.portal.ambient");
			BLOCK_PORTAL_TRAVEL = getRegisteredSoundEvent("block.portal.travel");
			BLOCK_PORTAL_TRIGGER = getRegisteredSoundEvent("block.portal.trigger");
			ENTITY_RABBIT_AMBIENT = getRegisteredSoundEvent("entity.rabbit.ambient");
			ENTITY_RABBIT_ATTACK = getRegisteredSoundEvent("entity.rabbit.attack");
			ENTITY_RABBIT_DEATH = getRegisteredSoundEvent("entity.rabbit.death");
			ENTITY_RABBIT_HURT = getRegisteredSoundEvent("entity.rabbit.hurt");
			ENTITY_RABBIT_JUMP = getRegisteredSoundEvent("entity.rabbit.jump");
			RECORD_11 = getRegisteredSoundEvent("record.11");
			RECORD_13 = getRegisteredSoundEvent("record.13");
			RECORD_BLOCKS = getRegisteredSoundEvent("record.blocks");
			RECORD_CAT = getRegisteredSoundEvent("record.cat");
			RECORD_CHIRP = getRegisteredSoundEvent("record.chirp");
			RECORD_FAR = getRegisteredSoundEvent("record.far");
			RECORD_MALL = getRegisteredSoundEvent("record.mall");
			RECORD_MELLOHI = getRegisteredSoundEvent("record.mellohi");
			RECORD_STAL = getRegisteredSoundEvent("record.stal");
			RECORD_STRAD = getRegisteredSoundEvent("record.strad");
			RECORD_WAIT = getRegisteredSoundEvent("record.wait");
			RECORD_WARD = getRegisteredSoundEvent("record.ward");
			BLOCK_REDSTONE_TORCH_BURNOUT = getRegisteredSoundEvent("block.redstone_torch.burnout");
			BLOCK_SAND_BREAK = getRegisteredSoundEvent("block.sand.break");
			BLOCK_SAND_FALL = getRegisteredSoundEvent("block.sand.fall");
			BLOCK_SAND_HIT = getRegisteredSoundEvent("block.sand.hit");
			BLOCK_SAND_PLACE = getRegisteredSoundEvent("block.sand.place");
			BLOCK_SAND_STEP = getRegisteredSoundEvent("block.sand.step");
			ENTITY_SHEEP_AMBIENT = getRegisteredSoundEvent("entity.sheep.ambient");
			ENTITY_SHEEP_DEATH = getRegisteredSoundEvent("entity.sheep.death");
			ENTITY_SHEEP_HURT = getRegisteredSoundEvent("entity.sheep.hurt");
			ENTITY_SHEEP_SHEAR = getRegisteredSoundEvent("entity.sheep.shear");
			ENTITY_SHEEP_STEP = getRegisteredSoundEvent("entity.sheep.step");
			ITEM_SHIELD_BLOCK = getRegisteredSoundEvent("item.shield.block");
			ITEM_SHIELD_BREAK = getRegisteredSoundEvent("item.shield.break");
			ITEM_SHOVEL_FLATTEN = getRegisteredSoundEvent("item.shovel.flatten");
			ENTITY_SHULKER_AMBIENT = getRegisteredSoundEvent("entity.shulker.ambient");
			BLOCK_SHULKER_BOX_CLOSE = getRegisteredSoundEvent("block.shulker_box.close");
			BLOCK_SHULKER_BOX_OPEN = getRegisteredSoundEvent("block.shulker_box.open");
			ENTITY_SHULKER_BULLET_HIT = getRegisteredSoundEvent("entity.shulker_bullet.hit");
			ENTITY_SHULKER_BULLET_HURT = getRegisteredSoundEvent("entity.shulker_bullet.hurt");
			ENTITY_SHULKER_CLOSE = getRegisteredSoundEvent("entity.shulker.close");
			ENTITY_SHULKER_DEATH = getRegisteredSoundEvent("entity.shulker.death");
			ENTITY_SHULKER_HURT = getRegisteredSoundEvent("entity.shulker.hurt");
			ENTITY_SHULKER_HURT_CLOSED = getRegisteredSoundEvent("entity.shulker.hurt_closed");
			ENTITY_SHULKER_OPEN = getRegisteredSoundEvent("entity.shulker.open");
			ENTITY_SHULKER_SHOOT = getRegisteredSoundEvent("entity.shulker.shoot");
			ENTITY_SHULKER_TELEPORT = getRegisteredSoundEvent("entity.shulker.teleport");
			ENTITY_SILVERFISH_AMBIENT = getRegisteredSoundEvent("entity.silverfish.ambient");
			ENTITY_SILVERFISH_DEATH = getRegisteredSoundEvent("entity.silverfish.death");
			ENTITY_SILVERFISH_HURT = getRegisteredSoundEvent("entity.silverfish.hurt");
			ENTITY_SILVERFISH_STEP = getRegisteredSoundEvent("entity.silverfish.step");
			ENTITY_SKELETON_AMBIENT = getRegisteredSoundEvent("entity.skeleton.ambient");
			ENTITY_SKELETON_DEATH = getRegisteredSoundEvent("entity.skeleton.death");
			ENTITY_SKELETON_HORSE_AMBIENT = getRegisteredSoundEvent("entity.skeleton_horse.ambient");
			ENTITY_SKELETON_HORSE_DEATH = getRegisteredSoundEvent("entity.skeleton_horse.death");
			ENTITY_SKELETON_HORSE_HURT = getRegisteredSoundEvent("entity.skeleton_horse.hurt");
			ENTITY_SKELETON_HURT = getRegisteredSoundEvent("entity.skeleton.hurt");
			ENTITY_SKELETON_SHOOT = getRegisteredSoundEvent("entity.skeleton.shoot");
			ENTITY_SKELETON_STEP = getRegisteredSoundEvent("entity.skeleton.step");
			ENTITY_SLIME_ATTACK = getRegisteredSoundEvent("entity.slime.attack");
			BLOCK_SLIME_BREAK = getRegisteredSoundEvent("block.slime.break");
			ENTITY_SLIME_DEATH = getRegisteredSoundEvent("entity.slime.death");
			BLOCK_SLIME_FALL = getRegisteredSoundEvent("block.slime.fall");
			BLOCK_SLIME_HIT = getRegisteredSoundEvent("block.slime.hit");
			ENTITY_SLIME_HURT = getRegisteredSoundEvent("entity.slime.hurt");
			ENTITY_SLIME_JUMP = getRegisteredSoundEvent("entity.slime.jump");
			BLOCK_SLIME_PLACE = getRegisteredSoundEvent("block.slime.place");
			ENTITY_SLIME_SQUISH = getRegisteredSoundEvent("entity.slime.squish");
			BLOCK_SLIME_STEP = getRegisteredSoundEvent("block.slime.step");
			ENTITY_SMALL_MAGMACUBE_DEATH = getRegisteredSoundEvent("entity.small_magmacube.death");
			ENTITY_SMALL_MAGMACUBE_HURT = getRegisteredSoundEvent("entity.small_magmacube.hurt");
			ENTITY_SMALL_MAGMACUBE_SQUISH = getRegisteredSoundEvent("entity.small_magmacube.squish");
			ENTITY_SMALL_SLIME_DEATH = getRegisteredSoundEvent("entity.small_slime.death");
			ENTITY_SMALL_SLIME_HURT = getRegisteredSoundEvent("entity.small_slime.hurt");
			ENTITY_SMALL_SLIME_JUMP = getRegisteredSoundEvent("entity.small_slime.jump");
			ENTITY_SMALL_SLIME_SQUISH = getRegisteredSoundEvent("entity.small_slime.squish");
			ENTITY_SNOWBALL_THROW = getRegisteredSoundEvent("entity.snowball.throw");
			ENTITY_SNOWMAN_AMBIENT = getRegisteredSoundEvent("entity.snowman.ambient");
			ENTITY_SNOWMAN_DEATH = getRegisteredSoundEvent("entity.snowman.death");
			ENTITY_SNOWMAN_HURT = getRegisteredSoundEvent("entity.snowman.hurt");
			ENTITY_SNOWMAN_SHOOT = getRegisteredSoundEvent("entity.snowman.shoot");
			BLOCK_SNOW_BREAK = getRegisteredSoundEvent("block.snow.break");
			BLOCK_SNOW_FALL = getRegisteredSoundEvent("block.snow.fall");
			BLOCK_SNOW_HIT = getRegisteredSoundEvent("block.snow.hit");
			BLOCK_SNOW_PLACE = getRegisteredSoundEvent("block.snow.place");
			BLOCK_SNOW_STEP = getRegisteredSoundEvent("block.snow.step");
			ENTITY_SPIDER_AMBIENT = getRegisteredSoundEvent("entity.spider.ambient");
			ENTITY_SPIDER_DEATH = getRegisteredSoundEvent("entity.spider.death");
			ENTITY_SPIDER_HURT = getRegisteredSoundEvent("entity.spider.hurt");
			ENTITY_SPIDER_STEP = getRegisteredSoundEvent("entity.spider.step");
			ENTITY_SPLASH_POTION_BREAK = getRegisteredSoundEvent("entity.splash_potion.break");
			ENTITY_SPLASH_POTION_THROW = getRegisteredSoundEvent("entity.splash_potion.throw");
			ENTITY_SQUID_AMBIENT = getRegisteredSoundEvent("entity.squid.ambient");
			ENTITY_SQUID_DEATH = getRegisteredSoundEvent("entity.squid.death");
			ENTITY_SQUID_HURT = getRegisteredSoundEvent("entity.squid.hurt");
			BLOCK_STONE_BREAK = getRegisteredSoundEvent("block.stone.break");
			BLOCK_STONE_BUTTON_CLICK_OFF = getRegisteredSoundEvent("block.stone_button.click_off");
			BLOCK_STONE_BUTTON_CLICK_ON = getRegisteredSoundEvent("block.stone_button.click_on");
			BLOCK_STONE_FALL = getRegisteredSoundEvent("block.stone.fall");
			BLOCK_STONE_HIT = getRegisteredSoundEvent("block.stone.hit");
			BLOCK_STONE_PLACE = getRegisteredSoundEvent("block.stone.place");
			BLOCK_STONE_PRESSPLATE_CLICK_OFF = getRegisteredSoundEvent("block.stone_pressureplate.click_off");
			BLOCK_STONE_PRESSPLATE_CLICK_ON = getRegisteredSoundEvent("block.stone_pressureplate.click_on");
			BLOCK_STONE_STEP = getRegisteredSoundEvent("block.stone.step");
			ENTITY_STRAY_AMBIENT = getRegisteredSoundEvent("entity.stray.ambient");
			ENTITY_STRAY_DEATH = getRegisteredSoundEvent("entity.stray.death");
			ENTITY_STRAY_HURT = getRegisteredSoundEvent("entity.stray.hurt");
			ENTITY_STRAY_STEP = getRegisteredSoundEvent("entity.stray.step");
			ENCHANT_THORNS_HIT = getRegisteredSoundEvent("enchant.thorns.hit");
			ENTITY_TNT_PRIMED = getRegisteredSoundEvent("entity.tnt.primed");
			ITEM_TOTEM_USE = getRegisteredSoundEvent("item.totem.use");
			BLOCK_TRIPWIRE_ATTACH = getRegisteredSoundEvent("block.tripwire.attach");
			BLOCK_TRIPWIRE_CLICK_OFF = getRegisteredSoundEvent("block.tripwire.click_off");
			BLOCK_TRIPWIRE_CLICK_ON = getRegisteredSoundEvent("block.tripwire.click_on");
			BLOCK_TRIPWIRE_DETACH = getRegisteredSoundEvent("block.tripwire.detach");
			UI_BUTTON_CLICK = getRegisteredSoundEvent("ui.button.click");
			UI_TOAST_IN = getRegisteredSoundEvent("ui.toast.in");
			UI_TOAST_OUT = getRegisteredSoundEvent("ui.toast.out");
			UI_TOAST_CHALLENGE_COMPLETE = getRegisteredSoundEvent("ui.toast.challenge_complete");
			ENTITY_VEX_AMBIENT = getRegisteredSoundEvent("entity.vex.ambient");
			ENTITY_VEX_CHARGE = getRegisteredSoundEvent("entity.vex.charge");
			ENTITY_VEX_DEATH = getRegisteredSoundEvent("entity.vex.death");
			ENTITY_VEX_HURT = getRegisteredSoundEvent("entity.vex.hurt");
			ENTITY_VILLAGER_AMBIENT = getRegisteredSoundEvent("entity.villager.ambient");
			ENTITY_VILLAGER_DEATH = getRegisteredSoundEvent("entity.villager.death");
			ENTITY_VILLAGER_HURT = getRegisteredSoundEvent("entity.villager.hurt");
			ENTITY_VILLAGER_NO = getRegisteredSoundEvent("entity.villager.no");
			ENTITY_VILLAGER_TRADING = getRegisteredSoundEvent("entity.villager.trading");
			ENTITY_VILLAGER_YES = getRegisteredSoundEvent("entity.villager.yes");
			ENTITY_VINDICATION_ILLAGER_AMBIENT = getRegisteredSoundEvent("entity.vindication_illager.ambient");
			ENTITY_VINDICATION_ILLAGER_DEATH = getRegisteredSoundEvent("entity.vindication_illager.death");
			ENTITY_VINDICATION_ILLAGER_HURT = getRegisteredSoundEvent("entity.vindication_illager.hurt");
			BLOCK_WATERLILY_PLACE = getRegisteredSoundEvent("block.waterlily.place");
			BLOCK_WATER_AMBIENT = getRegisteredSoundEvent("block.water.ambient");
			WEATHER_RAIN = getRegisteredSoundEvent("weather.rain");
			WEATHER_RAIN_ABOVE = getRegisteredSoundEvent("weather.rain.above");
			ENTITY_WITCH_AMBIENT = getRegisteredSoundEvent("entity.witch.ambient");
			ENTITY_WITCH_DEATH = getRegisteredSoundEvent("entity.witch.death");
			ENTITY_WITCH_DRINK = getRegisteredSoundEvent("entity.witch.drink");
			ENTITY_WITCH_HURT = getRegisteredSoundEvent("entity.witch.hurt");
			ENTITY_WITCH_THROW = getRegisteredSoundEvent("entity.witch.throw");
			ENTITY_WITHER_AMBIENT = getRegisteredSoundEvent("entity.wither.ambient");
			ENTITY_WITHER_BREAK_BLOCK = getRegisteredSoundEvent("entity.wither.break_block");
			ENTITY_WITHER_DEATH = getRegisteredSoundEvent("entity.wither.death");
			ENTITY_WITHER_HURT = getRegisteredSoundEvent("entity.wither.hurt");
			ENTITY_WITHER_SHOOT = getRegisteredSoundEvent("entity.wither.shoot");
			ENTITY_WITHER_SKELETON_AMBIENT = getRegisteredSoundEvent("entity.wither_skeleton.ambient");
			ENTITY_WITHER_SKELETON_DEATH = getRegisteredSoundEvent("entity.wither_skeleton.death");
			ENTITY_WITHER_SKELETON_HURT = getRegisteredSoundEvent("entity.wither_skeleton.hurt");
			ENTITY_WITHER_SKELETON_STEP = getRegisteredSoundEvent("entity.wither_skeleton.step");
			ENTITY_WITHER_SPAWN = getRegisteredSoundEvent("entity.wither.spawn");
			ENTITY_WOLF_AMBIENT = getRegisteredSoundEvent("entity.wolf.ambient");
			ENTITY_WOLF_DEATH = getRegisteredSoundEvent("entity.wolf.death");
			ENTITY_WOLF_GROWL = getRegisteredSoundEvent("entity.wolf.growl");
			ENTITY_WOLF_HOWL = getRegisteredSoundEvent("entity.wolf.howl");
			ENTITY_WOLF_HURT = getRegisteredSoundEvent("entity.wolf.hurt");
			ENTITY_WOLF_PANT = getRegisteredSoundEvent("entity.wolf.pant");
			ENTITY_WOLF_SHAKE = getRegisteredSoundEvent("entity.wolf.shake");
			ENTITY_WOLF_STEP = getRegisteredSoundEvent("entity.wolf.step");
			ENTITY_WOLF_WHINE = getRegisteredSoundEvent("entity.wolf.whine");
			BLOCK_WOODEN_DOOR_CLOSE = getRegisteredSoundEvent("block.wooden_door.close");
			BLOCK_WOODEN_DOOR_OPEN = getRegisteredSoundEvent("block.wooden_door.open");
			BLOCK_WOODEN_TRAPDOOR_CLOSE = getRegisteredSoundEvent("block.wooden_trapdoor.close");
			BLOCK_WOODEN_TRAPDOOR_OPEN = getRegisteredSoundEvent("block.wooden_trapdoor.open");
			BLOCK_WOOD_BREAK = getRegisteredSoundEvent("block.wood.break");
			BLOCK_WOOD_BUTTON_CLICK_OFF = getRegisteredSoundEvent("block.wood_button.click_off");
			BLOCK_WOOD_BUTTON_CLICK_ON = getRegisteredSoundEvent("block.wood_button.click_on");
			BLOCK_WOOD_FALL = getRegisteredSoundEvent("block.wood.fall");
			BLOCK_WOOD_HIT = getRegisteredSoundEvent("block.wood.hit");
			BLOCK_WOOD_PLACE = getRegisteredSoundEvent("block.wood.place");
			BLOCK_WOOD_PRESSPLATE_CLICK_OFF = getRegisteredSoundEvent("block.wood_pressureplate.click_off");
			BLOCK_WOOD_PRESSPLATE_CLICK_ON = getRegisteredSoundEvent("block.wood_pressureplate.click_on");
			BLOCK_WOOD_STEP = getRegisteredSoundEvent("block.wood.step");
			ENTITY_ZOMBIE_AMBIENT = getRegisteredSoundEvent("entity.zombie.ambient");
			ENTITY_ZOMBIE_ATTACK_DOOR_WOOD = getRegisteredSoundEvent("entity.zombie.attack_door_wood");
			ENTITY_ZOMBIE_ATTACK_IRON_DOOR = getRegisteredSoundEvent("entity.zombie.attack_iron_door");
			ENTITY_ZOMBIE_BREAK_DOOR_WOOD = getRegisteredSoundEvent("entity.zombie.break_door_wood");
			ENTITY_ZOMBIE_DEATH = getRegisteredSoundEvent("entity.zombie.death");
			ENTITY_ZOMBIE_HORSE_AMBIENT = getRegisteredSoundEvent("entity.zombie_horse.ambient");
			ENTITY_ZOMBIE_HORSE_DEATH = getRegisteredSoundEvent("entity.zombie_horse.death");
			ENTITY_ZOMBIE_HORSE_HURT = getRegisteredSoundEvent("entity.zombie_horse.hurt");
			ENTITY_ZOMBIE_HURT = getRegisteredSoundEvent("entity.zombie.hurt");
			ENTITY_ZOMBIE_INFECT = getRegisteredSoundEvent("entity.zombie.infect");
			ENTITY_ZOMBIE_PIG_AMBIENT = getRegisteredSoundEvent("entity.zombie_pig.ambient");
			ENTITY_ZOMBIE_PIG_ANGRY = getRegisteredSoundEvent("entity.zombie_pig.angry");
			ENTITY_ZOMBIE_PIG_DEATH = getRegisteredSoundEvent("entity.zombie_pig.death");
			ENTITY_ZOMBIE_PIG_HURT = getRegisteredSoundEvent("entity.zombie_pig.hurt");
			ENTITY_ZOMBIE_STEP = getRegisteredSoundEvent("entity.zombie.step");
			ENTITY_ZOMBIE_VILLAGER_AMBIENT = getRegisteredSoundEvent("entity.zombie_villager.ambient");
			ENTITY_ZOMBIE_VILLAGER_CONVERTED = getRegisteredSoundEvent("entity.zombie_villager.converted");
			ENTITY_ZOMBIE_VILLAGER_CURE = getRegisteredSoundEvent("entity.zombie_villager.cure");
			ENTITY_ZOMBIE_VILLAGER_DEATH = getRegisteredSoundEvent("entity.zombie_villager.death");
			ENTITY_ZOMBIE_VILLAGER_HURT = getRegisteredSoundEvent("entity.zombie_villager.hurt");
			ENTITY_ZOMBIE_VILLAGER_STEP = getRegisteredSoundEvent("entity.zombie_villager.step");
		}
	}
}
