package net.minecraft.item;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ItemBucket extends Item {
	/** field for checking if the bucket has been filled. */
	private final Block containedBlock;

	public ItemBucket(Block containedBlockIn) {
		this.maxStackSize = 1;
		this.containedBlock = containedBlockIn;
		this.setCreativeTab(CreativeTabs.MISC);
	}

	public ActionResult<ItemStack> onItemRightClick(World itemStackIn, EntityPlayer worldIn, EnumHand playerIn) {
		boolean flag = this.containedBlock == Blocks.AIR;
		ItemStack itemstack = worldIn.getHeldItem(playerIn);
		RayTraceResult raytraceresult = this.rayTrace(itemStackIn, worldIn, flag);

		if (raytraceresult == null) {
			return new ActionResult<ItemStack>(EnumActionResult.PASS, itemstack);
		} else if (raytraceresult.typeOfHit != RayTraceResult.Type.BLOCK) {
			return new ActionResult<ItemStack>(EnumActionResult.PASS, itemstack);
		} else {
			BlockPos blockpos = raytraceresult.getBlockPos();

			if (!itemStackIn.isBlockModifiable(worldIn, blockpos)) {
				return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
			} else if (flag) {
				if (!worldIn.canPlayerEdit(blockpos.offset(raytraceresult.sideHit), raytraceresult.sideHit,
						itemstack)) {
					return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
				} else {
					IBlockState iblockstate = itemStackIn.getBlockState(blockpos);
					Material material = iblockstate.getMaterial();

					if (material == Material.WATER
							&& ((Integer) iblockstate.getValue(BlockLiquid.LEVEL)).intValue() == 0) {
						itemStackIn.setBlockState(blockpos, Blocks.AIR.getDefaultState(), 11);
						worldIn.addStat(StatList.getObjectUseStats(this));
						worldIn.playSound(SoundEvents.ITEM_BUCKET_FILL, 1.0F, 1.0F);
						return new ActionResult<ItemStack>(EnumActionResult.SUCCESS,
								this.fillBucket(itemstack, worldIn, Items.WATER_BUCKET));
					} else if (material == Material.LAVA
							&& ((Integer) iblockstate.getValue(BlockLiquid.LEVEL)).intValue() == 0) {
						worldIn.playSound(SoundEvents.ITEM_BUCKET_FILL_LAVA, 1.0F, 1.0F);
						itemStackIn.setBlockState(blockpos, Blocks.AIR.getDefaultState(), 11);
						worldIn.addStat(StatList.getObjectUseStats(this));
						return new ActionResult<ItemStack>(EnumActionResult.SUCCESS,
								this.fillBucket(itemstack, worldIn, Items.LAVA_BUCKET));
					} else {
						return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
					}
				}
			} else {
				boolean flag1 = itemStackIn.getBlockState(blockpos).getBlock().isReplaceable(itemStackIn, blockpos);
				BlockPos blockpos1 = flag1 && raytraceresult.sideHit == EnumFacing.UP ? blockpos
						: blockpos.offset(raytraceresult.sideHit);

				if (!worldIn.canPlayerEdit(blockpos1, raytraceresult.sideHit, itemstack)) {
					return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
				} else if (this.tryPlaceContainedLiquid(worldIn, itemStackIn, blockpos1)) {
					if (worldIn instanceof EntityPlayerMP) {
						CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP) worldIn, blockpos1, itemstack);
					}

					worldIn.addStat(StatList.getObjectUseStats(this));
					return !worldIn.capabilities.isCreativeMode
							? new ActionResult(EnumActionResult.SUCCESS, new ItemStack(Items.BUCKET))
							: new ActionResult(EnumActionResult.SUCCESS, itemstack);
				} else {
					return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
				}
			}
		}
	}

	private ItemStack fillBucket(ItemStack emptyBuckets, EntityPlayer player, Item fullBucket) {
		if (player.capabilities.isCreativeMode) {
			return emptyBuckets;
		} else {
			emptyBuckets.func_190918_g(1);

			if (emptyBuckets.func_190926_b()) {
				return new ItemStack(fullBucket);
			} else {
				if (!player.inventory.addItemStackToInventory(new ItemStack(fullBucket))) {
					player.dropItem(new ItemStack(fullBucket), false);
				}

				return emptyBuckets;
			}
		}
	}

	public boolean tryPlaceContainedLiquid(@Nullable EntityPlayer player, World worldIn, BlockPos posIn) {
		if (this.containedBlock == Blocks.AIR) {
			return false;
		} else {
			IBlockState iblockstate = worldIn.getBlockState(posIn);
			Material material = iblockstate.getMaterial();
			boolean flag = !material.isSolid();
			boolean flag1 = iblockstate.getBlock().isReplaceable(worldIn, posIn);

			if (!worldIn.isAirBlock(posIn) && !flag && !flag1) {
				return false;
			} else {
				if (worldIn.provider.doesWaterVaporize() && this.containedBlock == Blocks.FLOWING_WATER) {
					int l = posIn.getX();
					int i = posIn.getY();
					int j = posIn.getZ();
					worldIn.playSound(player, posIn, SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.BLOCKS, 0.5F,
							2.6F + (worldIn.rand.nextFloat() - worldIn.rand.nextFloat()) * 0.8F);

					for (int k = 0; k < 8; ++k) {
						worldIn.spawnParticle(EnumParticleTypes.SMOKE_LARGE, (double) l + Math.random(),
								(double) i + Math.random(), (double) j + Math.random(), 0.0D, 0.0D, 0.0D);
					}
				} else {
					if (!worldIn.isRemote && (flag || flag1) && !material.isLiquid()) {
						worldIn.destroyBlock(posIn, true);
					}

					SoundEvent soundevent = this.containedBlock == Blocks.FLOWING_LAVA
							? SoundEvents.ITEM_BUCKET_EMPTY_LAVA
							: SoundEvents.ITEM_BUCKET_EMPTY;
					worldIn.playSound(player, posIn, soundevent, SoundCategory.BLOCKS, 1.0F, 1.0F);
					worldIn.setBlockState(posIn, this.containedBlock.getDefaultState(), 11);
				}

				return true;
			}
		}
	}
}
