package net.minecraft.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemSlab extends ItemBlock {
	private final BlockSlab singleSlab;
	private final BlockSlab doubleSlab;

	public ItemSlab(Block block, BlockSlab singleSlab, BlockSlab doubleSlab) {
		super(block);
		this.singleSlab = singleSlab;
		this.doubleSlab = doubleSlab;
		this.setMaxDamage(0);
		this.setHasSubtypes(true);
	}

	/**
	 * Converts the given ItemStack damage value into a metadata value to be placed
	 * in the world when this Item is placed as a Block (mostly used with
	 * ItemBlocks).
	 */
	public int getMetadata(int damage) {
		return damage;
	}

	/**
	 * Returns the unlocalized name of this item. This version accepts an ItemStack
	 * so different stacks can have different names based on their damage or NBT.
	 */
	public String getUnlocalizedName(ItemStack stack) {
		return this.singleSlab.getUnlocalizedName(stack.getMetadata());
	}

	/**
	 * Called when a Block is right-clicked with this Item
	 */
	public EnumActionResult onItemUse(EntityPlayer stack, World playerIn, BlockPos worldIn, EnumHand pos,
			EnumFacing hand, float facing, float hitX, float hitY) {
		ItemStack itemstack = stack.getHeldItem(pos);

		if (!itemstack.func_190926_b() && stack.canPlayerEdit(worldIn.offset(hand), hand, itemstack)) {
			Comparable<?> comparable = this.singleSlab.getTypeForItem(itemstack);
			IBlockState iblockstate = playerIn.getBlockState(worldIn);

			if (iblockstate.getBlock() == this.singleSlab) {
				IProperty<?> iproperty = this.singleSlab.getVariantProperty();
				Comparable<?> comparable1 = iblockstate.getValue(iproperty);
				BlockSlab.EnumBlockHalf blockslab$enumblockhalf = (BlockSlab.EnumBlockHalf) iblockstate
						.getValue(BlockSlab.HALF);

				if ((hand == EnumFacing.UP && blockslab$enumblockhalf == BlockSlab.EnumBlockHalf.BOTTOM
						|| hand == EnumFacing.DOWN && blockslab$enumblockhalf == BlockSlab.EnumBlockHalf.TOP)
						&& comparable1 == comparable) {
					IBlockState iblockstate1 = this.makeState(iproperty, comparable1);
					AxisAlignedBB axisalignedbb = iblockstate1.getCollisionBoundingBox(playerIn, worldIn);

					if (axisalignedbb != Block.NULL_AABB
							&& playerIn.checkNoEntityCollision(axisalignedbb.offset(worldIn))
							&& playerIn.setBlockState(worldIn, iblockstate1, 11)) {
						SoundType soundtype = this.doubleSlab.getSoundType();
						playerIn.playSound(stack, worldIn, soundtype.getPlaceSound(), SoundCategory.BLOCKS,
								(soundtype.getVolume() + 1.0F) / 2.0F, soundtype.getPitch() * 0.8F);
						itemstack.func_190918_g(1);

						if (stack instanceof EntityPlayerMP) {
							CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP) stack, worldIn, itemstack);
						}
					}

					return EnumActionResult.SUCCESS;
				}
			}

			return this.tryPlace(stack, itemstack, playerIn, worldIn.offset(hand), comparable)
					? EnumActionResult.SUCCESS
					: super.onItemUse(stack, playerIn, worldIn, pos, hand, facing, hitX, hitY);
		} else {
			return EnumActionResult.FAIL;
		}
	}

	public boolean canPlaceBlockOnSide(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player,
			ItemStack stack) {
		BlockPos blockpos = pos;
		IProperty<?> iproperty = this.singleSlab.getVariantProperty();
		Comparable<?> comparable = this.singleSlab.getTypeForItem(stack);
		IBlockState iblockstate = worldIn.getBlockState(pos);

		if (iblockstate.getBlock() == this.singleSlab) {
			boolean flag = iblockstate.getValue(BlockSlab.HALF) == BlockSlab.EnumBlockHalf.TOP;

			if ((side == EnumFacing.UP && !flag || side == EnumFacing.DOWN && flag)
					&& comparable == iblockstate.getValue(iproperty)) {
				return true;
			}
		}

		pos = pos.offset(side);
		IBlockState iblockstate1 = worldIn.getBlockState(pos);
		return iblockstate1.getBlock() == this.singleSlab && comparable == iblockstate1.getValue(iproperty) ? true
				: super.canPlaceBlockOnSide(worldIn, blockpos, side, player, stack);
	}

	private boolean tryPlace(EntityPlayer player, ItemStack stack, World worldIn, BlockPos pos, Object itemSlabType) {
		IBlockState iblockstate = worldIn.getBlockState(pos);

		if (iblockstate.getBlock() == this.singleSlab) {
			Comparable<?> comparable = iblockstate.getValue(this.singleSlab.getVariantProperty());

			if (comparable == itemSlabType) {
				IBlockState iblockstate1 = this.makeState(this.singleSlab.getVariantProperty(), comparable);
				AxisAlignedBB axisalignedbb = iblockstate1.getCollisionBoundingBox(worldIn, pos);

				if (axisalignedbb != Block.NULL_AABB && worldIn.checkNoEntityCollision(axisalignedbb.offset(pos))
						&& worldIn.setBlockState(pos, iblockstate1, 11)) {
					SoundType soundtype = this.doubleSlab.getSoundType();
					worldIn.playSound(player, pos, soundtype.getPlaceSound(), SoundCategory.BLOCKS,
							(soundtype.getVolume() + 1.0F) / 2.0F, soundtype.getPitch() * 0.8F);
					stack.func_190918_g(1);
				}

				return true;
			}
		}

		return false;
	}

	protected <T extends Comparable<T>> IBlockState makeState(IProperty<T> p_185055_1_, Comparable<?> p_185055_2_) {
		return this.doubleSlab.getDefaultState().withProperty(p_185055_1_, (T) p_185055_2_);
	}
}
