package net.minecraft.item.crafting;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

import java.util.Iterator;
import java.util.List;

import javax.annotation.Nullable;

import net.lax1dude.eaglercraft.EagRuntime;
import net.lax1dude.eaglercraft.IOUtils;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.World;
import net.peyton.eagler.resources.RecipeLoader;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class CraftingManager {
	private static final Logger logger = LogManager.getLogger();
	private static int field_193381_c;
	public static final RegistryNamespaced<ResourceLocation, IRecipe> field_193380_a = new RegistryNamespaced<ResourceLocation, IRecipe>();

	public static boolean func_193377_a() {
		try {
			func_193379_a("armordye", new RecipesArmorDyes());
			func_193379_a("bookcloning", new RecipeBookCloning());
			func_193379_a("mapcloning", new RecipesMapCloning());
			func_193379_a("mapextending", new RecipesMapExtending());
			func_193379_a("fireworks", new RecipeFireworks());
			func_193379_a("repairitem", new RecipeRepairItem());
			func_193379_a("tippedarrow", new RecipeTippedArrow());
			func_193379_a("bannerduplicate", new RecipesBanners.RecipeDuplicatePattern());
			func_193379_a("banneraddpattern", new RecipesBanners.RecipeAddPattern());
			func_193379_a("shielddecoration", new ShieldRecipes.Decoration());
			func_193379_a("shulkerboxcoloring", new ShulkerBoxRecipes.ShulkerBoxColoring());
			return func_192420_c();
		} catch (Throwable var1) {
			return false;
		}
	}

	private static boolean func_192420_c() {
		try {
			List<String> recipes = RecipeLoader.loadRecipes();
			Iterator<String> iterator = recipes.iterator();

			while (iterator.hasNext()) {
				String path1 = iterator.next();

				if (path1.endsWith(".json")) {
					String path2 = path1;
					String s = path2.substring(path2.lastIndexOf("/") + 1).replace(".json", "");
					ResourceLocation resourcelocation = new ResourceLocation(path2);

					try {
						String s1 = "/assets/minecraft/" + path1;
						func_193379_a(s, func_193376_a(new JSONObject(IOUtils
								.inputStreamToString(EagRuntime.getResourceStream(s1), StandardCharsets.UTF_8))));
					} catch (JSONException jsonparseexception) {
						logger.error("Parsing error loading recipe " + resourcelocation,
								(Throwable) jsonparseexception);
						return false;
					} catch (IOException ioexception) {
						logger.error("Couldn't read recipe " + resourcelocation + " from " + path1,
								(Throwable) ioexception);
						return false;
					}
				}
			}

			return true;
		} catch (Exception e) {
			logger.error("Couldn't get a list of all recipe files", (Throwable) e);
			e.printStackTrace();
			return false;
		}
	}

	private static IRecipe func_193376_a(JSONObject p_193376_0_) {
		String s = p_193376_0_.getString("type");

		if ("crafting_shaped".equals(s)) {
			return ShapedRecipes.func_193362_a(p_193376_0_);
		} else if ("crafting_shapeless".equals(s)) {
			return ShapelessRecipes.func_193363_a(p_193376_0_);
		} else {
			throw new JSONException("Invalid or unsupported recipe type '" + s + "'");
		}
	}

	public static void func_193379_a(String p_193379_0_, IRecipe p_193379_1_) {
		func_193372_a(new ResourceLocation(p_193379_0_), p_193379_1_);
	}

	public static void func_193372_a(ResourceLocation p_193372_0_, IRecipe p_193372_1_) {
		if (field_193380_a.containsKey(p_193372_0_)) {
			throw new IllegalStateException("Duplicate recipe ignored with ID " + p_193372_0_);
		} else {
			field_193380_a.register(field_193381_c++, p_193372_0_, p_193372_1_);
		}
	}

	/**
	 * Retrieves an ItemStack that has multiple recipes for it.
	 */
	public static ItemStack findMatchingRecipe(InventoryCrafting p_82787_0_, World craftMatrix) {
		for (IRecipe irecipe : field_193380_a) {
			if (irecipe.matches(p_82787_0_, craftMatrix)) {
				return irecipe.getCraftingResult(p_82787_0_);
			}
		}

		return ItemStack.field_190927_a;
	}

	@Nullable
	public static IRecipe func_192413_b(InventoryCrafting p_192413_0_, World p_192413_1_) {
		for (IRecipe irecipe : field_193380_a) {
			if (irecipe.matches(p_192413_0_, p_192413_1_)) {
				return irecipe;
			}
		}

		return null;
	}

	public static NonNullList<ItemStack> getRemainingItems(InventoryCrafting p_180303_0_, World craftMatrix) {
		for (IRecipe irecipe : field_193380_a) {
			if (irecipe.matches(p_180303_0_, craftMatrix)) {
				return irecipe.getRemainingItems(p_180303_0_);
			}
		}

		NonNullList<ItemStack> nonnulllist = NonNullList.<ItemStack>func_191197_a(p_180303_0_.getSizeInventory(),
				ItemStack.field_190927_a);

		for (int i = 0; i < nonnulllist.size(); ++i) {
			nonnulllist.set(i, p_180303_0_.getStackInSlot(i));
		}

		return nonnulllist;
	}

	@Nullable
	public static IRecipe func_193373_a(ResourceLocation p_193373_0_) {
		return field_193380_a.getObject(p_193373_0_);
	}

	public static int func_193375_a(IRecipe p_193375_0_) {
		return field_193380_a.getIDForObject(p_193375_0_);
	}

	@Nullable
	public static IRecipe func_193374_a(int p_193374_0_) {
		return field_193380_a.getObjectById(p_193374_0_);
	}
}
