package net.minecraft.network.login.client;

import java.io.IOException;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.login.INetHandlerLoginServer;

public class CPacketEncryptionResponse implements Packet<INetHandlerLoginServer> {
	private byte[] secretKeyEncrypted = new byte[0];
	private byte[] verifyTokenEncrypted = new byte[0];

	public CPacketEncryptionResponse() {
	}

//    public CPacketEncryptionResponse(SecretKey secret, PublicKey key, byte[] verifyToken)
//    {
//        this.secretKeyEncrypted = CryptManager.encryptData(key, secret.getEncoded());
//        this.verifyTokenEncrypted = CryptManager.encryptData(key, verifyToken);
//    }

	/**
	 * Reads the raw packet data from the data stream.
	 */
	public void readPacketData(PacketBuffer buf) throws IOException {
		this.secretKeyEncrypted = buf.readByteArray();
		this.verifyTokenEncrypted = buf.readByteArray();
	}

	/**
	 * Writes the raw packet data to the data stream.
	 */
	public void writePacketData(PacketBuffer buf) throws IOException {
		buf.writeByteArray(this.secretKeyEncrypted);
		buf.writeByteArray(this.verifyTokenEncrypted);
	}

	/**
	 * Passes this Packet on to the NetHandler for processing.
	 */
	public void processPacket(INetHandlerLoginServer handler) {
		handler.processEncryptionResponse(this);
	}

//    public SecretKey getSecretKey(PrivateKey key)
//    {
//        return CryptManager.decryptSharedKey(key, this.secretKeyEncrypted);
//    }
//
//    public byte[] getVerifyToken(PrivateKey key)
//    {
//        return key == null ? this.verifyTokenEncrypted : CryptManager.decryptData(key, this.verifyTokenEncrypted);
//    }
}
