package net.minecraft.world.chunk.storage;

public class NibbleArrayReader {
	public final byte[] data;
	private final int depthBits;
	private final int depthBitsPlusFour;

	public NibbleArrayReader(byte[] dataIn, int depthBitsIn) {
		this.data = dataIn;
		this.depthBits = depthBitsIn;
		this.depthBitsPlusFour = depthBitsIn + 4;
	}

	public int get(int x, int y, int z) {
		int i = x << this.depthBitsPlusFour | z << this.depthBits | y;
		int j = i >> 1;
		int k = i & 1;
		return k == 0 ? this.data[j] & 15 : this.data[j] >> 4 & 15;
	}
}
