package net.minecraft.world.gen.feature;

import net.lax1dude.eaglercraft.EaglercraftRandom;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenShrub extends WorldGenTrees {
	private final IBlockState leavesMetadata;
	private final IBlockState woodMetadata;

	public WorldGenShrub(IBlockState p_i46450_1_, IBlockState p_i46450_2_) {
		super(false);
		this.woodMetadata = p_i46450_1_;
		this.leavesMetadata = p_i46450_2_;
	}

	public boolean generate(World worldIn, EaglercraftRandom rand, BlockPos position) {
		for (IBlockState iblockstate = worldIn.getBlockState(position); (iblockstate.getMaterial() == Material.AIR
				|| iblockstate.getMaterial() == Material.LEAVES)
				&& position.getY() > 0; iblockstate = worldIn.getBlockState(position)) {
			position = position.down();
		}

		Block block = worldIn.getBlockState(position).getBlock();

		if (block == Blocks.DIRT || block == Blocks.GRASS) {
			position = position.up();
			this.setBlockAndNotifyAdequately(worldIn, position, this.woodMetadata);

			for (int i = position.getY(); i <= position.getY() + 2; ++i) {
				int j = i - position.getY();
				int k = 2 - j;

				for (int l = position.getX() - k; l <= position.getX() + k; ++l) {
					int i1 = l - position.getX();

					for (int j1 = position.getZ() - k; j1 <= position.getZ() + k; ++j1) {
						int k1 = j1 - position.getZ();

						if (Math.abs(i1) != k || Math.abs(k1) != k || rand.nextInt(2) != 0) {
							BlockPos blockpos = new BlockPos(l, i, j1);
							Material material = worldIn.getBlockState(blockpos).getMaterial();

							if (material == Material.AIR || material == Material.LEAVES) {
								this.setBlockAndNotifyAdequately(worldIn, blockpos, this.leavesMetadata);
							}
						}
					}
				}
			}
		}

		return true;
	}
}
