package net.minecraft.world.gen.layer;

public class GenLayerIsland extends GenLayer {
	public GenLayerIsland(long p_i2124_1_) {
		super(p_i2124_1_);
	}

	/**
	 * Returns a list of integer values generated by this layer. These may be
	 * interpreted as temperatures, rainfall amounts, or biomeList[] indices based
	 * on the particular GenLayer subclass.
	 */
	public int[] getInts(int areaX, int areaY, int areaWidth, int areaHeight) {
		int[] aint = IntCache.getIntCache(areaWidth * areaHeight);

		for (int i = 0; i < areaHeight; ++i) {
			for (int j = 0; j < areaWidth; ++j) {
				this.initChunkSeed((long) (areaX + j), (long) (areaY + i));
				aint[j + i * areaWidth] = this.nextInt(10) == 0 ? 1 : 0;
			}
		}

		if (areaX > -areaWidth && areaX <= 0 && areaY > -areaHeight && areaY <= 0) {
			aint[-areaX + -areaY * areaWidth] = 1;
		}

		return aint;
	}
}
