package net.minecraft.world.gen.layer;

public class GenLayerZoom extends GenLayer {
	public GenLayerZoom(long p_i2134_1_, GenLayer p_i2134_3_) {
		super(p_i2134_1_);
		super.parent = p_i2134_3_;
	}

	/**
	 * Returns a list of integer values generated by this layer. These may be
	 * interpreted as temperatures, rainfall amounts, or biomeList[] indices based
	 * on the particular GenLayer subclass.
	 */
	public int[] getInts(int areaX, int areaY, int areaWidth, int areaHeight) {
		int i = areaX >> 1;
		int j = areaY >> 1;
		int k = (areaWidth >> 1) + 2;
		int l = (areaHeight >> 1) + 2;
		int[] aint = this.parent.getInts(i, j, k, l);
		int i1 = k - 1 << 1;
		int j1 = l - 1 << 1;
		int[] aint1 = IntCache.getIntCache(i1 * j1);

		for (int k1 = 0; k1 < l - 1; ++k1) {
			int l1 = (k1 << 1) * i1;
			int i2 = 0;
			int j2 = aint[i2 + 0 + (k1 + 0) * k];

			for (int k2 = aint[i2 + 0 + (k1 + 1) * k]; i2 < k - 1; ++i2) {
				this.initChunkSeed((long) (i2 + i << 1), (long) (k1 + j << 1));
				int l2 = aint[i2 + 1 + (k1 + 0) * k];
				int i3 = aint[i2 + 1 + (k1 + 1) * k];
				aint1[l1] = j2;
				aint1[l1++ + i1] = this.selectRandom(new int[] { j2, k2 });
				aint1[l1] = this.selectRandom(new int[] { j2, l2 });
				aint1[l1++ + i1] = this.selectModeOrRandom(j2, l2, k2, i3);
				j2 = l2;
				k2 = i3;
			}
		}

		int[] aint2 = IntCache.getIntCache(areaWidth * areaHeight);

		for (int j3 = 0; j3 < areaHeight; ++j3) {
			System.arraycopy(aint1, (j3 + (areaY & 1)) * i1 + (areaX & 1), aint2, j3 * areaWidth, areaWidth);
		}

		return aint2;
	}

	/**
	 * Magnify a layer. Parms are seed adjustment, layer, number of times to magnify
	 */
	public static GenLayer magnify(long p_75915_0_, GenLayer p_75915_2_, int p_75915_3_) {
		GenLayer genlayer = p_75915_2_;

		for (int i = 0; i < p_75915_3_; ++i) {
			genlayer = new GenLayerZoom(p_75915_0_ + (long) i, genlayer);
		}

		return genlayer;
	}
}
