package com.carrotsearch.hppc;

import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.procedures.CharProcedure;
import java.util.Deque;
import java.util.Iterator;

/**
 * A linear collection that supports element insertion and removal at both ends.
 *
 * @see Deque
 */
@com.carrotsearch.hppc.Generated(date = "2024-06-04T15:20:17+0200", value = "KTypeDeque.java")
public interface CharDeque extends CharCollection {
	/**
	 * Removes the first element that equals <code>e</code>.
	 *
	 * @return The deleted element's index or <code>-1</code> if the element was not
	 *         found.
	 */
	public int removeFirst(char e);

	/**
	 * Removes the last element that equals <code>e</code>.
	 *
	 * @return The deleted element's index or <code>-1</code> if the element was not
	 *         found.
	 */
	public int removeLast(char e);

	/** Inserts the specified element at the front of this deque. */
	public void addFirst(char e);

	/** Inserts the specified element at the end of this deque. */
	public void addLast(char e);

	/**
	 * Retrieves and removes the first element of this deque.
	 *
	 * @return the head (first) element of this deque.
	 */
	public char removeFirst();

	/**
	 * Retrieves and removes the last element of this deque.
	 *
	 * @return the tail of this deque.
	 */
	public char removeLast();

	/**
	 * Retrieves the first element of this deque but does not remove it.
	 *
	 * @return the head of this deque.
	 */
	public char getFirst();

	/**
	 * Retrieves the last element of this deque but does not remove it.
	 *
	 * @return the head of this deque.
	 */
	public char getLast();

	/**
	 * @return An iterator over elements in this deque in tail-to-head order.
	 */
	public Iterator<CharCursor> descendingIterator();

	/** Applies a <code>procedure</code> to all elements in tail-to-head order. */
	public <T extends CharProcedure> T descendingForEach(T procedure);

	/**
	 * Applies a <code>predicate</code> to container elements as long, as the
	 * predicate returns <code>
	 * true</code>. The iteration is interrupted otherwise.
	 */
	public <T extends CharPredicate> T descendingForEach(T predicate);
}
