package net.lax1dude.eaglercraft.socket.protocol.pkt.server;

import java.io.IOException;

import net.lax1dude.eaglercraft.socket.protocol.GamePacketInputBuffer;
import net.lax1dude.eaglercraft.socket.protocol.GamePacketOutputBuffer;
import net.lax1dude.eaglercraft.socket.protocol.pkt.GameMessageHandler;
import net.lax1dude.eaglercraft.socket.protocol.pkt.GameMessagePacket;

/**
 * Copyright (c) 2024 lax1dude. All Rights Reserved.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 */
public class SPacketForceClientSkinCustomV4EAG implements GameMessagePacket {

	public int modelID;
	public byte[] customSkin;

	public SPacketForceClientSkinCustomV4EAG() {
	}

	public SPacketForceClientSkinCustomV4EAG(int modelID, byte[] customSkin) {
		this.modelID = modelID;
		this.customSkin = customSkin;
	}

	@Override
	public void readPacket(GamePacketInputBuffer buffer) throws IOException {
		modelID = buffer.readUnsignedByte();
		customSkin = new byte[12288];
		buffer.readFully(customSkin);
	}

	@Override
	public void writePacket(GamePacketOutputBuffer buffer) throws IOException {
		if(customSkin.length != 12288) {
			throw new IOException("Custom skin data length is not 12288 bytes! (" + customSkin.length + ")");
		}
		buffer.write(modelID);
		buffer.write(customSkin);
	}

	@Override
	public void handlePacket(GameMessageHandler handler) {
		handler.handleServer(this);
	}

	@Override
	public int length() {
		return 12289;
	}

}
